/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.common.bean;

import java.util.Calendar;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.common.TimeUtils;

public class AddressRange {
    private int id;
    private int contractId;
    private int objectId;
    private Calendar date1;
    private Calendar date2;
    private int port1;
    private int port2;
    private long addr1;
    private long addr2;
    private String comment;
    private String sources;
    private int planId;
    private int personalPlanId;
    private int mask = -1;
    private int resourceId;

    public final int getResourceId() {
        return this.resourceId;
    }

    public final void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }

    public int getPersonalPlanId() {
        return this.personalPlanId;
    }

    public void setPersonalPlanId(int personalPlanId) {
        this.personalPlanId = personalPlanId;
    }

    public int getPlanId() {
        return this.planId;
    }

    public void setPlanId(int planId) {
        this.planId = planId;
    }

    public Calendar getDate1() {
        return this.date1;
    }

    public void setDate1(Calendar date1) {
        this.date1 = date1;
    }

    public Calendar getDate2() {
        return this.date2;
    }

    public void setDate2(Calendar date2) {
        this.date2 = date2;
    }

    public int getPort1() {
        return this.port1;
    }

    public void setPort1(int port1) {
        this.port1 = port1;
    }

    public int getPort2() {
        return this.port2;
    }

    public void setPort2(int port2) {
        this.port2 = port2;
    }

    public int getContractId() {
        return this.contractId;
    }

    @Deprecated
    public int getContractID() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    @Deprecated
    public void setContractID(int contractId) {
        this.contractId = contractId;
    }

    public int getId() {
        return this.id;
    }

    @Deprecated
    public int getID() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Deprecated
    public void setID(int id) {
        this.id = id;
    }

    public long getAddr1() {
        return this.addr1;
    }

    public void setAddr1(long addr1) {
        this.addr1 = addr1;
    }

    public long getAddr2() {
        return this.addr2;
    }

    public void setAddr2(long addr2) {
        this.addr2 = addr2;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String checkAddressRange() {
        String result = null;
        if (this.mask >= 0) {
            if (this.addr1 < 0L || this.addr1 > 0xFFFFFFFFL) {
                result = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u0430\u0434\u0440\u0435\u0441";
            } else if (this.mask > 32) {
                result = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043c\u0430\u0441\u043a\u0430";
            }
        } else if (this.addr1 < 0L || this.addr1 > 0xFFFFFFFFL || this.addr2 < 0L || this.addr2 > 0xFFFFFFFFL || this.addr1 > this.addr2) {
            result = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432";
        }
        if (result != null) {
            if (this.port1 < 0 || this.port1 > 65535 || this.port2 < 0 || this.port2 > 65535 || this.port1 > this.port2) {
                result = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043f\u043e\u0440\u0442\u043e\u0432";
            } else if (this.date1 == null || this.date2 != null && this.date1.after(this.date2)) {
                result = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u0442\u044b";
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(IPUtils.convertLongIpToString((long)this.addr1));
        if (this.addr2 != this.addr1) {
            sb.append(" - ");
            sb.append(IPUtils.convertLongIpToString((long)this.addr2));
        }
        sb.append("(");
        sb.append(TimeUtils.format((Calendar)this.date1, (String)"dd.MM.yyyy"));
        sb.append("-");
        sb.append(TimeUtils.format((Calendar)this.date2, (String)"dd.MM.yyyy"));
        sb.append(") ");
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        sb.append(IPUtils.convertLongIpToString((long)this.addr1));
        if (this.addr2 != this.addr1) {
            sb.append(" - ");
            sb.append(IPUtils.convertLongIpToString((long)this.addr2));
        }
        return sb.toString();
    }

    public String toString(StringBuilder sources) {
        StringBuilder sb = new StringBuilder();
        sb.append(IPUtils.convertLongIpToString((long)this.addr1));
        if (this.addr2 != this.addr1) {
            sb.append("-");
            sb.append(IPUtils.convertLongIpToString((long)this.addr2));
        }
        sb.append(" ");
        sb.append((CharSequence)sources);
        sb.append(" (");
        sb.append(TimeUtils.format((Calendar)this.date1, (String)"dd.MM.yyyy"));
        sb.append("-");
        sb.append(TimeUtils.format((Calendar)this.date2, (String)"dd.MM.yyyy"));
        sb.append(") ");
        return sb.toString();
    }

    public String toStringWithoutSource() {
        StringBuilder sb = new StringBuilder();
        sb.append(IPUtils.convertLongIpToString((long)this.addr1));
        if (this.addr2 != this.addr1) {
            sb.append(" - ");
            sb.append(IPUtils.convertLongIpToString((long)this.addr2));
        }
        sb.append(" (");
        sb.append(TimeUtils.format((Calendar)this.date1, (String)"dd.MM.yyyy"));
        sb.append(" - ");
        sb.append(TimeUtils.format((Calendar)this.date2, (String)"dd.MM.yyyy"));
        sb.append(") ");
        return sb.toString();
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    public String getSources() {
        return this.sources;
    }

    public void setSources(String sources) {
        this.sources = sources;
    }

    public int getMask() {
        return this.mask;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }
}

