/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServOption;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class InetServOptionDao
extends AbstractDao<InetServOption> {
    public InetServOptionDao(Connection con, int mid) {
        super(con, mid, "inet_serv_option");
    }

    protected InetServOption getFromRS(ResultSet rs) throws SQLException, BGException {
        InetServOption result = new InetServOption();
        result.setOptionId(rs.getInt("optionId"));
        result.setServiceId(rs.getInt("servId"));
        result.setDateFrom((Date)rs.getDate("dateFrom"));
        result.setDateTo((Date)rs.getDate("dateTo"));
        return result;
    }

    public List<InetServOption> list(int serviceId) throws BGException {
        return this.list("servId=?", null, new Object[]{serviceId});
    }

    public int deleteByServId(int servId) throws Exception {
        return this.delete("servId=?", new Object[]{servId});
    }

    public void update(int servId, List<InetServOption> list) throws BGException {
        block9: {
            try {
                this.deleteByServId(servId);
                if (list == null || list.isEmpty()) break block9;
                String sql = "INSERT INTO " + this.tableName + " SET optionId=?, servId=?, dateFrom=?, dateTo=?";
                try (PreparedStatement ps = this.con.prepareStatement(sql);){
                    for (InetServOption servOpt : list) {
                        ps.setInt(1, servOpt.getOptionId());
                        ps.setInt(2, servId);
                        ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)servOpt.getDateFrom()));
                        ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)servOpt.getDateTo()));
                        ps.executeUpdate();
                    }
                }
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public boolean optionIsUsed(int optionId) throws BGException {
        boolean result = false;
        try {
            String sql = "SELECT COUNT(*)  FROM " + this.tableName + " WHERE optionId = ? ";
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(1, optionId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1) > 0;
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<InetServOption> getInetServRealtimeOptionList(int inetServId, Date fromDate) throws BGException {
        try {
            ArrayList<InetServOption> result = new ArrayList<InetServOption>();
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ");
            query.append(this.tableName);
            query.append(" WHERE servId=? AND (dateTo IS NULL OR ?<=dateTo) ORDER BY dateFrom");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, inetServId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)fromDate));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected void updateImpl(InetServOption b) throws BGException, SQLException {
    }
}

