/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.bean.enums;

import java.util.stream.Stream;

public enum AccessCode {
    AUTHORIZATION_SUCCEEDED(0, "Ok"),
    INVALID_ACCOUNT(1, "\u041b\u043e\u0433\u0438\u043d \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d"),
    INVALID_PIN(2, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c"),
    TOO_MANY_SESSIONS_ERROR(3, "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u0441\u0435\u0441\u0441\u0438\u0439 \u043f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e"),
    ACCOUNTING_PERIOD_NOT_AVAILABLE(4, "\u0423\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d"),
    SERVICE_LOCKED(10, "\u0421\u0435\u0440\u0432\u0438\u0441 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d"),
    CONTRACT_LOCKED(11, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d"),
    BALANCE_INSUFFICIENT(12, "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432"),
    SERVICE_CLOSED(20, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0437\u0430\u043a\u0440\u044b\u0442"),
    CARD_EXPIRED(30, "\u041a\u0430\u0440\u0442\u0430 \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u0430"),
    CARD_LOCKED(31, "\u041a\u0430\u0440\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430"),
    CARD_FOR_BALANCE(32, "CARD_FOR_BALANCE"),
    CARD_ACTIVATED_BALANCE(34, "\u041a\u0430\u0440\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0434\u043b\u044f \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0431\u0430\u043b\u0430\u043d\u0441\u0430"),
    NAS_DENY(40, "\u0414\u043e\u0441\u0442\u0443\u043f \u043a \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0443 (NAS'\u0443) \u0437\u0430\u043a\u0440\u044b\u0442"),
    SERVICE_DENY(41, "\u0414\u043e\u0441\u0442\u0443\u043f \u043a \u0443\u0441\u043b\u0443\u0433\u0435 \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d"),
    USER_DENY(42, "USER_DENY"),
    REALM_DENY(43, "\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0430\u043b\u043c"),
    AUTH_DENY(44, "\u0414\u043e\u0441\u0442\u0443\u043f \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d"),
    DESTINATION_DENY(45, "DESTINATION_DENY"),
    MAC_DENY(46, "MAC-\u0430\u0434\u0440\u0435\u0441 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d"),
    IDENTIFIER_DENY(47, "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d"),
    IP_ADDRESS_DENY(48, "IP-\u0430\u0434\u0440\u0435\u0441 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d"),
    USER_BANNED(49, "\u0411\u0430\u043d \u043f\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"),
    NAS_NOT_FOUND(60, "NAS_NOT_FOUND"),
    SERVICE_NOT_FOUND(61, "SERVICE_NOT_FOUND"),
    TARIFF_NOT_FOUND(62, "\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d"),
    PRICE_NOT_FOUND(63, "\u0426\u0435\u043d\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430"),
    CALL_TYPE_NOT_RECOGNIZED(64, "CALL_TYPE_NOT_RECOGNIZED"),
    DESTINATION_NOT_FOUND(65, "DESTINATION_NOT_FOUND"),
    FREE_IP_ADDRESS_NOT_FOUND(80, "\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0439 IP-\u0430\u0434\u0440\u0435\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d"),
    SYSTEM_ERROR(100, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430"),
    REQUEST_SKIPPED(110, "REQUEST_SKIPPED");

    private final int code;
    private final String title;

    private AccessCode(int code, String title) {
        this.code = code;
        this.title = title;
    }

    public int getCode() {
        return this.code;
    }

    public String getTitle() {
        return this.title;
    }

    public static AccessCode getAccessCode(int code) {
        return Stream.of(AccessCode.values()).filter(a -> a.getCode() == code).findFirst().orElse(null);
    }
}

