/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.utils;

import java.util.StringTokenizer;

public class BGByteBuffer {
    private byte[] buffer;

    public BGByteBuffer() {
        this.buffer = new byte[0];
    }

    public BGByteBuffer(byte[] buf) {
        this(buf, buf.length);
    }

    public BGByteBuffer(byte[] buf, int len) {
        this.assign(buf, len);
    }

    public BGByteBuffer(BGByteBuffer buf) {
        this(buf.getBytes());
    }

    public BGByteBuffer(byte b) {
        this.buffer = new byte[]{b};
    }

    public BGByteBuffer(String hexDump) {
        StringTokenizer st = new StringTokenizer(hexDump, " ");
        int i = 0;
        int cnt = st.countTokens();
        this.buffer = new byte[cnt];
        while (st.hasMoreElements()) {
            String curr = st.nextToken();
            Integer v = Integer.valueOf(curr, 16);
            this.buffer[i] = v.byteValue();
            ++i;
        }
    }

    public void assign(byte[] buf, int len) {
        len = Math.min(len, buf.length);
        this.buffer = new byte[len];
        System.arraycopy(buf, 0, this.buffer, 0, len);
    }

    public void assign(BGByteBuffer buf) {
        this.assign(buf.getBytes(), buf.getBytes().length);
    }

    public void fillBytes(byte value, int lenght) {
        this.buffer = new byte[lenght];
        for (int i = 0; i < lenght; ++i) {
            this.buffer[i] = value;
        }
    }

    public String toString() {
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < this.buffer.length; ++i) {
            String shex = BGByteBuffer.toString(this.buffer[i]);
            hex.append(shex).append(" ");
        }
        return hex.toString().trim();
    }

    public static String toString(byte b) {
        return BGByteBuffer.toString(BGByteBuffer.byte2int(b));
    }

    public static String toString(int dumpi) {
        Object shex = Integer.toHexString(dumpi).toUpperCase();
        if (((String)shex).length() == 1) {
            shex = "0" + (String)shex;
        }
        return shex;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    public boolean equals(BGByteBuffer obj) {
        if (this.buffer.length != obj.getBytes().length) {
            return false;
        }
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] == obj.getBytes()[i]) continue;
            return false;
        }
        return true;
    }

    public BGByteBuffer subbyte(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            return null;
        }
        if (endIndex > this.buffer.length) {
            return null;
        }
        if (beginIndex > endIndex) {
            return null;
        }
        byte[] newsub = new byte[endIndex - beginIndex];
        System.arraycopy(this.buffer, beginIndex, newsub, 0, endIndex - beginIndex);
        return new BGByteBuffer(newsub);
    }

    public int indexOf(BGByteBuffer obj) {
        return BGByteBuffer.indexOf(this.buffer, 0, this.buffer.length, obj.getBytes(), 0, obj.getBytes().length, 0);
    }

    public int indexOf(byte[] target, int targetCount) {
        return BGByteBuffer.indexOf(this.buffer, 0, this.buffer.length, target, 0, targetCount, 0);
    }

    public BGByteBuffer pushEnd(byte[] putbuff, int len) {
        len = Math.min(putbuff.length, len);
        byte[] newBuffer = new byte[this.buffer.length + len];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
        System.arraycopy(putbuff, 0, newBuffer, this.buffer.length, len);
        this.buffer = newBuffer;
        return this;
    }

    public BGByteBuffer pushEnd(byte putbyte) {
        return this.pushEnd(new byte[]{putbyte}, 1);
    }

    public BGByteBuffer pushEnd(BGByteBuffer putbuff) {
        return this.pushEnd(putbuff.getBytes(), putbuff.getBytes().length);
    }

    public BGByteBuffer pushBegin(byte[] putbuff, int len) {
        len = Math.min(putbuff.length, len);
        byte[] newBuffer = new byte[this.buffer.length + len];
        System.arraycopy(putbuff, 0, newBuffer, 0, len);
        System.arraycopy(this.buffer, 0, newBuffer, len, this.buffer.length);
        this.buffer = newBuffer;
        return this;
    }

    public BGByteBuffer pushBegin(BGByteBuffer putbuff) {
        return this.pushBegin(putbuff.getBytes(), putbuff.getBytes().length);
    }

    public BGByteBuffer pushBegin(byte putbyte) {
        return this.pushBegin(new byte[]{putbyte}, 1);
    }

    public BGByteBuffer popBegin(int count) {
        if (this.buffer.length < count) {
            throw new IndexOutOfBoundsException("buffer hasnt " + count + " bytes (has " + this.buffer.length + ")");
        }
        BGByteBuffer result = this.subbyte(0, count);
        byte[] newBuffer = new byte[this.buffer.length - count];
        System.arraycopy(this.buffer, count, newBuffer, 0, this.buffer.length - count);
        this.buffer = newBuffer;
        return result;
    }

    public byte popBeginByte() {
        return this.popBegin((int)1).buffer[0];
    }

    private static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static int byte2int(byte v) {
        return v < 0 ? 256 + v : v;
    }

    public byte getLRC() {
        byte LRC = 0;
        for (int i = 0; i < this.buffer.length; ++i) {
            LRC = (byte)(LRC ^ this.buffer[i]);
        }
        return LRC;
    }

    public void maskbyte(byte byteval, byte bytemask) {
        byte[] btmp = new byte[this.buffer.length * 2];
        int btpmPos = 0;
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] == byteval) {
                btmp[btpmPos++] = bytemask;
            }
            btmp[btpmPos++] = this.buffer[i];
        }
        this.buffer = new byte[btpmPos];
        System.arraycopy(btmp, 0, this.buffer, 0, btpmPos);
    }

    public void unmaskbyte(byte bytemask) {
        byte[] btmp = new byte[this.buffer.length];
        int btpmPos = 0;
        boolean maskflag = false;
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] == bytemask && !maskflag) {
                maskflag = true;
                continue;
            }
            btmp[btpmPos++] = this.buffer[i];
            maskflag = false;
        }
        this.buffer = new byte[btpmPos];
        System.arraycopy(btmp, 0, this.buffer, 0, btpmPos);
    }

    public void clear() {
        this.buffer = new byte[0];
    }
}

