/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.event.TvAccountCreatedEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.TvAccountDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.TvProductsDeviceStateModifiedEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.db.TvAccountDeviceStateAndOptionsModifyEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.db.TvProductDeviceStateModifyEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.db.TvProductsDeviceStateModifyEvent;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDao;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvApplication;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.oss.systems.inventory.product.common.event.ProductStateEntry;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductDao;
import ru.bitel.oss.systems.inventory.service.common.event.ServiceStateEntry;
import ru.bitel.oss.systems.inventory.service.server.bean.ServiceDao;

public class TvAccountStateAndOptionsDatabaseWorker
extends EventWorker {
    private final TvApplication application;
    private TvAccountDao tvAccountDao = null;
    private ProductDao productDao = null;
    private ServiceDao serviceDao = null;

    public TvAccountStateAndOptionsDatabaseWorker(TvApplication application) throws BGException {
        super(EventProcessor.getInstance(), TvAccountDeviceStateAndOptionsModifyEvent.class.getPackage().getName() + ".*", application.moduleId, -1, null, false, new Class[]{TvAccountDeviceStateAndOptionsModifyEvent.class, TvProductDeviceStateModifyEvent.class, TvProductsDeviceStateModifyEvent.class});
        this.context = new EventListenerContext(application.setup, this.moduleId, SetupParam.getApplicationName());
        this.application = application;
        this.getLogger().info("Starting TvAccountStateAndOptionsDatabaseWorker for moduleId: " + this.moduleId);
        new Thread((Runnable)((Object)this), "dev-state-db-wrkr-" + this.moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        try {
            this.tvAccountDao = new TvAccountDao(((EventListenerContext)this.context).getConnection(), this.application.moduleId);
            this.productDao = new ProductDao(((EventListenerContext)this.context).getConnection());
            this.serviceDao = new ServiceDao(((EventListenerContext)this.context).getConnection());
            boolean bl = this.doTasks();
            return bl;
        }
        finally {
            this.tvAccountDao = null;
            this.productDao = null;
            this.serviceDao = null;
            ((EventListenerContext)this.context).recycle();
        }
    }

    public Object doTask(Object task) throws BGException {
        if (task instanceof TvAccountDeviceStateAndOptionsModifyEvent) {
            TvAccountDeviceStateAndOptionsModifyEvent event = (TvAccountDeviceStateAndOptionsModifyEvent)task;
            if (event.getTimestamp() < System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L)) {
                return null;
            }
            this.getLogger().info("Changing TvAccount:" + event.getTvAccountId() + " state");
            try {
                this.tvAccountDao.updateDeviceStateAndOptions(event.getTvAccountId(), event.getDeviceAccountId(), event.getDeviceState(), event.getDeviceOptionIds(), event.getAccessCode());
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
            ((EventListenerContext)this.context).commit();
            EventProcessor.getInstance().publish((Event)new TvAccountDeviceStateAndOptionsModifiedEvent(event));
            if (event.getOldDeviceState() == -1) {
                EventProcessor.getInstance().publish((Event)new TvAccountCreatedEvent(event.getModuleId(), event.getContractId(), event.getDeviceId(), event.getTvAccountId(), event.getDeviceAccountId(), event.getDeviceState(), event.getDeviceOptionIds()));
            }
        } else if (task instanceof TvProductsDeviceStateModifyEvent) {
            TvProductsDeviceStateModifyEvent event = (TvProductsDeviceStateModifyEvent)task;
            if (event.getTimestamp() < System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L)) {
                return null;
            }
            this.getLogger().info("Changing TvAccount:" + event.getTvAccountId() + " products state");
            for (ProductStateEntry e : event.getProductEntryList()) {
                this.productDao.updateDeviceState(event.getContractId(), event.getTvAccountId(), e.productId, e.deviceProductId, e.deviceState);
                if (e.serviceEntryList == null) continue;
                for (ServiceStateEntry se : e.serviceEntryList) {
                    try {
                        this.serviceDao.updateDeviceState(event.getContractId(), event.getTvAccountId(), se.serviceId, se.deviceState);
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                }
            }
            ((EventListenerContext)this.context).commit();
            EventProcessor.getInstance().publish((Event)new TvProductsDeviceStateModifiedEvent(event));
        }
        return null;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "@" + System.identityHashCode((Object)this);
    }
}

