/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.ip;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.event.Level;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionLog;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterface;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.IpRangeRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.ip.CallConnectionAddressSet;
import ru.bitel.bgbilling.apps.inet.accounting.ip.ConnectionRangeSet;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.common.inet.IpAddress;

public class HourlyCallConnectionSet {
    private final Accounting accounting;
    private final FlowAgentInterface iface;
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentHashMap<Long, Hour> hourlyMap = new ConcurrentHashMap();
    private long currentHour = -1L;
    private Hour current = null;

    public HourlyCallConnectionSet(Accounting accounting, FlowAgentInterface iface) {
        this.accounting = accounting;
        this.iface = iface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hour getHour(Long hour) {
        assert (hour.longValue() == InetUtils.getHour(hour).longValue());
        if (hour == this.currentHour) {
            return this.current;
        }
        Hour hourInstance = this.hourlyMap.get(hour);
        if (hourInstance != null) {
            this.currentHour = hour;
            this.current = hourInstance;
            return this.current;
        }
        this.lock.lock();
        try {
            hourInstance = this.hourlyMap.get(hour);
            if (hourInstance != null) {
                Hour hour2 = hourInstance;
                return hour2;
            }
            this.clean(hour);
            ArrayList<InetConnectionRuntime> list = new ArrayList<InetConnectionRuntime>(256);
            long nextHour = hour + 3600000L;
            Set<Integer> deviceIds = this.iface.deviceIds;
            for (InetConnectionRuntime inetConnectionRuntime : this.accounting.connectionMapCall.values()) {
                Date sessionStop;
                int deviceId = inetConnectionRuntime.connection.getDeviceId();
                if (!deviceIds.contains(deviceId) || inetConnectionRuntime.sessionStartTime >= nextHour || (sessionStop = inetConnectionRuntime.sessionStop) != null && sessionStop.getTime() < hour || this.iface.iface != -1 && this.iface.agentDeviceId == deviceId && !Accounting.isWorkingAutoIface(this.accounting, this.iface, deviceId, inetConnectionRuntime)) continue;
                list.add(inetConnectionRuntime);
            }
            Hour newHourInstance = new Hour(list);
            hourInstance = this.hourlyMap.put(hour, newHourInstance);
            if (hourInstance == null) {
                hourInstance = newHourInstance;
            }
            this.currentHour = hour;
            this.current = hourInstance;
        }
        finally {
            this.lock.unlock();
        }
        return hourInstance;
    }

    private void clean(Long hour) {
        assert (this.lock.isHeldByCurrentThread());
        long millis = System.currentTimeMillis();
        if (millis < hour) {
            hour = InetUtils.getHour(millis);
        }
        hour = hour - 10800000L;
        Iterator<Map.Entry<Long, Hour>> iter = this.hourlyMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Hour> entry = iter.next();
            if (entry.getKey() >= hour) continue;
            iter.remove();
        }
    }

    public InetConnectionRuntime getSession(IpAddress address, Long hour, long millis, long lockTimeout) {
        Hour hourInstance = this.getHour(hour);
        InetConnectionRuntime result = hourInstance.addressSet.get(address, millis, lockTimeout);
        if (result != null) {
            return result;
        }
        result = hourInstance.rangeSet.get(address, millis, lockTimeout);
        if (result != null) {
            return result;
        }
        result = hourInstance.fullInterface.get();
        if (result != null) {
            try {
                result.inetServRuntime.tryLockEx(lockTimeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return result;
        }
        return null;
    }

    public InetConnectionRuntime getSessionWithTimeout(IpAddress address, Long hour, long millis) {
        Hour hourInstance = this.getHour(hour);
        InetConnectionRuntime result = hourInstance.addressSet.getWithTimeout(address, millis);
        if (result != null) {
            return result;
        }
        result = hourInstance.rangeSet.getWithTimeout(address, millis);
        if (result != null) {
            return result;
        }
        result = hourInstance.fullInterface.get();
        if (result != null) {
            result.inetServRuntime.lock();
            return result;
        }
        return null;
    }

    public void add(InetConnectionRuntime connectionRuntime) throws BGException {
        long hour = InetUtils.getHour(connectionRuntime.sessionStartTime);
        this.getHour(hour);
        IpAddress ipAddress = new IpAddress(connectionRuntime.connection.getInetAddressBytes());
        ConnectionLog.log(connectionRuntime, Level.INFO, "Register ip: " + ipAddress);
        for (Map.Entry<Long, Hour> entry : this.hourlyMap.entrySet()) {
            if (entry.getKey() < hour) continue;
            Hour hourInstance = entry.getValue();
            hourInstance.add(ipAddress, connectionRuntime);
        }
    }

    public void remove(InetConnectionRuntime connectionRuntime) throws BGException {
        long hour = InetUtils.getHour(connectionRuntime.sessionStartTime);
        IpAddress ipAddress = new IpAddress(connectionRuntime.connection.getInetAddressBytes());
        ConnectionLog.log(connectionRuntime, Level.INFO, "Unregister ip: " + ipAddress);
        for (Map.Entry<Long, Hour> entry : this.hourlyMap.entrySet()) {
            if (entry.getKey() < hour) continue;
            Hour hourInstance = entry.getValue();
            hourInstance.remove(ipAddress, connectionRuntime);
        }
    }

    final class Hour {
        final CallConnectionAddressSet addressSet;
        final ConnectionRangeSet rangeSet;
        final AtomicReference<InetConnectionRuntime> fullInterface = new AtomicReference();

        Hour(List<InetConnectionRuntime> list) {
            this.addressSet = new CallConnectionAddressSet(Collections.emptyList());
            ArrayList<IpRangeRuntime> rangeList = new ArrayList<IpRangeRuntime>(Math.max(50, list.size() / 2));
            for (InetConnectionRuntime connectionRuntime : list) {
                IpRangeRuntime[] ranges;
                byte[] connectionAddress = connectionRuntime.connection.getInetAddressBytes();
                if (connectionAddress != null) {
                    this.addressSet.add(new IpAddress(connectionAddress), connectionRuntime);
                }
                if ((ranges = connectionRuntime.rangeSets) != null) {
                    int size = ranges.length;
                    for (int i = 0; i < size; ++i) {
                        IpRangeRuntime range = ranges[i];
                        if (range.isSingleAddress()) {
                            if (range.getSingleAddress().address == null) continue;
                            this.addressSet.add(range.getSingleAddress(), connectionRuntime);
                            continue;
                        }
                        rangeList.add(range);
                    }
                }
                if (!connectionRuntime.inetServRuntime.isAddressAllInterface(HourlyCallConnectionSet.this.accounting)) continue;
                this.fullInterface.set(connectionRuntime);
            }
            this.rangeSet = ConnectionRangeSet.newInstanceFromRanges(rangeList);
        }

        public void add(IpAddress ipAddress, InetConnectionRuntime connectionRuntime) {
            if (ipAddress != null) {
                this.addressSet.add(ipAddress, connectionRuntime);
            }
            this.rangeSet.addAllConnections(Collections.singletonList(connectionRuntime));
            if (connectionRuntime.inetServRuntime.isAddressAllInterface(HourlyCallConnectionSet.this.accounting)) {
                this.fullInterface.set(connectionRuntime);
            }
        }

        public void remove(IpAddress ipAddress, InetConnectionRuntime connectionRuntime) {
            if (ipAddress != null) {
                this.addressSet.remove(ipAddress, (Object)connectionRuntime);
            }
            this.rangeSet.removeAll(Collections.singletonList(connectionRuntime));
            if (connectionRuntime.inetServRuntime.isAddressAllInterface(HourlyCallConnectionSet.this.accounting)) {
                this.fullInterface.set(null);
            }
        }
    }
}

