/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import jakarta.activation.DataSource;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.bill.client.viewer.FOStylesheet;

public class ServiceConfigAccountViewer
extends ServiceConfigTabbedPanel {
    private double currentScale = 1.5;
    private DataSource dataSource = null;
    private JComboBox<String> scale = null;
    private BGControlPanelPages pagePanel = null;
    private CardLayout viewLayout = new CardLayout();
    private JPanel viewPanel = new JPanel(this.viewLayout);
    private JPanel bodyPanel = new JPanel(new CardLayout());
    private FOStylesheet foStylesheet;

    public ServiceConfigAccountViewer(JComboBox<String> scale, BGControlPanelPages pagePanel) {
        this.scale = scale;
        this.pagePanel = pagePanel;
        this.jbInit();
    }

    public void showDocument(DataSource dataSource) {
        this.dataSource = dataSource;
        if (dataSource.getContentType().contains("text/xml")) {
            if (this.foStylesheet == null) {
                this.foStylesheet = new FOStylesheet();
                this.foStylesheet.scale(this.currentScale);
                this.viewPanel.add((Component)this.foStylesheet.getComponent(), "fo");
            }
            this.foStylesheet.showDocument(dataSource);
            this.viewLayout.show(this.viewPanel, "fo");
        }
        this.pagePanel.setPageCount(Math.max(this.foStylesheet.getPageCount(), 1));
    }

    public void printBlock() {
        PrinterJob job = this.getPrinterJob(0, 1);
        job.setJobName("\u0410\u043a\u0442-\u0441\u0432\u0435\u0440\u043a\u0438");
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException ex) {
                if (!ex.getMessage().contains("page or printable")) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    protected PrinterJob getPrinterJob(int fromDocument, final int count) {
        final int[] billIndex = new int[2];
        final HashMap pageFormats = new HashMap();
        final PrinterJob printerjob = PrinterJob.getPrinterJob();
        printerjob.setPageable(new Pageable(){
            private PageFormat currentPageFormat;
            private int currentIndex;
            private int lastPage;

            @Override
            public int getNumberOfPages() {
                return -1;
            }

            @Override
            public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
                if (pageIndex < this.lastPage) {
                    return this.currentPageFormat;
                }
                this.currentPageFormat = (PageFormat)pageFormats.get(pageIndex);
                if (this.currentPageFormat == null) {
                    for (int i = 0; i < count; ++i) {
                        if (pageIndex != 0 && (billIndex[i] > pageIndex || billIndex[i + 1] != 0 && billIndex[i + 1] <= pageIndex)) continue;
                        if (ServiceConfigAccountViewer.this.dataSource == null) break;
                        if (ServiceConfigAccountViewer.this.dataSource.getContentType().contains("text/xml") && ServiceConfigAccountViewer.this.foStylesheet == null) {
                            ServiceConfigAccountViewer.this.foStylesheet = new FOStylesheet();
                            ServiceConfigAccountViewer.this.foStylesheet.scale(ServiceConfigAccountViewer.this.currentScale);
                            ServiceConfigAccountViewer.this.viewPanel.add((Component)ServiceConfigAccountViewer.this.foStylesheet.getComponent(), "fo");
                        }
                        this.currentIndex = billIndex[i];
                        this.currentPageFormat = ServiceConfigAccountViewer.this.foStylesheet.getPageFormat(ServiceConfigAccountViewer.this.dataSource, printerjob, pageIndex - billIndex[i]);
                        billIndex[i + 1] = billIndex[i] + ServiceConfigAccountViewer.this.foStylesheet.getNumberOfPages();
                        break;
                    }
                }
                if (this.currentPageFormat == null) {
                    throw new IndexOutOfBoundsException();
                }
                pageFormats.put(pageIndex, this.currentPageFormat);
                this.lastPage = pageIndex;
                return this.currentPageFormat;
            }

            @Override
            public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
                return new Printable(){

                    @Override
                    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                        return ServiceConfigAccountViewer.this.foStylesheet.print(graphics, currentPageFormat, pageIndex - currentIndex);
                    }
                };
            }
        });
        return printerjob;
    }

    private void jbInit() {
        this.bodyPanel.add((Component)this.viewPanel, "view");
        this.setLayout(new GridBagLayout());
        this.add(this.bodyPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pagePanel.addPropertyChangeListener(e -> {
            if (e.getPropertyName().startsWith("to")) {
                this.foStylesheet.showPage(this.pagePanel.getPageIndex());
            }
        });
        this.scale.addActionListener(e -> {
            String scaleValue = (String)this.scale.getSelectedItem();
            if (scaleValue != null) {
                this.currentScale = Double.parseDouble(scaleValue) / 100.0;
                if (this.foStylesheet != null) {
                    this.foStylesheet.scale(this.currentScale);
                }
            }
        });
    }

    public void savePdf(File file, byte[] bytes) {
        this.foStylesheet.save(file, new ByteArrayInputStream(bytes));
    }

    public int getNumberOfPages() {
        return this.foStylesheet.getNumberOfPages();
    }
}

