<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:format="xalan://java.text.Format"
    xmlns:iterator="xalan://java.lang.Iterator"
    xmlns:session="xalan://ru.bitel.bgbilling.modules.phone.server.bean.Session"
    xmlns:detail="xalan://ru.bitel.bgbilling.modules.phone.server.bean.SessionDetail"
    xmlns:lines="xalan://ru.bitel.bgbilling.modules.phone.server.action.ActionReportSession.CSVLine"
    xmlns:utils="ru.bitel.common.Utils"
    extension-element-prefixes="session iterator format utils"
	version="1.0">

<xsl:output method="text" encoding="UTF-8" indent="yes"/>

<xsl:param name="beans"/>
<xsl:param name="format"/>
<xsl:param name="size"/>
<!-- порядок и видимость (cdr_id;item;dest;service;session_start;session_time;session_time_round;min_cost;session_cost;from_to;from;to;from164;to164;session_time_short;session_time_round_short;session_time_seconds;session_time_round_seconds) -->
<xsl:param name="csv_line" select="'session_start;dest;to164;session_time_round;session_cost'"/>
<xsl:param name="lines"/>

<xsl:template match="/">
	<xsl:value-of select="utils:insertBOM()"/>
	<xsl:variable name="temp" select="lines:init( $lines, $csv_line )"/>
	<xsl:for-each select="/data/sessions">
		<xsl:choose>
			<xsl:when test="@type = 1"><xsl:call-template name="table_point"/>
			</xsl:when>
			<xsl:otherwise><xsl:call-template name="table_point"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
</xsl:template>

<xsl:template name="table_point">
<xsl:for-each select="$size"><xsl:variable name="service" select="iterator:next( $beans )"/><xsl:variable name="aons" select="detail:iterator( $service )"/>Услуга:;<xsl:value-of select="detail:getTitle( $service )"/><xsl:for-each select="detail:getSize( $service )"><xsl:variable name="aon" select="iterator:next( $aons )"/><xsl:variable name="sessions" select="detail:iterator( $aon )"/>
Номер телефона А:;<xsl:value-of select="detail:getTitle( $aon )"/><xsl:text>
</xsl:text><xsl:variable name="temp2" select="lines:setSessions( $lines, $sessions )"/><xsl:for-each select="detail:getSize( $aon )">;<xsl:value-of select="lines:next( $lines )"/><xsl:text>
</xsl:text>
</xsl:for-each>Итого по номеру:;;<xsl:value-of select="detail:getTotalNumber( $aon )"/>;;<xsl:value-of select="detail:getTotalTimeRoundMinute( $aon )"/>;<xsl:value-of select="detail:getTotalCostFormat( $aon )"/>
</xsl:for-each>
Итого по услуге:;;<xsl:value-of select="detail:getTotalNumber( $service )"/>;;<xsl:value-of select="detail:getTotalTimeRoundMinute( $service )"/>;<xsl:value-of select="detail:getTotalCostFormat( $service )"/><xsl:text>
</xsl:text>
</xsl:for-each>Итого:;;<xsl:value-of select="/data/sessions/@total_number"/>;<xsl:value-of select="/data/sessions/@total_time"/>;<xsl:value-of select="/data/sessions/@total_time_round"/>;<xsl:value-of select="/data/sessions/@total_cost"/>
</xsl:template>

<xsl:template name="table_rule">
<xsl:for-each select="$size">
<xsl:value-of select="lines:next( $lines )"/><xsl:text>
</xsl:text>
</xsl:for-each>
</xsl:template>

<xsl:template name="table_point_old">
<xsl:for-each select="$size"><xsl:variable name="service" select="iterator:next( $beans )"/><xsl:variable name="aons" select="detail:iterator( $service )"/>Услуга:;<xsl:value-of select="detail:getTitle( $service )"/><xsl:for-each select="detail:getSize( $service )"><xsl:variable name="aon" select="iterator:next( $aons )"/><xsl:variable name="sessions" select="detail:iterator( $aon )"/>
Номер телефона А:;<xsl:value-of select="detail:getTitle( $aon )"/><xsl:text>
</xsl:text><xsl:for-each select="detail:getSize( $aon )"><xsl:variable name="s" select="iterator:next( $sessions )"/>;<xsl:value-of select="format:format( $format, session:getSessionStart( $s ) )"/>;<xsl:value-of select="session:getDestination( $s )"/>;<xsl:value-of select="session:getToNumber164( $s )"/>;<xsl:value-of select="utils:formatSessionTime( session:getSessionTimeRound( $s ) )"/>;<xsl:value-of select="utils:formatSessionCost( session:getSessionCost( $s ) )"/><xsl:text>
</xsl:text>
</xsl:for-each>Итого по номеру:;;<xsl:value-of select="detail:getTotalNumber( $aon )"/>;;<xsl:value-of select="detail:getTotalTimeRoundMinute( $aon )"/>;<xsl:value-of select="detail:getTotalCostFormat( $aon )"/>
</xsl:for-each>
Итого по услуге:;;<xsl:value-of select="detail:getTotalNumber( $service )"/>;;<xsl:value-of select="detail:getTotalTimeRoundMinute( $service )"/>;<xsl:value-of select="detail:getTotalCostFormat( $service )"/><xsl:text>
</xsl:text>
</xsl:for-each>Итого:;;<xsl:value-of select="/data/sessions/@total_number"/>;<xsl:value-of select="/data/sessions/@total_time"/>;<xsl:value-of select="/data/sessions/@total_time_round"/>;<xsl:value-of select="/data/sessions/@total_cost"/>
</xsl:template>

</xsl:stylesheet>
