/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.FrequencyCounter;

public class SessionTrackingWorker
extends AccountingWorkerTask {
    private final Accounting accounting;
    private final Iterable<? extends InetConnectionRuntime> sessions;
    private Iterator<? extends InetConnectionRuntime> iterator;
    private final FrequencyCounter trackedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private final long lockTimeout;
    private static final ThreadLocal<Boolean> workerThread = new ThreadLocal();

    public SessionTrackingWorker(Accounting accounting, ScheduledExecutorService scheduledExecutorService, String name, ParameterMap params, ParameterMap defaultParams, Iterable<? extends InetConnectionRuntime> sessions) {
        super(scheduledExecutorService, name, params, defaultParams);
        this.getLogger().info("Add tracking worker: delay={}, batchSize={}", (Object)this.getDelay(), (Object)this.batchSize);
        this.accounting = accounting;
        this.sessions = sessions;
        this.lockTimeout = params.getLong("lockTimeout", 20000L);
    }

    public static boolean isWorkerThread() {
        return workerThread.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl() throws BGException {
        this.getLogger().debug("Run connection tracker...");
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.sessions.iterator();
        }
        long millis = System.currentTimeMillis();
        Long hour = InetUtils.getHour(millis);
        ConnectionSet connectionSet = ((ServerContext)this.context).getConnectionSet();
        int count = 0;
        workerThread.set(Boolean.TRUE);
        try {
            int batchSize = this.batchSize;
            while (count < batchSize && this.iterator.hasNext()) {
                InetConnectionRuntime connectionRuntime = this.iterator.next();
                MDC.put((String)"contractId", (String)String.valueOf(connectionRuntime.contractId));
                MDC.put((String)"inetServId", (String)String.valueOf(connectionRuntime.inetServId));
                MDC.put((String)"sessionId", (String)String.valueOf(connectionRuntime.sessionId));
                Optional.ofNullable(connectionRuntime.connection).ifPresent(a -> MDC.put((String)"connectionId", (String)String.valueOf(connectionRuntime.connection.getId())));
                if (this.trackingProcess(this.accounting, connectionSet, connectionRuntime, hour, millis, this.lockTimeout, false)) {
                    ++count;
                }
                MDC.remove((String)"contractId");
                MDC.remove((String)"inetServId");
                MDC.remove((String)"sessionId");
                MDC.remove((String)"connectionId");
            }
        }
        finally {
            workerThread.remove();
        }
        long millis2 = System.currentTimeMillis();
        long duration = millis2 - millis;
        this.trackedPerMinute.add(millis2, (long)count);
        this.processTimePerMinute.add(millis2, duration);
        this.processTimePerTenMinutes.add(millis2, duration);
        this.invokePerMinute.add(millis2, 1L);
        this.invokePerTenMinutes.add(millis2, 1L);
        if (this.getLogger().isDebugEnabled() && count > 0) {
            this.getLogger().debug("Tracked " + count + " sessions for " + duration + " ms.");
        }
    }

    @MBeanAttribute
    public long getTrackedPerMinute() {
        return this.trackedPerMinute.get(System.currentTimeMillis());
    }
}

