/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.StartElement;
import org.xml.sax.Attributes;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.bill.common.bean.BillListFilter;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.SortMode;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.Invoice;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceDocumentDao;
import ru.bitel.bgbilling.modules.bill.server.bean.NumerationPoolManager;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.event.InvoiceCreatedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Page;

public class InvoiceManager
extends AbstractManager {
    private static Object addInvoiceMutex = new Object();

    public InvoiceManager(Connection con, int moduleId) {
        super(con, moduleId, "bill_invoice_data_" + moduleId);
    }

    public BillDoc getInvoice(int id) {
        Invoice result = null;
        String query = "SELECT bill_data.*, type.title FROM " + this.table + " AS bill_data LEFT JOIN bill_doc_type_" + this.moduleId + " AS type ON bill_data.type=type.id  WHERE bill_data.id=" + id;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result = this.getInvoiceFromRS(rs, false, true);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public List<Invoice> getInvoiceList(BillListFilter billListFilter, boolean getXml, boolean forRegister) {
        PreparedStatement ps;
        List listIds = billListFilter.getContractLabelIds();
        Calendar from = billListFilter.getPeriod().getDateFromCalendar();
        Calendar until = billListFilter.getPeriod().getDateToCalendar();
        if (Utils.notEmptyCollection((Collection)listIds)) {
            if ("or".equals(billListFilter.getContractLabelMode())) {
                query = "CREATE TEMPORARY TABLE IF NOT EXISTS cids AS SELECT DISTINCT contract_id FROM contract_label_link WHERE label_id IN ( " + Utils.toString((Iterable)listIds) + " )";
                try {
                    ps = this.con.prepareStatement(query.toString());
                    try {
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            } else if ("and".equals(billListFilter.getContractLabelMode())) {
                query = "CREATE TEMPORARY TABLE IF NOT EXISTS cids AS SELECT contract_id, count(*) as c FROM contract_label_link WHERE label_id IN ( " + Utils.toString((Iterable)listIds) + " ) GROUP BY contract_id HAVING c=?";
                try {
                    ps = this.con.prepareStatement(query.toString());
                    try {
                        ps.setInt(1, listIds.size());
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (SQLException ex) {
                    this.logError(ex);
                }
            }
        }
        int sortMode = billListFilter.getPrimarySortMode();
        int secondarySortMode = billListFilter.getSecondarySortMode();
        StringBuffer query = new StringBuffer();
        query.append("SELECT SQL_CALC_FOUND_ROWS bill_data.* , contract.title, contract.comment, type.title");
        if (sortMode == SortMode.CONTRACT_WITH_SUB.getCode() || secondarySortMode == SortMode.CONTRACT_WITH_SUB.getCode()) {
            query.append(", if ( super_contract.title is null,CONCAT(contract.title,\"-\"),CONCAT(CONCAT(super_contract.title,\"-\"),contract.title)) AS sub_sort");
        }
        this.addStreetCol(billListFilter.getAddressSortParamId(), sortMode, secondarySortMode, query, forRegister);
        this.addNameCol(billListFilter.getNameSortParam(), sortMode, secondarySortMode, query);
        query.append(" FROM ").append(this.table).append(" AS bill_data ");
        if (Utils.notEmptyCollection((Collection)listIds)) {
            query.append(" INNER JOIN cids ON bill_data.cid=cids.contract_id ");
        }
        query.append(" LEFT JOIN bill_doc_type_" + this.moduleId + " AS type ON type.id=bill_data.type");
        query.append(" LEFT JOIN contract on bill_data.cid=contract.id");
        query.append(" LEFT JOIN contract AS super_contract on super_contract.id=contract.scid ");
        this.addPackageFilterJoin(billListFilter.getPackageParamId(), billListFilter.getPackageId(), sortMode, query);
        this.addStreetJoin(billListFilter.getAddressSortParamId(), sortMode, secondarySortMode, query, forRegister);
        this.addNameJoin(billListFilter.getNameSortParam(), sortMode, secondarySortMode, query);
        query.append(" WHERE (");
        String date = "(";
        if (from != null && until != null) {
            date = "(create_dt>=? AND create_dt<=?)AND(";
        } else if (from != null && until == null) {
            date = "(create_dt>=?)AND(";
        } else if (from == null && until != null) {
            date = "(create_dt<=?)AND(";
        }
        query.append(date);
        if (billListFilter.getYear() > 0 && billListFilter.getMonth() >= 0) {
            query.append("yy=? AND mm=?)");
        }
        if (billListFilter.getUnloadType() == 1) {
            query.append(" AND (unload_status=0)");
        } else if (billListFilter.getUnloadType() == 2) {
            query.append(" AND (unload_status=1)");
        }
        if (Utils.notBlankString((String)billListFilter.getContractTitle())) {
            query.append(" AND (contract.title LIKE ?)");
        }
        if (billListFilter.getBillNumber() != null && billListFilter.getBillNumber().length() > 0) {
            query.append(" AND (format_number LIKE ?)");
        }
        if (billListFilter.getTypeIds() != null && !billListFilter.getTypeIds().isEmpty()) {
            query.append(" AND bill_data.type IN (").append(Utils.toString((Iterable)billListFilter.getTypeIds())).append(" ) ");
        }
        query.append(") ");
        if (billListFilter.getPackageId() > 0 && billListFilter.getPackageParamId() > 0) {
            query.append(" AND (cp7.val=").append(billListFilter.getPackageId());
            query.append(" OR (cp7.val IS NULL AND cp7_super.val=").append(billListFilter.getPackageId()).append("))");
        }
        this.addSortMode(billListFilter.getAddressSortParamId(), billListFilter.getNameSortParam(), sortMode, secondarySortMode, query);
        query.append(Page.toSqlLimit((Page)billListFilter.getPage()));
        ArrayList<Invoice> adminInvoiceList = new ArrayList<Invoice>();
        try {
            ps = this.con.prepareStatement(query.toString(), 1);
            try {
                int iter = 1;
                if (from != null) {
                    ps.setDate(iter++, TimeUtils.convertCalendarToSqlDate((Calendar)from));
                }
                if (until != null) {
                    ps.setDate(iter++, TimeUtils.convertCalendarToSqlDate((Calendar)until));
                }
                if (billListFilter.getYear() > 0 && billListFilter.getMonth() >= 0) {
                    ps.setInt(iter++, billListFilter.getYear());
                    ps.setInt(iter++, billListFilter.getMonth());
                }
                if (Utils.notBlankString((String)billListFilter.getContractTitle())) {
                    ps.setString(iter++, "%" + billListFilter.getContractTitle() + "%");
                }
                if (billListFilter.getBillNumber() != null && billListFilter.getBillNumber().length() > 0) {
                    ps.setString(iter++, "%" + billListFilter.getBillNumber() + "%");
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        Invoice invoice = this.getInvoiceFromRS(rs, true, true);
                        if (forRegister) {
                            invoice.setAddress(rs.getString("address"));
                            invoice.setRecipient(rs.getString("contract.comment"));
                        }
                        if (getXml) {
                            invoice.setXmlData(rs.getBytes("xml"));
                        }
                        adminInvoiceList.add(invoice);
                    }
                }
                billListFilter.getPage().setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
        try {
            ps = this.con.prepareStatement("DROP TEMPORARY TABLE IF EXISTS `cids`");
            try {
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
        return adminInvoiceList;
    }

    public List<Invoice> getInvoiceList(String idcids) {
        ArrayList<Invoice> result = new ArrayList<Invoice>();
        try {
            String query = "SELECT bill_data.*, contract.gr, contract.title, contract.comment, type.title FROM " + this.table + " AS bill_data LEFT JOIN contract on bill_data.cid=contract.id LEFT JOIN bill_doc_type_" + this.moduleId + " AS type ON bill_data.type=type.id WHERE bill_data.id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            String[] idm = idcids.split(";");
            for (int i = 0; i < idm.length; ++i) {
                String[] par = idm[i].split(":");
                ps.setInt(1, Utils.parseInt((String)par[0], (int)0));
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    result.add(this.getInvoiceFromRS(rs, true, true));
                }
                rs.close();
            }
            ps.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    private Invoice getInvoiceFromRS(ResultSet rs, boolean loadContract, boolean loadType) throws SQLException {
        Invoice result = new Invoice();
        result.setFormatNumber(rs.getString("format_number"));
        result.setUserId(rs.getInt("uid"));
        result.setNumber(rs.getInt("number"));
        result.setNumberInMonth(rs.getInt("number_in_month"));
        result.setNumberInYear(rs.getInt("number_in_year"));
        result.setTypeId(rs.getInt("type"));
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setUnloadStatus(rs.getInt("unload_status"));
        result.setYy(rs.getInt("yy"));
        result.setMm(rs.getInt("mm"));
        result.setCreateDate(rs.getDate("create_dt"));
        result.setSumm(rs.getBigDecimal("summ"));
        result.setShowReady(rs.getBoolean("show_ready"));
        if (loadContract) {
            result.setContractTitle(rs.getString("contract.title"));
            result.setContractComment(rs.getString("contract.comment"));
        }
        if (loadType) {
            result.setTypeTitle(rs.getString("type.title"));
        }
        return result;
    }

    public List<Invoice> getInvoiceList(Page page, int cid, boolean onlyReady) {
        try {
            return InvoiceDocumentDao.getInvoiceDocumentList(this.con, this.moduleId, this.table, cid, onlyReady, page, rs -> {
                try {
                    return this.getInvoiceFromRS((ResultSet)rs, false, true);
                }
                catch (SQLException ex) {
                    throw new BGRuntimeException((Throwable)ex);
                }
            });
        }
        catch (BGRuntimeException ex) {
            Throwable t = ex;
            if (t.getCause() instanceof SQLException) {
                t = ex.getCause();
            }
            this.logError(ex);
        }
        catch (BGException ex) {
            this.logError(ex);
        }
        return new ArrayList<Invoice>();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int addBillDoc(int userId, BillDoc billDoc, List<PositionValue> posList, List<BillDoc> subList, boolean checkPast) {
        int yy = billDoc.getYy();
        int mm = billDoc.getMm();
        int cid = billDoc.getContractId();
        BigDecimal summ = billDoc.getSumm();
        int type = billDoc.getTypeId();
        Date date = billDoc.getCreateDate();
        int npid = billDoc.getNpid();
        if (checkPast && !BillUtil.isPast(yy, mm)) {
            return -1;
        }
        boolean showReady = this.moduleSetup.getBoolean("invoice.generate.web.visible", false);
        if (cid > 0) {
            try (Connection con = this.setup.getDBConnectionFromPool();){
                String query = null;
                Object object = addInvoiceMutex;
                synchronized (object) {
                    int n;
                    block20: {
                        int[] numbers = this.getNextNumbers(con, npid, yy, mm);
                        String formatNumber = NumerationPoolManager.formatNumber(npid, yy, mm, numbers[0], numbers[1], numbers[2], con, this.moduleId, cid);
                        billDoc.setFormatNumber(formatNumber);
                        query = "INSERT INTO " + this.table + " (cid, type,  number, number_in_month, number_in_year, format_number, uid, yy, mm, create_dt, unload_status, summ, xml, show_ready, npid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                        PreparedStatement addInvoicePS = con.prepareStatement(query, 1);
                        try {
                            int pos = 1;
                            addInvoicePS.setInt(pos++, cid);
                            addInvoicePS.setInt(pos++, type);
                            addInvoicePS.setInt(pos++, numbers[0]);
                            addInvoicePS.setInt(pos++, numbers[1]);
                            addInvoicePS.setInt(pos++, numbers[2]);
                            addInvoicePS.setString(pos++, formatNumber);
                            addInvoicePS.setInt(pos++, userId);
                            addInvoicePS.setInt(pos++, yy);
                            addInvoicePS.setInt(pos++, mm);
                            addInvoicePS.setDate(pos++, TimeUtils.convertDateToSqlDate((Date)date));
                            addInvoicePS.setInt(pos++, 0);
                            addInvoicePS.setBigDecimal(pos++, summ);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            this.serializeInvoiceToXML(con, byteArrayOutputStream, (Invoice)billDoc, posList, subList);
                            addInvoicePS.setBytes(pos++, byteArrayOutputStream.toByteArray());
                            addInvoicePS.setInt(pos++, showReady ? 1 : 0);
                            addInvoicePS.setInt(pos++, npid);
                            addInvoicePS.executeUpdate();
                            int id = ServerUtils.lastInsertId((PreparedStatement)addInvoicePS);
                            billDoc.setId(id);
                            n = id;
                            if (addInvoicePS == null) break block20;
                        }
                        catch (Throwable throwable) {
                            if (addInvoicePS != null) {
                                try {
                                    addInvoicePS.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        addInvoicePS.close();
                    }
                    return n;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return -1;
    }

    private void serializeInvoiceToXML(Connection con, ByteArrayOutputStream bos, Invoice invoiceDoc, List<PositionValue> posList, List<BillDoc> subList) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter doc = factory.createXMLStreamWriter(bos, "UTF-8");
        doc.writeStartDocument("UTF-8", "1.0");
        doc.writeStartElement("data");
        doc.writeStartElement("bill");
        try {
            Contract contract = ContractDao.getContract((Connection)con, (int)invoiceDoc.getContractId());
            if (contract != null) {
                int mm2 = invoiceDoc.getMm();
                int yy2 = invoiceDoc.getYy();
                if (--mm2 < 0) {
                    mm2 = 11;
                    --yy2;
                }
                Object cids = String.valueOf(invoiceDoc.getContractId());
                if (contract.getSuperCid() == -1 && Utils.notBlankString((String)contract.getDependSubList())) {
                    cids = (String)cids + "," + contract.getDependSubList();
                }
                GregorianCalendar month = new GregorianCalendar(invoiceDoc.getYy(), invoiceDoc.getMm(), 1);
                GregorianCalendar monthPrev = new GregorianCalendar(yy2, mm2, 1);
                doc.writeAttribute("saldo", Utils.formatBigDecimalSumm((BigDecimal)BillUtil.getDebt(month, invoiceDoc.getContractId(), con).negate()));
                doc.writeAttribute("saldo_prev", Utils.formatBigDecimalSumm((BigDecimal)BillUtil.getDebt(monthPrev, invoiceDoc.getContractId(), con).negate()));
                BigDecimal[] sumRef = new BigDecimal[2];
                BillUtil.getServiceAccount(month, (String)cids, null, con, sumRef);
                doc.writeAttribute("amounts", Utils.formatBigDecimalSumm((BigDecimal)sumRef[1]));
                doc.writeAttribute("payments", Utils.formatBigDecimalSumm((BigDecimal)BillUtil.getPayment(month, (String)cids, null, con)));
                doc.writeAttribute("charges", Utils.formatBigDecimalSumm((BigDecimal)BillUtil.getCharge(month, (String)cids, null, con)));
                this.addBillDocData(con, invoiceDoc, posList, subList, doc, bitel.billing.server.contract.bean.Contract.getContractFromNew((Contract)contract));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        doc.writeEndElement();
        doc.writeEndElement();
        doc.writeEndDocument();
        doc.flush();
    }

    public void setShowReady(String ids, boolean ready) throws SQLException {
        String query = "UPDATE " + this.table + " SET show_ready=" + (ready ? 1 : 0) + " WHERE id IN ( " + ids + " )";
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
    }

    public void updateDocTypeId(List<Integer> documentIds, int documentTypeId) throws SQLException {
        if (documentIds != null && !documentIds.isEmpty()) {
            String query = "UPDATE " + this.table + " SET type=? WHERE id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, documentTypeId);
                for (int documentId : documentIds) {
                    ps.setInt(2, documentId);
                    ps.executeUpdate();
                }
            }
        }
    }

    @Override
    protected BillDoc getBillDoc(Attributes attributes) {
        Invoice invoice = new Invoice();
        this.setOrganization(invoice, Utils.parseInt((String)attributes.getValue("organization_id"), (int)0));
        return invoice;
    }

    @Override
    protected BillDoc getBillDoc(XMLUtils.BGXMLEventReader reader, StartElement element) {
        Invoice invoice = new Invoice();
        this.setOrganization(invoice, Utils.parseInt((String)reader.getAttributeValue(element, "organization_id"), (int)0));
        return invoice;
    }

    @Override
    protected void publishEvent(int userID, BillDoc billDoc, int billId) throws BGException {
        EventProcessor.getInstance().publish((Event)new InvoiceCreatedEvent(userID, this.moduleId, billDoc.getContractId(), billId));
    }
}

