/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.phone.common.bean.PhoneItemListMode;
import ru.bitel.bgbilling.modules.phone.common.bean.PhoneItemListNumber;

public class PhoneItemListManager {
    private static final String TABLE_MODE = "phone_item_list_mode";
    private static final String TABLE_NUMBER = "phone_item_list_number";
    private Connection con;
    private int mid;

    private String getTableMode() {
        return "phone_item_list_mode_" + this.mid;
    }

    private String getTableNumber() {
        return "phone_item_list_number_" + this.mid;
    }

    public PhoneItemListManager(int mid, Connection con) {
        this.mid = mid;
        this.con = con;
    }

    public void updateMode(PhoneItemListMode mode) throws BGException {
        try {
            StringBuilder query = new StringBuilder(50);
            query.append("UPDATE ");
            query.append(this.getTableMode());
            query.append(" SET list_mode=?, is_new=? WHERE item_id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, mode.getMode().ordinal());
            ps.setBoolean(2, mode.isNewMode());
            ps.setInt(3, mode.getPhoneItemId());
            if (ps.executeUpdate() == 0) {
                ps.close();
                query = new StringBuilder(50).append("INSERT INTO ").append(this.getTableMode()).append(" (list_mode, item_id, is_new) VALUES (?,?,1)");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, mode.getMode().ordinal());
                ps.setInt(2, mode.getPhoneItemId());
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void clearNumbers(int phoneItemId) throws BGException {
        try {
            StringBuilder query = new StringBuilder(50);
            query.append("DELETE FROM ");
            query.append(this.getTableNumber());
            query.append(" WHERE item_id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, phoneItemId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void updateNumber(PhoneItemListNumber number) throws BGException {
        try {
            StringBuilder query = new StringBuilder(50);
            query.append("UPDATE ");
            query.append(this.getTableNumber());
            query.append(" SET is_new=?,is_deleted=? WHERE list_number=? AND item_id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setBoolean(1, number.isNewNumber());
            ps.setBoolean(2, number.isToDeleteNumber());
            ps.setString(3, number.getNumber());
            ps.setInt(4, number.getPhoneItemId());
            if (ps.executeUpdate() == 0) {
                ps.close();
                query = new StringBuilder(50).append("INSERT INTO ").append(this.getTableNumber()).append(" (list_number, item_id, is_new, is_deleted) VALUES (?,?,?,?)");
                ps = this.con.prepareStatement(query.toString());
                ps.setString(1, number.getNumber());
                ps.setInt(2, number.getPhoneItemId());
                ps.setBoolean(3, number.isNewNumber());
                ps.setBoolean(4, number.isToDeleteNumber());
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteNumber(PhoneItemListNumber number) throws BGException {
        try {
            StringBuilder query = new StringBuilder(50);
            query.append("DELETE FROM ");
            query.append(this.getTableNumber());
            query.append(" WHERE list_number=? AND item_id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setString(1, number.getNumber());
            ps.setInt(2, number.getPhoneItemId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<PhoneItemListNumber> getActualNumbersForItem(int phoneItemId) throws BGException {
        return this.getNumbersForItem(phoneItemId, false);
    }

    public List<PhoneItemListNumber> getDeletedNumbersForItem(int phoneItemId) throws BGException {
        return this.getNumbersForItem(phoneItemId, true);
    }

    public List<PhoneItemListNumber> getNumbersForItem(int phoneItemId, boolean isDeleted) throws BGException {
        ArrayList<PhoneItemListNumber> result = new ArrayList<PhoneItemListNumber>();
        try {
            StringBuilder query = new StringBuilder(50);
            query.append("SELECT * FROM ");
            query.append(this.getTableNumber());
            query.append(" WHERE item_id=? AND is_deleted=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, phoneItemId);
            ps.setBoolean(2, isDeleted);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getNumberFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<PhoneItemListNumber> getToDeleteNumbers() throws BGException {
        ArrayList<PhoneItemListNumber> result = new ArrayList<PhoneItemListNumber>();
        try {
            StringBuilder query = new StringBuilder(50);
            query.append("SELECT * FROM ");
            query.append(this.getTableNumber());
            query.append(" WHERE is_deleted=1");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getNumberFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<PhoneItemListNumber> getToUpdateNumbers() throws BGException {
        ArrayList<PhoneItemListNumber> result = new ArrayList<PhoneItemListNumber>();
        try {
            StringBuilder query = new StringBuilder(50);
            query.append("SELECT * FROM ");
            query.append(this.getTableNumber());
            query.append(" WHERE is_new=1");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getNumberFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private PhoneItemListNumber getNumberFromRS(ResultSet rs) throws SQLException {
        PhoneItemListNumber piln = new PhoneItemListNumber();
        piln.setPhoneItemId(rs.getInt("item_id"));
        piln.setNumber(rs.getString("list_number"));
        piln.setNewNumber(rs.getBoolean("is_new"));
        piln.setToDeleteNumber(rs.getBoolean("is_deleted"));
        return piln;
    }

    public List<PhoneItemListMode> getToUpdateModes() throws BGException {
        ArrayList<PhoneItemListMode> result = new ArrayList<PhoneItemListMode>();
        try {
            StringBuilder query = new StringBuilder(50);
            query.append("SELECT * FROM ");
            query.append(this.getTableMode());
            query.append(" WHERE is_new=1");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getModeFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public PhoneItemListMode getMode(int phoneItemId) throws BGException {
        PhoneItemListMode result = null;
        try {
            StringBuilder query = new StringBuilder(50);
            query.append("SELECT * FROM ");
            query.append(this.getTableMode());
            query.append(" WHERE item_id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, phoneItemId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getModeFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private PhoneItemListMode getModeFromRS(ResultSet rs) throws SQLException {
        PhoneItemListMode result = new PhoneItemListMode();
        result.setPhoneItemId(rs.getInt("item_id"));
        result.setMode(PhoneItemListMode.Mode.getByOrdinal((int)rs.getInt("list_mode")));
        result.setNewMode(rs.getBoolean("is_new"));
        return result;
    }
}

