/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import bitel.billing.common.VersionInfo;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.kernel.update.server.LibInfo;
import ru.bitel.bgbilling.kernel.update.server.LibInfoUtil;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.logging.BGNestedContext;

@WebServlet(name="ClientUpdate", urlPatterns={"/clientUpdate/*"})
public class ClientUpdate
extends HttpServlet {
    private Setup setup = null;
    private final Logger logger = LoggerFactory.getLogger(ClientUpdate.class);

    public void init() throws ServletException {
        super.init();
        BGNestedContext.push("apps_update");
        this.logger.info("init()");
        this.setup = Setup.getSetup();
        LibInfoUtil.getClientLibInfos();
        UserMap.initUserMap();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block60: {
            String unencoded;
            String[] userPass;
            String userName = request.getParameter("userName");
            String userPassword = request.getParameter("userPassword");
            String authorization = request.getHeader("Authorization");
            if (authorization != null && authorization.startsWith("Basic ") && (userPass = (unencoded = Base64.decodeUTF8(authorization = authorization.substring(6).trim())).split(":")).length > 1) {
                try {
                    userName = userPass[0];
                    userPassword = userPass[1];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String appsType = request.getParameter("appsType");
            String[] libNames = request.getParameterValues("libName");
            try {
                if (userName != null) {
                    String auth = "Error";
                    String message = null;
                    boolean needChangePassword = false;
                    boolean disableSavePassword = false;
                    User user = UserMap.getUserByLogin((String)userName);
                    if (user != null) {
                        if (user.equalsPasswordPlainText(userPassword)) {
                            auth = "Ok";
                            String newUserPassword = request.getParameter("newUserPassword");
                            if (user.isNeedChangePassword() && newUserPassword != null) {
                                user.setPasswordPlainText(newUserPassword);
                                user.setNeedChangePassword(false);
                                try (Connection connection = Setup.getSetup().getDBConnectionFromPool();){
                                    new UserManager(connection).update(user);
                                    UserMap.initUserMap((Connection)connection);
                                }
                                catch (Exception ex) {
                                    this.logger.error(ex.getMessage(), (Throwable)ex);
                                }
                            }
                            needChangePassword = user.isNeedChangePassword();
                            disableSavePassword = user.isDisableSavePassword();
                        } else {
                            message = String.format("%s [%s] \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438, \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c", userName, ServletUtils.getIpFromHeader((HttpServletRequest)request, (Setup)this.setup));
                        }
                    }
                    if ("Error".equals(auth)) {
                        if (message == null) {
                            message = String.format("%s [%s] \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438, \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", userName, ServletUtils.getIpFromHeader((HttpServletRequest)request, (Setup)this.setup));
                        }
                        this.logger.warn(message);
                    }
                    response.setContentType("text/plain;charset=UTF-8");
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                    if (disableSavePassword) {
                        writer.write("disable.save.password=true\n");
                    }
                    writer.write("auth=" + auth + "\n");
                    if (needChangePassword) {
                        writer.write("need.change.password=true\n");
                    }
                    if ("Ok".equals(auth)) {
                        writer.write("version=" + Setup.getSetup().get("bg.client.version") + "\n");
                        for (LibInfo libInfo : LibInfoUtil.getClientLibInfos().values()) {
                            writer.write("lib=" + libInfo.getName() + "\t" + libInfo.getHash() + "\n");
                        }
                    }
                    try {
                        URI runnerDir = ClassLoader.getSystemResource("runner").toURI();
                        File libsDir = new File(runnerDir);
                        if (libsDir.exists() && libsDir.isDirectory()) {
                            for (File file : libsDir.listFiles()) {
                                if (!file.isFile() || !file.getName().startsWith("runner_")) continue;
                                writer.write("runner.version=" + file.getName().substring(7, 17) + "\n");
                            }
                        }
                    }
                    catch (Exception runnerDir) {
                        // empty catch block
                    }
                    VersionInfo vi = VersionInfo.getVersionInfo("~");
                    writer.write("billing.version=" + vi.getVersion() + "\n");
                    writer.flush();
                    writer.close();
                    break block60;
                }
                if (Boolean.valueOf(request.getParameter("updateRunner")).booleanValue()) {
                    response.setContentType("application/octet-stream");
                    ServletOutputStream outputStream = response.getOutputStream();
                    try {
                        URI runnerDir = ClassLoader.getSystemResource("runner").toURI();
                        File libsDir = new File(runnerDir);
                        if (libsDir.exists() && libsDir.isDirectory()) {
                            for (File file : libsDir.listFiles()) {
                                if (!file.isFile() || !file.getName().startsWith("runner_")) continue;
                                FileInputStream inputStream = new FileInputStream(file);
                                outputStream.write(this.longToBytes(Long.parseLong(file.getName().substring(7, 17))));
                                outputStream.write(this.longToBytes(file.length()));
                                Utils.flush(inputStream, (OutputStream)outputStream);
                                inputStream.close();
                            }
                        }
                        break block60;
                    }
                    catch (Exception e2) {
                        this.logger.error("error process update runner lib (updateRunner)", (Throwable)e2);
                        break block60;
                    }
                }
                if ("getAppsLibInfos".equals(request.getParameter("action"))) {
                    this.checkAppsType(appsType);
                    List<LibInfo> libInfos = LibInfoUtil.getAppsLibInfos().get(appsType);
                    if (libInfos != null && libInfos.stream().anyMatch(e -> e.getHash() == null)) {
                        try {
                            String libDir = System.getProperty("lib.dir");
                            File dir = libDir == null ? new File(ClientUpdate.class.getResource("/").toURI()) : new File(libDir);
                            ArrayList<File> files = new ArrayList<File>();
                            files.addAll(Arrays.asList(new File(dir, "lib" + File.separatorChar + "apps").listFiles()));
                            files.addAll(Arrays.asList(new File(dir, "lib" + File.separatorChar + "common").listFiles()));
                            files.addAll(Arrays.asList(new File(dir, "lib" + File.separatorChar + "server").listFiles()));
                            files.addAll(Arrays.asList(new File(dir, "lib" + File.separatorChar + "ext" + File.separatorChar + "common").listFiles()));
                            files.addAll(Arrays.asList(new File(dir, "lib" + File.separatorChar + "ext" + File.separatorChar + "server").listFiles()));
                            block20: for (LibInfo libInfo : libInfos) {
                                for (File file : files) {
                                    String fileName = file.getName();
                                    if (!fileName.endsWith(".jar") || !fileName.startsWith(libInfo.getName() + "-") && !fileName.startsWith(libInfo.getName() + ".")) continue;
                                    libInfo.setFile(file);
                                    libInfo.setHash(LibInfoUtil.sha256Hex(file.getPath()));
                                    continue block20;
                                }
                            }
                        }
                        catch (URISyntaxException e1) {
                            libInfos = null;
                        }
                        if (libInfos != null) {
                            StringBuffer buffer = new StringBuffer();
                            libInfos.forEach(e -> {
                                if (e.getHash() == null) {
                                    buffer.append(e.getName()).append("\n");
                                }
                            });
                            if (buffer.length() > 0) {
                                this.logger.error("######################## \u041d\u0415 \u041d\u0410\u0419\u0414\u0415\u041d\u042b \u0424\u0410\u0419\u041b\u042b \u0411\u0418\u0411\u041b\u0418\u041e\u0422\u0415\u041a ########################\n" + buffer.toString() + "############################################################################");
                            }
                        }
                    }
                    response.setContentType("text/plain;charset=UTF-8");
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                    if (libInfos != null) {
                        for (LibInfo libInfo : libInfos) {
                            writer.write(libInfo.getType() + "\t" + libInfo.getName() + "\t" + Utils.maskBlank(libInfo.getHash(), "\u041e\u0422\u0421\u0423\u0422\u0421\u0422\u0412\u0423\u0415\u0422 \u041d\u0410 \u0421\u0415\u0420\u0412\u0415\u0420\u0415") + "\n");
                        }
                    }
                    writer.flush();
                    writer.close();
                    break block60;
                }
                if (Boolean.valueOf(request.getParameter("updateFilesDat")).booleanValue()) {
                    response.setContentType("text/plain;charset=UTF-8");
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                    writer.write(Files.readString(Paths.get("data", "files.dat")));
                    writer.flush();
                    writer.close();
                } else if ("getAppsLibs".equals(request.getParameter("action"))) {
                    this.checkAppsType(appsType);
                    if (libNames != null) {
                        HashMap libInfoMap = new HashMap();
                        LibInfoUtil.getAppsLibInfos().get(appsType).forEach(e -> libInfoMap.put(e.getType() + "*" + e.getName(), e));
                        response.setContentType("application/octet-stream");
                        ServletOutputStream outputStream = response.getOutputStream();
                        for (String libName : libNames) {
                            LibInfo libInfo;
                            if (!libInfoMap.containsKey(libName) || (libInfo = (LibInfo)libInfoMap.get(libName)).getHash() == null) continue;
                            libInfo.serializeLib((OutputStream)outputStream);
                        }
                        outputStream.flush();
                        outputStream.close();
                    }
                } else if ("getAppsFilesInfos".equals(request.getParameter("action"))) {
                    this.checkAppsType(appsType);
                    List<LibInfo> libInfos = LibInfoUtil.getAppsFilesInfos().get(appsType);
                    response.setContentType("text/plain;charset=UTF-8");
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                    if (libInfos != null) {
                        for (LibInfo libInfo : libInfos) {
                            writer.write(libInfo.getType() + "\t" + libInfo.getName() + "\t" + Utils.maskBlank(libInfo.getHash(), "\u041e\u0422\u0421\u0423\u0422\u0421\u0422\u0412\u0423\u0415\u0422 \u041d\u0410 \u0421\u0415\u0420\u0412\u0415\u0420\u0415") + "\t" + Utils.maskBlank(libInfo.getToDir(), "") + "\n");
                        }
                    }
                    writer.flush();
                    writer.close();
                } else if ("getAppsFiles".equals(request.getParameter("action"))) {
                    this.checkAppsType(appsType);
                    if (libNames != null) {
                        HashMap libInfoMap = new HashMap();
                        LibInfoUtil.getAppsFilesInfos().get(appsType).forEach(e -> libInfoMap.put(e.getType() + "*" + e.getName(), e));
                        response.setContentType("application/octet-stream");
                        ServletOutputStream outputStream = response.getOutputStream();
                        for (String libName : libNames) {
                            if (!libInfoMap.containsKey(libName)) continue;
                            LibInfo libInfo = (LibInfo)libInfoMap.get(libName);
                            libInfo.serializeLib((OutputStream)outputStream);
                        }
                        outputStream.flush();
                        outputStream.close();
                    }
                } else if (libNames != null) {
                    response.setContentType("application/octet-stream");
                    ServletOutputStream outputStream = response.getOutputStream();
                    for (String libName : libNames) {
                        LibInfo libInfo = LibInfoUtil.getClientLibInfos().get(libName);
                        if (libInfo == null) continue;
                        byte[] bytes = libName.getBytes("UTF-8");
                        outputStream.write(bytes.length);
                        outputStream.write(bytes);
                        bytes = libInfo.getHash().getBytes("UTF-8");
                        outputStream.write(bytes.length);
                        outputStream.write(bytes);
                        long length = libInfo.getFile().length();
                        outputStream.write(this.longToBytes(length));
                        FileInputStream fileInputStream = new FileInputStream(libInfo.getFile());
                        Utils.flush(fileInputStream, (OutputStream)outputStream);
                        fileInputStream.close();
                    }
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (Exception ex) {
                this.writeError(response, "\u043e\u0448\u0438\u0431\u043a\u0430: " + ex.toString());
            }
        }
    }

    private void checkAppsType(String appsType) throws Exception {
        if (Utils.isBlankString(appsType)) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 appsType, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
        }
        if (!LibInfoUtil.getAppsTypes().contains(appsType)) {
            throw new BGException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 appsType, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
        }
    }

    private void writeError(HttpServletResponse response, String text) throws IOException {
        response.setContentType("text/plain;charset=UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
        writer.write(text);
        writer.flush();
        writer.close();
    }

    private byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }
}

