/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.resource;

import bitel.billing.module.admin.resource.IPResourcePanel;
import bitel.billing.module.admin.resource.ResourceManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IPField;
import bitel.billing.module.common.IntTextField;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;

public class IPResourceManager
extends ResourceManager
implements ActionListener {
    private JPanel editor;
    private IPField rangeIPField1;
    private IPField rangeIPField2;
    private IPField maskIPField;
    private IPField maskMask;
    private IPField mask2IPField;
    private IntTextField mask2Mask;
    private BGComboBox<ComboBoxItem> rangeCb;
    private BGComboBox<ComboBoxItem> numberStatusCb;
    private BGControlPanelDateNoB onDate;
    private JPanel resourceAddEditor;
    private BGControlPanelDateNoB date;
    private IPField editrangeIPField1;
    private IPField editrangeIPField2;
    private IPField editmaskIPField;
    private IPField editmaskMask;
    private IPField editmask2IPField;
    private IntTextField editmask2Mask;
    private BGComboBox<ComboBoxItem> editrangeCb;
    private JPanel resourcePeriodChangeEditor;
    private BGControlPanelPeriodNoB resourcePeriod;
    private JPanel categoryChangeEditor;
    private JPanel countPanel;
    private JLabel countLabel;

    @Override
    protected void init() {
        this.categoriesTree = new IPResourcePanel.IPResourceCategoriesTreePanel(false);
        this.historyPanel = new IPResourcePanel.IPResourceUseHistory();
        this.actionPrefix = "IPResource";
        this.table.setHeader(this.rb_name, this.moduleDoc, "ip_resource");
    }

    @Override
    protected void initManager() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.addButton("newItem", "start_from", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441\u044b");
        toolBar.addButton("editItem", "item_edit", "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432");
        toolBar.addButton("moveItem", "link", "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
        toolBar.addButton("deleteItem", "item_delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441\u044b");
        toolBar.setActionListener(this);
        toolBar.setToolBar(new String[]{"newItem", "editItem", "moveItem", "deleteItem"});
        toolBar.setFloatable(false);
        this.onDate = new BGControlPanelDateNoB();
        this.numberStatusCb = new BGComboBox();
        this.numberStatusCb.addItem(new ComboBoxItem("any", "\u0420\u0435\u0441\u0443\u0440\u0441\u044b"));
        this.numberStatusCb.addItem(new ComboBoxItem("free", "\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0435"));
        this.numberStatusCb.addItem(new ComboBoxItem("busy", "\u0417\u0430\u043d\u044f\u0442\u044b\u0435"));
        JPanel manager = new JPanel(new GridBagLayout());
        JButton findButton = new JButton("\u0412\u044b\u0432\u0435\u0441\u0442\u0438");
        findButton.addActionListener(e -> this.showForCategory());
        this.rangeIPField1 = new IPField();
        this.rangeIPField2 = new IPField();
        this.maskIPField = new IPField();
        this.maskMask = new IPField();
        this.mask2IPField = new IPField();
        this.mask2Mask = new IntTextField();
        this.rangeCb = new BGComboBox();
        this.rangeCb.addItem(new ComboBoxItem("range", "\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d"));
        this.rangeCb.addItem(new ComboBoxItem("mask2", "\u041f\u043e\u0434\u0441\u0435\u0442\u044c"));
        this.rangeCb.addItem(new ComboBoxItem("mask1", "\u041f\u043e\u0434\u0441\u0435\u0442\u044c (\u043c\u0430\u0441\u043a\u0430)"));
        JPanel range = new JPanel(new GridBagLayout());
        range.add((Component)this.rangeIPField1, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        range.add((Component)new JLabel("-"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        range.add((Component)this.rangeIPField2, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        JPanel mask1 = new JPanel(new GridBagLayout());
        mask1.add((Component)this.maskIPField, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        mask1.add((Component)new JLabel("/"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        mask1.add((Component)this.maskMask, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        JPanel mask2 = new JPanel(new GridBagLayout());
        mask2.add((Component)this.mask2IPField, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        mask2.add((Component)new JLabel("/"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        mask2.add((Component)this.mask2Mask, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        CardLayout cardLayout = new CardLayout();
        JPanel panel = new JPanel(cardLayout);
        panel.add((Component)range, "range");
        panel.add((Component)mask1, "mask1");
        panel.add((Component)mask2, "mask2");
        this.rangeCb.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                cardLayout.show(panel, (String)((ComboBoxItem)e.getItem()).getObject());
            }
        });
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("IP:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)panel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add(this.rangeCb, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add(this.numberStatusCb, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)new JLabel("\u043d\u0430 \u0434\u0430\u0442\u0443:"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)this.onDate, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)findButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        ActionListener al = e -> this.stopEdit(e.getActionCommand().equals("ok"));
        this.resourceAddEditor = new JPanel(new GridBagLayout());
        this.resourceAddEditor.setBorder(new BGTitleBorder(" \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 "));
        this.date = new BGControlPanelDateNoB();
        this.editrangeIPField1 = new IPField();
        this.editrangeIPField2 = new IPField();
        this.editmaskIPField = new IPField();
        this.editmaskMask = new IPField();
        this.editmask2IPField = new IPField();
        this.editmask2Mask = new IntTextField();
        this.editrangeCb = new BGComboBox();
        this.editrangeCb.addItem(new ComboBoxItem("range", "\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d"));
        this.editrangeCb.addItem(new ComboBoxItem("mask2", "\u041f\u043e\u0434\u0441\u0435\u0442\u044c"));
        this.editrangeCb.addItem(new ComboBoxItem("mask1", "\u041f\u043e\u0434\u0441\u0435\u0442\u044c (\u043c\u0430\u0441\u043a\u0430)"));
        range = new JPanel(new GridBagLayout());
        range.add((Component)this.editrangeIPField1, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        range.add((Component)new JLabel("-"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        range.add((Component)this.editrangeIPField2, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        mask1 = new JPanel(new GridBagLayout());
        mask1.add((Component)this.editmaskIPField, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        mask1.add((Component)new JLabel("/"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        mask1.add((Component)this.editmaskMask, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        mask2 = new JPanel(new GridBagLayout());
        mask2.add((Component)this.editmask2IPField, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        mask2.add((Component)new JLabel("/"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        mask2.add((Component)this.editmask2Mask, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        CardLayout editcardLayout = new CardLayout();
        JPanel editpanel = new JPanel(editcardLayout);
        editpanel.add((Component)range, "range");
        editpanel.add((Component)mask1, "mask1");
        editpanel.add((Component)mask2, "mask2");
        this.editrangeCb.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                editcardLayout.show(editpanel, (String)((ComboBoxItem)e.getItem()).getObject());
            }
        });
        this.resourceAddEditor.add((Component)new JLabel("\u0421 \u0434\u0430\u0442\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.resourceAddEditor.add((Component)this.date, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.resourceAddEditor.add((Component)new JLabel("\u0420\u0435\u0441\u0443\u0440\u0441\u044b:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.resourceAddEditor.add((Component)editpanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.resourceAddEditor.add(this.editrangeCb, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        this.resourceAddEditor.add((Component)okCancel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        okCancel.addActionListener(al);
        this.resourcePeriodChangeEditor = new JPanel(new GridBagLayout());
        this.resourcePeriodChangeEditor.setBorder(new BGTitleBorder(" \u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 "));
        this.resourcePeriod = new BGControlPanelPeriodNoB();
        this.resourcePeriodChangeEditor.add((Component)new JLabel("\u041d\u043e\u0432\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.resourcePeriodChangeEditor.add((Component)this.resourcePeriod, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        BGButtonPanelOkCancel dateChangeOkCancel = new BGButtonPanelOkCancel();
        this.resourcePeriodChangeEditor.add((Component)dateChangeOkCancel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        dateChangeOkCancel.addActionListener(al);
        this.categoryChangeEditor = new JPanel(new GridBagLayout());
        this.categoryChangeEditor.setBorder(new BGTitleBorder(" \u041f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u0432 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e "));
        BGButtonPanelOkCancel categoryChangeOkCancel = new BGButtonPanelOkCancel();
        this.categoryChangeEditor.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432 \u0434\u0435\u0440\u0435\u0432\u0435 \u043d\u043e\u0432\u0443\u044e \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u0434\u043b\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u0438 \u043d\u0430\u0436\u043c\u0438\u0442\u0435 \u041e\u043a"), new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.categoryChangeEditor.add((Component)categoryChangeOkCancel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        categoryChangeOkCancel.addActionListener(al);
        this.countLabel = new JLabel();
        JLabel countTextLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e:");
        this.countPanel = new JPanel(new GridBagLayout());
        this.countPanel.add((Component)countTextLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.countPanel.add((Component)this.countLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        manager.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        manager.add((Component)filterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        manager.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        manager.add((Component)this.resourceAddEditor, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        manager.add((Component)this.historyPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        manager.add((Component)this.resourcePeriodChangeEditor, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        manager.add((Component)this.categoryChangeEditor, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        manager.add((Component)this.countPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.resourceAddEditor.setVisible(false);
        this.historyPanel.setVisible(false);
        this.resourcePeriodChangeEditor.setVisible(false);
        this.categoryChangeEditor.setVisible(false);
        this.countPanel.setVisible(true);
        ClientUtils.addOnlyOneShownListener(this.resourceAddEditor, this.historyPanel, this.resourcePeriodChangeEditor, this.categoryChangeEditor, this.countPanel);
        this.add((Component)this.createSyncButton(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)manager, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleMouseClicked(this.table, e -> this.handleMouseClicked((MouseEvent)e));
    }

    private void handleMouseClicked(MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2) {
            String id = ClientUtils.getRowId(this.table);
            int row = this.table.getSelectedRow();
            String ip1 = this.table.getColumnValueString(row, "ip1");
            String ip2 = this.table.getColumnValueString(row, "ip2");
            String itemId = this.table.getColumnValueString(row, "item_id");
            IPResourcePanel.IPResourceUseHistory historyPanel = (IPResourcePanel.IPResourceUseHistory)this.historyPanel;
            historyPanel.setId(id);
            historyPanel.setIp1(ip1);
            historyPanel.setIp2(ip2);
            historyPanel.setItemId(itemId);
            historyPanel.trySetData();
            historyPanel.setVisible(true);
        }
    }

    @Override
    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.historyPanel.init(module, moduleId);
    }

    @Override
    public void setData() {
        super.setData();
    }

    @Override
    public void deleteItem() {
        String id = ClientUtils.getRowIdList(this.table, "id", "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443(\u0438)");
        if (Utils.isBlankString(id)) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0440\u0435\u0441\u0443\u0440\u0441(\u044b)");
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441(\u044b)?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("IPResourceDelete");
            request.setModuleId(this.getModuleId());
            request.setAttribute("id", id);
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.showForCategory();
            }
        }
    }

    @Override
    public void newItem() {
        this.editor = this.resourceAddEditor;
        this.startEdit();
    }

    @Override
    public void editItem() {
        this.editor = this.resourcePeriodChangeEditor;
        this.startEdit();
    }

    private void moveItem() {
        this.editor = this.categoryChangeEditor;
        this.startEdit();
    }

    private void startEdit() {
        if (this.editor == this.resourceAddEditor) {
            this.date.setLocalDate(LocalDate.now());
        }
        this.editor.setVisible(true);
    }

    private void stopEdit(boolean ok) {
        if (ok) {
            if (this.editor == this.resourceAddEditor) {
                String categoryId = this.categoriesTree.getSelectedId();
                String date = this.date.getDateString();
                if (Utils.isBlankString(date)) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443!");
                    return;
                }
                if (Utils.isBlankString(categoryId)) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e!");
                    return;
                }
                Request req = new Request();
                req.setModule(this.module);
                req.setModuleId(this.getModuleId());
                if ("range".equals(this.editrangeCb.getSelectedId())) {
                    req.setAttribute("range1", String.valueOf(this.editrangeIPField1.getIPValue()));
                    req.setAttribute("range2", String.valueOf(this.editrangeIPField2.getIPValue()));
                } else if ("mask1".equals(this.editrangeCb.getSelectedId())) {
                    int mask = 32 - Long.numberOfTrailingZeros(this.editmaskMask.getIPValue());
                    req.setAttribute("net", String.valueOf(this.editmaskIPField.getIPValue()));
                    req.setAttribute("mask", String.valueOf(mask));
                } else if ("mask2".equals(this.editrangeCb.getSelectedId())) {
                    req.setAttribute("net", String.valueOf(this.editmask2IPField.getIPValue()));
                    req.setAttribute("mask", String.valueOf(this.editmask2Mask.getValue()));
                }
                req.setAttribute("category_id", categoryId);
                req.setAttribute("date", date);
                req.setAction("IPResourceAdd");
                if (ClientUtils.checkStatus(this.getDocument(req))) {
                    this.countPanel.setVisible(true);
                    this.showForCategory();
                }
            } else if (this.editor == this.resourcePeriodChangeEditor) {
                String ids = ClientUtils.getRowIdList(this.table, "id", "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u0441\u0443\u0440\u0441(\u044b)");
                if (Utils.notBlankString(ids)) {
                    Request req = new Request();
                    req.setModule(this.module);
                    req.setModuleId(this.getModuleId());
                    req.setAction("IPResourcePeriodChange");
                    req.setAttribute("ids", ids);
                    req.setAttribute("date1", this.resourcePeriod.getDateString1());
                    req.setAttribute("date2", this.resourcePeriod.getDateString2());
                    if (ClientUtils.checkStatus(this.getDocument(req))) {
                        this.countPanel.setVisible(true);
                        this.showForCategory();
                    }
                }
            } else if (this.editor == this.categoryChangeEditor) {
                String categoryId = this.categoriesTree.getSelectedId();
                if (Utils.isBlankString(categoryId)) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e!");
                    return;
                }
                String ids = ClientUtils.getRowIdList(this.table, "id", "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u0441\u0443\u0440\u0441(\u044b)");
                if (Utils.notBlankString(ids)) {
                    Request req = new Request();
                    req.setModule(this.module);
                    req.setModuleId(this.getModuleId());
                    req.setAction("IPResourceCategoryChange");
                    req.setAttribute("ids", ids);
                    req.setAttribute("category_id", categoryId);
                    if (ClientUtils.checkStatus(this.getDocument(req))) {
                        this.countPanel.setVisible(true);
                        this.showForCategory();
                    }
                }
            }
        } else {
            this.countPanel.setVisible(true);
        }
    }

    @Override
    protected void showForCategory() {
        super.showForCategory();
        this.countLabel.setText(String.valueOf(this.count));
    }

    @Override
    protected boolean addFilterParams(Request req) {
        String status = ClientUtils.getIdFromComboBox(this.numberStatusCb);
        String onDate = this.onDate.getDateString();
        if (!status.equals("any") && Utils.isBlankString(onDate)) {
            ClientUtils.showErrorMessageDialog("\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0435 \u0438\u043b\u0438 \u0437\u0430\u043d\u044f\u0442\u044b\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0434\u0430\u0442\u0443!");
            return false;
        }
        req.setAttribute("status", status);
        req.setAttribute("on_date", onDate);
        if ("range".equals(this.rangeCb.getSelectedId())) {
            req.setAttribute("range1", String.valueOf(this.rangeIPField1.getIPValue()));
            req.setAttribute("range2", String.valueOf(this.rangeIPField2.getIPValue()));
        } else if ("mask1".equals(this.rangeCb.getSelectedId())) {
            int mask = 32 - Long.numberOfTrailingZeros(this.maskMask.getIPValue());
            req.setAttribute("net", String.valueOf(this.maskIPField.getIPValue()));
            req.setAttribute("mask", String.valueOf(mask));
        } else if ("mask2".equals(this.rangeCb.getSelectedId())) {
            req.setAttribute("net", String.valueOf(this.mask2IPField.getIPValue()));
            req.setAttribute("mask", String.valueOf(this.mask2Mask.getValue()));
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("moveItem")) {
            this.moveItem();
        } else {
            super.actionPerformed(e);
        }
    }
}

