/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.bean;

import bitel.billing.server.radius.AttributeParams;
import bitel.billing.server.radius.RadiusAttribute;
import bitel.billing.server.radius.RadiusAttributes;
import bitel.billing.server.radius.RadiusVendorAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public final class AttributeSetManager {
    private static final AttributeSet nullEntry = new AttributeSet("?");
    private static final Pattern csPat = Pattern.compile(";");
    private HashMap<Integer, AttributeSet> attrMap = new HashMap();

    public AttributeSetManager(Preferences setup) {
        for (Map.Entry e_map : setup.subIndexed("attrset.").entrySet()) {
            String attributes = ((ParameterMap)e_map.getValue()).get("attributes");
            int id = (Integer)e_map.getKey();
            String title = ((ParameterMap)e_map.getValue()).get("title");
            AttributeSet entry = new AttributeSet(title);
            try {
                if (id > 0 && Utils.notBlankString((String)title) && Utils.notBlankString((String)attributes)) {
                    for (String attrString : csPat.split(attributes)) {
                        int pos = attrString.indexOf("=");
                        if (pos <= 0) continue;
                        String attrName = attrString.substring(0, pos);
                        String attrValue = attrString.substring(pos + 1);
                        AttributeParams ap = RadiusAttributes.findAttribute((String)attrName);
                        if (ap == null) continue;
                        if (ap.getVendorCode() == 0) {
                            int code = ap.getCode();
                            RadiusAttribute ra = new RadiusAttribute(code);
                            switch (ap.getType()) {
                                case 0: {
                                    ra.setStringValue(attrValue);
                                    break;
                                }
                                case 2: {
                                    ra.setIntValue(IPUtils.convertStringIPtoInt((String)attrValue));
                                    break;
                                }
                                case 1: {
                                    ra.setIntValue(Utils.parseInt((String)attrValue, (int)-1));
                                }
                            }
                            entry.attrList.add(ra);
                            continue;
                        }
                        RadiusVendorAttribute rva = new RadiusVendorAttribute(ap.getVendorCode(), ap.getCode());
                        switch (ap.getType()) {
                            case 0: {
                                rva.setStringValue(attrValue);
                                break;
                            }
                            case 2: {
                                rva.setIntValue(IPUtils.convertStringIPtoInt((String)attrValue));
                                break;
                            }
                            case 1: {
                                rva.setIntValue(Utils.parseInt((String)attrValue, (int)-1));
                            }
                        }
                        entry.vendorAttrList.add(rva);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.attrMap.put(id, entry);
        }
    }

    public Map<Integer, AttributeSet> getAttributeSetMap() {
        return this.attrMap;
    }

    public AttributeSet getAttributeSet(Integer i) {
        AttributeSet entry = this.attrMap.get(i);
        if (entry != null) {
            ArrayList<RadiusAttribute> attrList = new ArrayList<RadiusAttribute>(entry.attrList.size());
            ArrayList<RadiusVendorAttribute> vendorAttrList = new ArrayList<RadiusVendorAttribute>(entry.vendorAttrList.size());
            for (RadiusAttribute radiusAttribute : entry.attrList) {
                attrList.add(radiusAttribute.clone());
            }
            for (RadiusVendorAttribute radiusVendorAttribute : entry.vendorAttrList) {
                vendorAttrList.add(radiusVendorAttribute.clone());
            }
            return new AttributeSet(entry.title, attrList, vendorAttrList);
        }
        return nullEntry;
    }

    public static final class AttributeSet {
        public final List<RadiusAttribute> attrList;
        public final List<RadiusVendorAttribute> vendorAttrList;
        public final String title;

        public AttributeSet(String title) {
            this.title = title;
            this.attrList = new ArrayList<RadiusAttribute>();
            this.vendorAttrList = new ArrayList<RadiusVendorAttribute>();
        }

        public AttributeSet(String title, List<RadiusAttribute> attrList, List<RadiusVendorAttribute> vendorAttrList) {
            this.title = title;
            this.attrList = attrList;
            this.vendorAttrList = vendorAttrList;
        }
    }
}

