/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cladr.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.cladr.common.model.CladrAddress;
import ru.bitel.bgbilling.plugins.cladr.common.model.CladrHouse;
import ru.bitel.bgbilling.plugins.cladr.common.model.CladrStreet;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;

public class CladrStreetDAO {
    private static final String TABLE_CLADR_STREET = "cladr_street";
    private static final String TABLE_CLADR_STREET_MAP = "cladr_street_map";
    private static final String TABLE_ADDRESS_STREET = "address_street";
    private Connection con = null;
    private Logger logger = null;

    public CladrStreetDAO(Connection con, Logger logger) {
        this.con = con;
        this.logger = logger;
    }

    private void clearMapTable() throws SQLException {
        String query = "DELETE FROM cladr_street_map WHERE street_id NOT IN (SELECT id FROM address_street)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public List<CladrStreet> getStreetNotFromCladr(CladrAddress address, int cityId) throws SQLException {
        ArrayList<CladrStreet> res = new ArrayList<CladrStreet>();
        this.clearMapTable();
        String query = "SELECT * FROM address_street WHERE id NOT IN (SELECT street_id FROM cladr_street_map) AND (cityid=-1 OR cityid=" + cityId + ") ";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                CladrStreet cladrStreet = new CladrStreet().setId(rs.getInt("id")).setTitle(rs.getString("title")).setIndex(rs.getString("p_index")).setCityId(rs.getInt("cityid"));
                res.add(cladrStreet);
            }
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return res;
    }

    public void addStreetForCladrCompare(List<CladrStreet> list) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO cladr_street SET id=?, title=?, socr=?, code=?, p_index=?, cityid=?");){
            Statement st = this.con.createStatement();
            st.executeUpdate("DELETE FROM cladr_street");
            for (CladrStreet cladrStreet : list) {
                int index = 1;
                ps.setInt(index++, cladrStreet.getId());
                ps.setString(index++, cladrStreet.getTitle());
                ps.setString(index++, cladrStreet.getSocr());
                ps.setString(index++, cladrStreet.getCode());
                ps.setString(index++, cladrStreet.getIndex());
                ps.setInt(index++, cladrStreet.getCityId());
                ps.executeUpdate();
            }
            st.close();
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private void addStreetInMap(CladrStreet cladrStreet) throws SQLException {
        int id = -1;
        String query = "SELECT street_id FROM cladr_street_map WHERE code=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, cladrStreet.getCode());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    id = rs.getInt(1);
                }
            }
        }
        query = id != -1 ? "UPDATE cladr_street_map SET code=? WHERE street_id=?" : "INSERT INTO cladr_street_map SET code=?, street_id=?";
        ps = this.con.prepareStatement(query);
        try {
            int indexMap = 1;
            ps.setString(indexMap++, cladrStreet.getCode());
            ps.setInt(indexMap++, cladrStreet.getId());
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void addStreet(CladrStreet cladrStreet, boolean ignoreSocr) throws Exception {
        Street street = Street.builder().setId(cladrStreet.getId()).setTitle(this.getStreetName(cladrStreet, ignoreSocr)).setPostIndex(cladrStreet.getIndex()).setCityId(cladrStreet.getCityId()).build();
        ((ServerContext)ServerContext.get()).getDirectory(Street.class, 0).update((Id)street);
        cladrStreet.setId(street.getId());
        this.addStreetInMap(cladrStreet);
    }

    public List<Integer> addStreeFromCladr(List<CladrAddress> list, boolean ignoreSocr, int cityId) throws Exception {
        ArrayList<Integer> res = new ArrayList<Integer>();
        String query = "SELECT street_id FROM cladr_street_map WHERE code=?";
        try (PreparedStatement selectPs = this.con.prepareStatement(query);){
            Directory directory = ((ServerContext)ServerContext.get()).getDirectory(Street.class, 0);
            for (CladrAddress address : list) {
                selectPs.setString(1, address.getCode());
                int id = 0;
                try (ResultSet rs = selectPs.executeQuery();){
                    if (rs.next()) {
                        id = rs.getInt(1);
                    }
                }
                Street street = Street.builder().setId(id).setTitle((String)(id > 0 ? this.getStreetName(address, ignoreSocr) : address.getSocr() + ". " + address.getName())).setPostIndex(address.getIndex()).setCityId(cityId).build();
                directory.update((Id)street);
                CladrStreet cladrStreet = new CladrStreet().setCode(address.getCode()).setId(street.getId());
                res.add(street.getId());
                this.addStreetInMap(cladrStreet);
            }
        }
        return res;
    }

    public void delStreetFromCladrCompare(CladrStreet cladrStreet) throws SQLException {
        String query = "DELETE FROM cladr_street WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, cladrStreet.getId());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public void delStreet(CladrStreet cladrStreet) throws Exception {
        ((ServerContext)ServerContext.get()).getDirectory(Street.class, 0).delete(cladrStreet.getId());
    }

    public CladrStreet getNextStreet() throws SQLException {
        CladrStreet cladrStreet = null;
        String query = "SELECT * FROM cladr_street LIMIT 1";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                cladrStreet = new CladrStreet().setId(rs.getInt("id")).setTitle(rs.getString("title")).setSocr(rs.getString("socr")).setIndex(rs.getString("p_index")).setCityId(rs.getInt("cityid"));
            }
        }
        return cladrStreet;
    }

    private String getCityName(CladrAddress region, CladrAddress area, CladrAddress city, int direct) {
        StringBuilder res = new StringBuilder();
        String regionName = null;
        String areaName = null;
        if (region != null) {
            regionName = region.getSocr() + ". " + region.getName();
        }
        if (area != null) {
            areaName = area.getSocr() + ". " + area.getName();
        }
        String cityName = city.getSocr() + ". " + city.getName();
        if (direct == 1) {
            if (regionName != null) {
                res.append(regionName);
                res.append(" ");
            }
            if (areaName != null) {
                res.append(areaName);
                res.append(" ");
            }
            res.append(cityName);
        } else {
            res.append(cityName);
            res.append(" ");
            if (areaName != null) {
                res.append(areaName);
                res.append(" ");
            }
            if (regionName != null) {
                res.append(regionName);
            }
        }
        return res.toString();
    }

    public void addCity(CladrAddress region, CladrAddress area, CladrAddress city, int direct, int cityId) throws SQLException {
        this.clearMapTable();
        String query = "UPDATE address_city SET title=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setString(index++, this.getCityName(region, area, city, direct));
            ps.setInt(index++, cityId);
            ps.executeUpdate();
            city.setValue("cityid", cityId);
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public void addHouseForCladr(List<CladrHouse> list) throws SQLException {
        try {
            String query = "DELETE FROM cladr_house WHERE code=?";
            PreparedStatement psDel = this.con.prepareStatement(query);
            query = "INSERT INTO cladr_house SET name=?, code=?, p_index=?";
            PreparedStatement psInsert = this.con.prepareStatement(query);
            for (CladrHouse house : list) {
                psDel.setString(1, house.getCode());
                psDel.executeUpdate();
                int index = 1;
                psInsert.setString(index++, house.getName());
                psInsert.setString(index++, house.getCode());
                psInsert.setString(index++, house.getIndex());
                psInsert.executeUpdate();
            }
            psDel.close();
            psInsert.close();
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public String getStreetCode(int streetId) throws SQLException {
        String res = null;
        try {
            String query = "SELECT code FROM cladr_street_map WHERE street_id=" + streetId;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                res = rs.getString(1);
            }
            st.close();
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return res;
    }

    public List<CladrHouse> getHouseByCode(String code) throws SQLException {
        ArrayList<CladrHouse> res = new ArrayList<CladrHouse>();
        if (code == null) {
            return res;
        }
        try {
            String query = "SELECT * FROM cladr_house WHERE code like '" + code.substring(0, 15) + "____'";
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                CladrHouse house = new CladrHouse();
                house.setCode(rs.getString("code"));
                house.setName(rs.getString("name"));
                house.setIndex(rs.getString("p_index"));
                res.add(house);
            }
            st.close();
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return res;
    }

    private String getStreetName(CladrStreet street, boolean ignoreSocr) {
        return this.getStreetImpl(street.getSocr(), street.getTitle(), ignoreSocr);
    }

    private String getStreetName(CladrAddress address, boolean ignoreSocr) {
        return this.getStreetImpl(address.getSocr(), address.getName(), ignoreSocr);
    }

    private String getStreetImpl(String socr, String name, boolean ignoreSocr) {
        if (ignoreSocr) {
            if (socr.equals("\u0443\u043b")) {
                return name;
            }
            return socr + ". " + name;
        }
        return socr + ". " + name;
    }
}

