/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistPaymentRecurring;
import ru.bitel.bgbilling.modules.assist.common.service.AssistService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;

public class ServiceConfigRecurring
extends BGUPanel {
    private BGUTable table;
    private AssistPaymentRecurringTableModel model;

    protected void jbInit() {
        this.model = new AssistPaymentRecurringTableModel();
        this.table = new BGUTable((TableModel)((Object)this.model));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        ClientUtils.addOpenAction((Component)this.table, e -> this.performAction("opencontract"));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.model.setData(((AssistService)((ClientContext)this.getContext()).getPort(AssistService.class)).getRecurringList()));
        new AbstractBGUPanel.DefaultAction("opencontract", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ClientUtils.openContract((int)((AssistPaymentRecurring)ServiceConfigRecurring.this.model.getSelectedRow()).getContractId());
            }
        };
    }

    class AssistPaymentRecurringTableModel
    extends BGTableModel<AssistPaymentRecurring> {
        public AssistPaymentRecurringTableModel() {
            super(AssistPaymentRecurringTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", String.class, -1, -1, -1, "contract", false, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0430\u0442\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f", 180, 180, 180, "date", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 100, 100, 100, "amount", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("billnumber", 200, 200, 200, "billnumber", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u043e\u043c\u0435\u0440 \u0437\u0430\u043a\u0430\u0437\u0430", 100, 100, 100, "ordernumber", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0412\u0435\u043b\u0438\u0447\u0438\u043d\u0430", String.class, 150, 150, 150, "range", false, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0434\u043e", 120, 120, 120, "recurringMaxDate", false);
        }

        public Object getValue(AssistPaymentRecurring val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("contract".equals(identifier)) {
                return val.getContractTitle() + " [ " + val.getContractComment() + " ]";
            }
            if ("date".equals(identifier)) {
                return TimeUtils.formatFullDate((Date)val.getDate());
            }
            if ("billnumber".equals(identifier)) {
                return val.getBillnumber() > 0L ? "#" + String.valueOf(val.getBillnumber()) : "\u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d";
            }
            if ("range".equals(identifier)) {
                return val.getRecurringMinAmount() + " - " + val.getRecurringMaxAmount();
            }
            return super.getValue((Object)val, column);
        }
    }
}

