/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneResource;
import ru.bitel.oss.systems.inventory.resource.server.bean.PhoneResourceDao;

public class VoiceResourceAuditor {
    List<PhoneResource> resources = new ArrayList<PhoneResource>();
    private final int moduleId;
    Comparator<PhoneResource> range = new Comparator<PhoneResource>(){

        @Override
        public int compare(PhoneResource l, PhoneResource r) {
            if (l.getPhoneFrom() < r.getPhoneFrom()) {
                return -1;
            }
            if (l.getPhoneFrom() > r.getPhoneFrom()) {
                return 1;
            }
            return Long.compare(l.getPhoneTo(), r.getPhoneTo());
        }
    };
    Comparator<PhoneResource> numberInRange = new Comparator<PhoneResource>(){

        @Override
        public int compare(PhoneResource l, PhoneResource r) {
            long number = r.getPhoneFrom();
            if (l.getPhoneTo() < number) {
                return -1;
            }
            if (l.getPhoneFrom() > number) {
                return 1;
            }
            return 0;
        }
    };

    public VoiceResourceAuditor(int moduleId) {
        this.moduleId = moduleId;
    }

    public void load(Connection con, Set<Integer> categoryIds) throws Exception {
        PhoneResourceDao phoneResourceDao = new PhoneResourceDao(con, this.moduleId);
        this.resources = categoryIds == null ? phoneResourceDao.list() : phoneResourceDao.list(categoryIds);
        this.resources.sort(this.range);
    }

    public boolean containsNumber(Long number) {
        PhoneResource key = new PhoneResource();
        key.setPhoneFrom(number.longValue());
        key.setPhoneTo(number.longValue());
        return Collections.binarySearch(this.resources, key, this.numberInRange) >= 0;
    }
}

