/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.directory;

import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseAccountType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.enums.SmartHouseAccountMode;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.enums.SmartHouseTariffMode;
import ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHouseService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class SmartHouseAccountTypePanel
extends BGUPanel {
    private BGDataSourceTableModel tableModel = new BGDataSourceTableModel("AccountType");
    private BGUPanel.WebServiceHolder<SmartHouseService> smartHouseService = new BGUPanel.WebServiceHolder((BGUPanel)this, SmartHouseService.class);

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)this.tableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleEdit((JTable)table, (BGUPanel)this, (String)"edit");
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            BGUTableParams tableParams = new BGUTableParams();
            this.tableModel.loadData((ClientContext)this.getContext(), tableParams);
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new AccountEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0438\u043f\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", new Id()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.tableModel.optSelectRow(Id.class).ifPresentOrElse(id -> new AccountEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0438\u043f\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", (Id)id).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
    }

    class AccountEditor
    extends BGEditorDialog<Id> {
        private SmartHouseAccountType accountType;
        private BGTextField title;
        private BGTextArea comment;
        private BGUComboBox<IdTitle> mode;
        private BGUComboBox<IdTitle> used;
        private BGUComboBox<KeyValue> tariffMode;

        public AccountEditor(String title, Id data) {
            super(title, (Object)data);
            this.title = new BGTextField(50);
            this.comment = new BGTextArea(3, 50);
            this.mode = new BGUComboBox();
            this.used = new BGUComboBox();
            this.tariffMode = new BGUComboBox();
        }

        public void doDialogPanel() {
            this.addFieldV("\u0420\u0435\u0436\u0438\u043c:", (JComponent)this.mode);
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", (JComponent)this.title);
            this.addFieldV("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:", new JScrollPane((Component)this.comment));
            this.addFieldV("\u0420\u0435\u0436\u0438\u043c \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438:", (JComponent)this.tariffMode);
            this.addFieldV("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f:", (JComponent)this.used);
            this.tariffMode.setData(Arrays.asList(SmartHouseTariffMode.values()).stream().map(a -> new KeyValue(a.name(), a.name().toUpperCase())).toList());
            this.used.setData(Arrays.asList(new IdTitle(0, "\u043d\u0435\u0442"), new IdTitle(1, "\u0434\u0430")));
            this.mode.setData(Arrays.asList(SmartHouseAccountMode.values()).stream().map(a -> new IdTitle(a.getMode(), a.getTitle())).toList());
            SmartHouseAccountTypePanel.this.tryCall(() -> {
                this.accountType = ((SmartHouseService)SmartHouseAccountTypePanel.this.smartHouseService.get()).smarthouseAccountTypeGet(((Id)this.data).getId());
                this.tariffMode.setSelectedItem((Object)this.accountType.getTariffMode().name());
                this.mode.setSelectedItem((Object)new Id().setId(this.accountType.getMode().getMode()));
                this.used.setSelectedItem((Object)new Id().setId(this.accountType.isUsed() ? 1 : 0));
                this.title.setText(this.accountType.getTitle());
                this.comment.setText(this.accountType.getComment());
            });
        }

        public boolean doApply() throws Exception {
            this.accountType.setTitle(this.title.getText());
            this.accountType.setMode(SmartHouseAccountMode.getSmartHouseAccountMode((int)((IdTitle)this.mode.getSelectedItem()).getId())).setUsed(((IdTitle)this.used.getSelectedItem()).getId() == 1).setComment(this.comment.getText()).setTariffMode(SmartHouseTariffMode.valueOf((String)((KeyValue)this.tariffMode.getSelectedItem()).getKey()));
            return SmartHouseAccountTypePanel.this.tryCallBoolean(() -> {
                ((SmartHouseService)SmartHouseAccountTypePanel.this.smartHouseService.get()).smarthouseAccountTypeUpdate(this.accountType);
                SmartHouseAccountTypePanel.this.performAction("refresh");
            });
        }
    }
}

