/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.include;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilter;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilterTitle;
import ru.bitel.common.Utils;

public class ReportFilterCache {
    private static final ReportFilterCache instance = new ReportFilterCache();
    private final Map<String, Class<?>> reportClasses = new HashMap();
    private final Map<String, ReportFilter> reportFilterMap = new HashMap<String, ReportFilter>();

    public static ReportFilterCache getInstance() {
        return instance;
    }

    private ReportFilterCache() {
        for (Class clazz : Utils.getClassList((String)"ru.bitel.bgbilling.modules.reports.client.include")) {
            ReportFilterTitle reportFilterTitle = clazz.getAnnotation(ReportFilterTitle.class);
            if (reportFilterTitle == null) continue;
            this.reportClasses.put(clazz.getName(), clazz);
            this.reportFilterMap.put(clazz.getName(), this.getFilterInstanceClass(clazz.getName()));
        }
    }

    public ReportFilter getFilterInstanceClass(String className) {
        try {
            Class<?> clazz = this.reportClasses.get(className);
            if (clazz == null) {
                return null;
            }
            return (ReportFilter)Utils.newInstance((String)clazz.getName(), ReportFilter.class);
        }
        catch (BGException e) {
            throw new RuntimeException(e);
        }
    }

    public ReportFilter getReportFilterByFilterName(String filterName) {
        return this.getReportFilters(false).stream().filter(filter -> filter.getClass().getAnnotation(ReportFilterTitle.class).reportTitle().equals(filterName)).findFirst().orElse(null);
    }

    public ReportFilter getReportFilter(String className) {
        return this.reportFilterMap.get(className);
    }

    public List<ReportFilter> getReportFilters(boolean sortByTitle) {
        ArrayList<ReportFilter> result = new ArrayList<ReportFilter>(this.reportFilterMap.values());
        if (sortByTitle) {
            Collections.sort(result, new Comparator<ReportFilter>(){

                @Override
                public int compare(ReportFilter o1, ReportFilter o2) {
                    return o1.getGuiTitle().compareTo(o2.getGuiTitle());
                }
            });
        }
        return result;
    }
}

