/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.CostSum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.common.Utils;

public class ServiceCostCache {
    private HashMap<String, CostSum> amountMap = new HashMap(200, 100.0f);

    public synchronized void addAmount(CostSum costSum) {
        if (BigDecimal.ZERO.compareTo(costSum.cost) != 0) {
            String key = costSum.getKey();
            CostSum cacheCostSum = this.amountMap.get(key);
            if (cacheCostSum == null) {
                cacheCostSum = costSum;
                this.amountMap.put(key, cacheCostSum);
            } else {
                cacheCostSum.cost = cacheCostSum.cost.add(costSum.cost);
            }
        }
    }

    public Map<Integer, BigDecimal> getContractAccounts() {
        HashMap<Integer, BigDecimal> result = new HashMap<Integer, BigDecimal>();
        for (CostSum costSum : this.amountMap.values()) {
            BigDecimal currentAccount = Utils.maskNull((BigDecimal)((BigDecimal)result.get(costSum.contractId)));
            currentAccount = currentAccount.add(Utils.roundBigDecimalSumm((BigDecimal)costSum.cost));
            result.put(costSum.contractId, currentAccount);
        }
        return result;
    }

    public CostSum getAmount(int contractId, int serviceId) {
        return this.amountMap.get(new CostSum(contractId, serviceId, BigDecimal.ZERO).getKey());
    }

    public Collection<CostSum> getAmounts() {
        return this.amountMap.values();
    }
}

