/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogGroup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class BotDialogGroupDao
extends AbstractIdDao<BotDialogGroup> {
    public BotDialogGroupDao(Connection connection, int moduleId) {
        this(connection, moduleId, "bot_dialog_group");
    }

    private BotDialogGroupDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    public List<BotDialogGroup> getGroupList() throws SQLException {
        return super.list(null, null, new Object[0]);
    }

    protected BotDialogGroup getFromRS(ResultSet rs) throws SQLException {
        return BotDialogGroup.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setComment(rs.getString("comment")).setDialogIds(rs.getString("dialog_ids")).build();
    }

    protected void updateImpl(BotDialogGroup group) throws SQLException {
        String sqlSet = "title=?, comment=?" + (Utils.notBlankString((String)group.getDialogIds()) ? ", dialog_ids=?" : "");
        try (PreparedStatement ps = this.prepareStatement((Id)group, sqlSet);){
            int index = 1;
            ps.setString(index++, group.getTitle());
            ps.setString(index++, group.getComment());
            if (Utils.notBlankString((String)group.getDialogIds())) {
                ps.setString(index++, group.getDialogIds());
            }
            this.executeUpdate((Id)group, index, ps);
        }
    }
}

