/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.access.om;

import java.sql.Connection;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.access.om.AccountOrderEvent;
import ru.bitel.bgbilling.apps.voice.access.om.OrderManagerSet;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.AsyncEventWorker;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountState;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountDao;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceAccountDeviceStateModifiedEvent;
import ru.bitel.bgbilling.modules.voice.server.event.om.OmVoiceAccountModifyEvent;
import ru.bitel.bgbilling.modules.voice.server.event.om.OmVoiceAccountStateModifyEvent;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.sql.ConnectionSet;

public class OrderManagerDeviceWorker
extends AsyncEventWorker<Event> {
    private final Logger logger = LogManager.getLogger();
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile Future<?> future;
    private final long fetchDelay = 200L;
    private final long fetchTimeout = 200L;
    private final int deviceId;
    private OrderManagerSet orderManagers;
    private final VoiceApplication application;
    private Connection con = null;
    private VoiceAccountDao voiceAccountDao;
    private EventProcessor ep;
    private VoiceDeviceRuntime deviceRuntime;
    private long errorAlarmCount;
    private long errorRedeliveryCount;
    private long errorRedeliveryTimeout;

    public OrderManagerDeviceWorker(VoiceApplication application, ScheduledExecutorService scheduledExecutorService, int deviceId) throws BGException {
        super(EventProcessor.getInstance(), OmVoiceAccountModifyEvent.class.getPackage().getName() + ".*", application.getModuleId(), -1, "deviceId=" + deviceId, false, new Class[]{OmVoiceAccountModifyEvent.class, OmVoiceAccountStateModifyEvent.class});
        this.deviceId = deviceId;
        this.application = application;
        this.scheduledExecutorService = scheduledExecutorService;
        this.future = scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), 3000L, 200L, TimeUnit.MILLISECONDS);
        this.getLogger().info("Starting deviceWorker for device " + deviceId);
    }

    protected synchronized void runImpl() throws Exception {
        int result = this.internalRunWorker(200L, false);
        if (result < 0) {
            this.getLogger().info("Execution error - waiting " + this.errorPause + "ms for next try.");
            this.future.cancel(false);
            this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), this.errorPause, 200L, TimeUnit.MILLISECONDS);
        }
    }

    protected boolean runWorker() throws BGException {
        boolean bl;
        ServerContext serverContext = null;
        this.deviceRuntime = this.application.getDeviceRuntimeMap().get(this.deviceId);
        if (this.deviceRuntime == null) {
            this.getLogger().error("device is empty for id " + this.deviceId);
        }
        try {
            this.errorRedeliveryCount = this.deviceRuntime.getConfig().getLong("om.error.redelivery.count", this.deviceRuntime.getConfig().getLong("sa.error.redelivery.count", 5L));
            this.errorAlarmCount = Math.min(this.deviceRuntime.getConfig().getLong("om.error.alarm.count", this.deviceRuntime.getConfig().getLong("sa.error.alarm.count", 20L)), this.errorRedeliveryCount);
            this.errorRedeliveryTimeout = this.deviceRuntime.getConfig().getLong("om.error.redelivery.timeout.millis", this.deviceRuntime.getConfig().getLong("om.error.redelivery.timeout", -1L) * 1000L);
            if (this.errorRedeliveryTimeout < 0L) {
                this.errorRedeliveryTimeout = this.deviceRuntime.getConfig().getLong("sa.error.redelivery.timeout.millis", this.deviceRuntime.getConfig().getLong("sa.error.redelivery.timeout", TimeUnit.SECONDS.convert(24L, TimeUnit.HOURS)) * 1000L);
            }
            this.orderManagers = this.deviceRuntime.getOmInstances();
            serverContext = new ServerContext(this.application.getSetup(), ConnectionSet.newInstance((DefaultServerSetup)this.application.getSetup(), (boolean)true), this.moduleId, 0);
            this.con = serverContext.getConnectionSet().getConnection();
            this.voiceAccountDao = new VoiceAccountDao(this.con, this.moduleId);
            this.orderManagers.connect();
            this.ep = EventProcessor.getInstance();
            bl = this.doTasks();
        }
        catch (Throwable throwable) {
            this.orderManagers.disconnect(serverContext);
            this.voiceAccountDao.close();
            this.voiceAccountDao = null;
            if (serverContext != null) {
                serverContext.recycle();
                serverContext = null;
            }
            this.con = null;
            this.orderManagers = null;
            this.ep = null;
            throw throwable;
        }
        this.orderManagers.disconnect(serverContext);
        this.voiceAccountDao.close();
        this.voiceAccountDao = null;
        if (serverContext != null) {
            serverContext.recycle();
            serverContext = null;
        }
        this.con = null;
        this.orderManagers = null;
        this.ep = null;
        return bl;
    }

    public Object doTask(Object task) throws BGException {
        try {
            this.getLogger().info("Do task deviceId: " + this.deviceId + "; " + task);
            AccountOrderEvent result = null;
            if (task instanceof OmVoiceAccountModifyEvent) {
                result = ((OmVoiceAccountModifyEvent)((Object)task)).toAccountOrderEvent(this.application, this.con);
            } else if (task instanceof OmVoiceAccountStateModifyEvent) {
                result = ((OmVoiceAccountStateModifyEvent)((Object)task)).toAccountOrderEvent(this.application);
            }
            if (result == null) {
                this.getLogger().debug("skiping event ");
                return true;
            }
            return new Object[]{this.doCommand(result), result};
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
    }

    private Object doCommand(AccountOrderEvent event) throws Exception {
        boolean result = true;
        switch (event.getEventType()) {
            case 2: {
                result = this.orderManagers.accountModify(this, event);
                break;
            }
            case 1: {
                result = this.orderManagers.accountCreate(this, event);
                break;
            }
            case 3: {
                result = this.orderManagers.accountRemove(this, event);
                break;
            }
            case 4: {
                result = this.orderManagers.accountStateModify(this, event);
            }
        }
        return result;
    }

    protected void taskDone(Object task, Object result) throws BGException {
        boolean stateModified;
        boolean ok;
        boolean bl = ok = !Boolean.FALSE.equals(result);
        if (!ok) {
            this.getLogger().warn("Task return false");
            return;
        }
        if (!(task instanceof Object[])) {
            return;
        }
        Object[] array = (Object[])task;
        AccountOrderEvent event = (AccountOrderEvent)array[1];
        if (event.getEventType() != 2 && event.getEventType() != 1 && event.getEventType() != 3 && event.getEventType() != 4) {
            return;
        }
        boolean bl2 = stateModified = event.getOldState() != event.getNewState();
        if (stateModified && event.isFireDeviceStateCnanged()) {
            this.fireAccountDeviceStateModified(event, event.getNewState());
        }
    }

    private void fireAccountDeviceStateModified(AccountOrderEvent event, VoiceAccountState newState) throws BGException {
        this.getLogger().info("Changing VoiceAccount:" + event.getAccountId() + " state and/or options");
        try {
            this.voiceAccountDao.updateDeviceState(event.getAccountId(), newState, 0);
            this.ep.publish((Event)new VoiceAccountDeviceStateModifiedEvent(this.application.getModuleId(), this.deviceId, event.getAccountId(), newState));
        }
        catch (Exception ex) {
            this.logError("Error in fireAccountDeviceStateModified(accountId = " + event.getAccountId() + ")" + ex.getMessage(), ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processDoTaskException(Object task, boolean inDoTask, boolean putFirstIfInDoTask, BGException ex, boolean throwException) throws BGException {
        if (this.errorCount > this.errorAlarmCount) {
            try {
                String key = "voice.sa.error.count";
                AlarmSender.sendAlarm((String)"voice.sa.error.count", (long)600000L, (String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b OrderManager [#" + this.deviceRuntime.voiceDeviceId + "] " + this.deviceRuntime.getDevice().getGuiTitle()), (String)ex.getMessage(), (Throwable)ex);
            }
            catch (Exception ex1) {
                this.logger.error(ex1.getMessage(), (Throwable)ex1);
            }
        }
        if (this.errorCount > this.errorRedeliveryCount) {
            super.processDoTaskException(task, inDoTask, false, ex, false);
            if (!(task instanceof Event)) throw ex;
            Event e = (Event)task;
            if (System.currentTimeMillis() - e.getTimestamp() < this.errorRedeliveryTimeout) {
                this.logger.info("Event redelivery: " + task);
                ((EventListenerContext)this.context).publishAfterCommit((Event)task);
                this.logger.error(ex.getMessage(), (Throwable)ex);
                return;
            } else {
                this.logger.error("Skip old event with error - " + ex.getMessage(), (Throwable)ex);
            }
            return;
        } else if (this.errorCount == this.errorRedeliveryCount) {
            super.processDoTaskException(task, inDoTask, false, ex, throwException);
            return;
        } else {
            super.processDoTaskException(task, inDoTask, putFirstIfInDoTask, ex, throwException);
        }
    }
}

