/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.message4user.client;

import bitel.billing.module.common.BGControlPanelDateWithTime;
import bitel.billing.module.common.BGTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.bgsecure.client.RoleTreeTablePanel;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.plugins.message4user.common.bean.Message;
import ru.bitel.bgbilling.plugins.message4user.common.service.MessagesForUsersService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class MessageForUsersPanel
extends BGUPanel {
    private BGEditor editorContainer = new BGEditor();
    private MessageTableModel messageTableModel = null;
    private MessagesForUsersService messagesForUsersService = null;
    private MessageForUsersEditor editor = new MessageForUsersEditor();

    protected void jbInit() {
        BGUTable meassageTable = new BGUTable((TableModel)((Object)this.getMessageTableModel()));
        meassageTable.setSelectionMode(0);
        BGSwingUtilites.handleEdit((JTable)meassageTable, (BGUPanel)this.editor, (String)"edit");
        JPanel messageListPanel = new JPanel(new GridBagLayout());
        messageListPanel.setBorder((Border)new BGTitleBorder("\u0421\u043f\u0438\u0441\u043e\u043a \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439"));
        messageListPanel.add((Component)new JScrollPane((Component)meassageTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", 0), "Center");
        this.editorContainer.addForm((JComponent)((Object)this.editor), (Object)"editor");
        this.editorContainer.addForm((JComponent)infoPanel, (Object)"info");
        this.editorContainer.setVisible(true);
        this.editorContainer.show("info");
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(0, (Component)messageListPanel, (Component)this.editorContainer, 200L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private MessageTableModel getMessageTableModel() {
        if (this.messageTableModel == null) {
            this.messageTableModel = new MessageTableModel();
        }
        return this.messageTableModel;
    }

    private MessagesForUsersService getMessagesForUsersService() {
        if (this.messagesForUsersService == null) {
            this.messagesForUsersService = (MessagesForUsersService)((ClientContext)this.getContext()).getPort(MessagesForUsersService.class);
        }
        return this.messagesForUsersService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.getMessageTableModel().setData(this.getMessagesForUsersService().getMessageList())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.editor.performAction("new"));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.editor.performAction("edit"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> this.editor.performAction("delete"));
    }

    private static class MessageTableModel
    extends BGTableModel<Message> {
        public MessageTableModel() {
            super(MessageTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a", 100, 200, -1, "messageTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 300, 400, "period", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValueAt(Message message, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("period".equals(identifier)) {
                StringBuffer buf = new StringBuffer();
                buf.append(message.getDateFrom() == null ? "..." : TimeUtils.format((Date)message.getDateFrom(), (String)"dd.MM.yyyy HH:mm:ss"));
                buf.append(" - ");
                buf.append(message.getDateTo() == null ? "..." : TimeUtils.format((Date)message.getDateTo(), (String)"dd.MM.yyyy HH:mm:ss"));
                return buf.toString();
            }
            return super.getValueAt((Object)message, column);
        }
    }

    private class MessageForUsersEditor
    extends BGUPanel {
        private BGControlPanelDateWithTime dateFrom = new BGControlPanelDateWithTime();
        private BGControlPanelDateWithTime dateTo = new BGControlPanelDateWithTime();
        private JTextArea source = new JTextArea();
        private JCheckBox checkBox = new JCheckBox();
        private RoleTreeTablePanel roleTree;
        private BGUCheckList<User> usersList = new BGUCheckList();
        private Message selectedMessage = null;
        private JTextField titleTF = new JTextField();

        private MessageForUsersEditor() {
        }

        protected void jbInit() throws Exception {
            this.roleTree = new RoleTreeTablePanel(true, false);
            this.roleTree.setRoles(((RoleService)((ClientContext)MessageForUsersPanel.this.getContext()).getPort(RoleService.class)).getRoleItems(true, false));
            JPanel titlePanel = new JPanel(new GridBagLayout());
            titlePanel.setBorder((Border)new BGTitleBorder("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a"));
            titlePanel.add((Component)this.titleTF, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            JPanel periodPanel = new JPanel(new GridBagLayout());
            periodPanel.setBorder((Border)new BGTitleBorder("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f"));
            periodPanel.add((Component)new JLabel("c: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
            periodPanel.add((Component)this.dateFrom, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
            periodPanel.add((Component)new JLabel("\u043f\u043e: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 15, 5, 0), 0, 0));
            periodPanel.add((Component)this.dateTo, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.source.setMargin(new Insets(3, 3, 3, 3));
            this.checkBox.setText(" \u043f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0442\u0440\u043e\u043a");
            JPanel textPanel = new JPanel(new GridBagLayout());
            textPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
            textPanel.add((Component)new JScrollPane(this.source), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            textPanel.add((Component)this.checkBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            BGTabbedPane tabbedPane = new BGTabbedPane();
            tabbedPane.setPreferredSize(new Dimension(periodPanel.getPreferredSize().width, textPanel.getPreferredSize().height));
            tabbedPane.add("\u0420\u043e\u043b\u0438", (Component)this.roleTree);
            tabbedPane.add("\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 ", this.usersList);
            JPanel headPanel = new JPanel(new GridBagLayout());
            headPanel.add((Component)titlePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            headPanel.add((Component)periodPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add(headPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
            this.add(textPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
            this.add((Component)tabbedPane, new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 5, 0), 0, 0));
            this.checkBox.addActionListener(e -> this.source.setLineWrap(this.checkBox.isSelected()));
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                try {
                    this.usersList.setData(((UserService)((ClientContext)this.getContext()).getPort(UserService.class)).listUsers());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                this.roleTree.clearSelection();
                this.selectedMessage = new Message();
                this.source.setText("");
                this.dateFrom.setDateString(null);
                this.dateTo.setDateString(null);
                this.titleTF.setText("");
                MessageForUsersPanel.this.editorContainer.show("editor");
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                try {
                    this.usersList.setData(((UserService)((ClientContext)this.getContext()).getPort(UserService.class)).listUsers());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                this.selectedMessage = (Message)MessageForUsersPanel.this.getMessageTableModel().getSelectedRow();
                this.checkCurrent(this.selectedMessage);
                this.source.setText(this.selectedMessage.getText());
                this.dateFrom.setDateString(TimeUtils.format((Date)this.selectedMessage.getDateFrom(), (String)"dd.MM.yyyy HH:mm"));
                this.dateTo.setDateString(TimeUtils.format((Date)this.selectedMessage.getDateTo(), (String)"dd.MM.yyyy HH:mm"));
                this.titleTF.setText(this.selectedMessage.getMessageTitle());
                this.roleTree.setCheckedRoles(this.selectedMessage.getRolesIds());
                this.usersList.setSelected((Collection)this.selectedMessage.getUsers());
                MessageForUsersPanel.this.editorContainer.show("editor");
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                this.selectedMessage = (Message)MessageForUsersPanel.this.getMessageTableModel().getSelectedRow();
                this.checkCurrent(this.selectedMessage);
                if (ClientUtils.confirm((String)"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c?", (String)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435")) {
                    MessageForUsersPanel.this.getMessagesForUsersService().deleteMessage(this.selectedMessage.getId());
                    MessageForUsersPanel.this.performAction("refresh");
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (MessageForUsersEditor.this.dateFrom.getDate() == null) {
                        ClientUtils.showMessageDialog((Object)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
                        return;
                    }
                    if (MessageForUsersEditor.this.dateTo.getDate() == null) {
                        ClientUtils.showMessageDialog((Object)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
                        return;
                    }
                    if (Utils.isBlankString((String)MessageForUsersEditor.this.titleTF.getText())) {
                        ClientUtils.showMessageDialog((Object)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a");
                        return;
                    }
                    MessageForUsersEditor.this.selectedMessage.setText(MessageForUsersEditor.this.source.getText());
                    MessageForUsersEditor.this.selectedMessage.setDateFrom(MessageForUsersEditor.this.dateFrom.getDate());
                    MessageForUsersEditor.this.selectedMessage.setDateTo(MessageForUsersEditor.this.dateTo.getDate());
                    MessageForUsersEditor.this.selectedMessage.setRolesIds(new HashSet(MessageForUsersEditor.this.roleTree.getCheckedRoleIds()));
                    MessageForUsersEditor.this.selectedMessage.setUsers(MessageForUsersEditor.this.usersList.getSelectedIds());
                    MessageForUsersEditor.this.selectedMessage.setMessageTitle(MessageForUsersEditor.this.titleTF.getText());
                    MessageForUsersPanel.this.getMessagesForUsersService().updateMessage(MessageForUsersEditor.this.selectedMessage);
                    MessageForUsersEditor.this.performAction("close");
                    MessageForUsersPanel.this.performAction("refresh");
                }
            };
            new AbstractBGUPanel.DefaultAction("close", "\u041e\u0442\u043c\u0435\u043d\u0430"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    MessageForUsersPanel.this.editorContainer.show("info");
                }
            };
        }

        private void checkCurrent(Message message) throws BGMessageException {
            if (message == null) {
                throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
            }
        }
    }
}

