package ru.bitel.bgbilling.modules.inet.dyn.device.radius;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivator;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEvent;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;

/**
 * Обработчик активации сервисов, полностью реализующий функционал PodNasConnectionInspector модуля dialup.
 */
public class CoAServiceActivator
    extends AbstractRadiusServiceActivator
    implements ServiceActivator
{
	private static final Logger logger = LogManager.getLogger();

	public CoAServiceActivator()
	{
		super( null, false, "NAS-Port, Acct-Session-Id, User-Name, Framed-IP-Address, NAS-IP-Address, NAS-Identifier", true );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object connectionModify( ServiceActivatorEvent e )
	    throws Exception
	{
		return connectionModifyCoA( e );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object connectionClose( ServiceActivatorEvent e )
	    throws Exception
	{
		logger.info( "Connection close" );

		InetConnection connection = e.getConnection();

		RadiusPacket request = radiusClient.createDisconnectRequest();
		prepareRequest( request, connection );

		logger.info( "Send PoD: \n" + request );

		return radiusClient.sendAsync( request );
	}
}
