/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.wrapper.MultipartWrapper;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.ParamManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.SearchResult;

public abstract class ActionBase
extends bitel.billing.server.ActionBase {
    protected BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");

    protected void putMessageTopic() {
    }

    protected String getMode() throws BGException {
        ParamManager paramManager = new ParamManager(this.con, this.plugin);
        Properties properties = paramManager.getProperties(this.cid);
        return properties.getProperty("mode.id", this.plugin.getSetup().get("mode.default.id", "on"));
    }

    protected List<BGServerFile> fileUploadRequest(Message message) throws BGException {
        ArrayList<BGServerFile> fileList = new ArrayList<BGServerFile>();
        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.con);
        if (!(this.request instanceof MultipartWrapper)) {
            return fileList;
        }
        MultipartWrapper multi = (MultipartWrapper)this.request;
        Set files = multi.getFileNames();
        for (String name : files) {
            String filename = multi.getFilesystemName(name);
            File f = multi.getFile(name);
            if (f == null) continue;
            BGServerFile documentFile = new BGServerFile();
            documentFile.setOwnerId(message.getId());
            documentFile.setTitle(filename);
            documentFile.setSize(f.length());
            documentFile.setComment("message #" + message.getId());
            documentFile.setDate(new Date());
            documentFile.setUserId(0);
            fileStorage.updateFile(documentFile);
            if (documentFile.getId() > 0) {
                try {
                    fileStorage.saveStream(documentFile.getId(), new FileInputStream(f));
                }
                catch (Exception e) {
                    fileStorage.deleteFile(documentFile.getId());
                    throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.\n" + e.getLocalizedMessage());
                }
                fileList.add(documentFile);
                continue;
            }
            this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0411\u0414");
        }
        return fileList;
    }

    protected String getDirectoryTable(int mode) {
        String table = null;
        switch (mode) {
            case -1: {
                table = "helpdesk_topic_statuses_" + this.plugin.getPluginUID();
            }
        }
        return table;
    }

    protected String getTime(Long seconds) {
        StringBuilder buf = new StringBuilder();
        if (seconds > 86400L) {
            buf.append(seconds / 60L / 60L / 24L).append("\u0414");
        } else if (seconds > 3600L) {
            buf.append(seconds / 3600L).append("\u0427");
        } else {
            buf.append(seconds / 60L).append("M");
        }
        return buf.toString();
    }

    protected String getContractComment(Topic topic) {
        String contractCommentString = "<html><nobr>" + topic.getContract() + " ( <b>" + topic.getContractComment() + "</b> )</nobr></html>";
        if (topic.getContractComment() == null || topic.getContractComment().equals("")) {
            return topic.getContract();
        }
        if (topic.getContract() == null) {
            return "<html><nobr> ( <b>" + topic.getContractComment() + "</b> )</nobr></html>";
        }
        return contractCommentString;
    }

    protected void messages(SearchResult<Message> messageResult, Element parent, String elementName) {
        for (Message message : messageResult.getList()) {
            Element row = this.createElement(parent, elementName);
            row.setAttribute("id", String.valueOf(message.getId()));
            row.setAttribute("type", message.getUserIdFrom() == 0 ? "\u0432\u0445\u043e\u0434\u044f\u0449\u0435\u0435" : "\u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435");
            row.setAttribute("fromUserId", String.valueOf(message.getUserIdFrom()));
            row.setAttribute("fromName", message.getUserNameFrom());
            row.setAttribute("fromDateTime", TimeUtils.format((Date)message.getDateFrom(), (String)"dd.MM.yyyy HH:mm:ss"));
            row.setAttribute("toUserId", String.valueOf(message.getUserIdTo()));
            row.setAttribute("toName", message.getUserNameTo());
            row.setAttribute("toDateTime", TimeUtils.format((Date)message.getDateTo(), (String)"dd.MM.yyyy HH:mm:ss"));
            row.setAttribute("new", String.valueOf(message.getUserIdFrom() == 0 && message.getUserIdTo() == -1));
            row.setAttribute("comment", message.getComment());
            row.setAttribute("includes", String.valueOf(message.isIncludes()));
        }
    }
}

