/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.MenuItem;

public class UserMenuDao
extends AbstractIdDao<MenuItem> {
    public UserMenuDao(Connection con) {
        super(con, 0, "bgs_menu");
    }

    public List<MenuItem> list() throws SQLException {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
        }
        return list;
    }

    public String getData(int webMenuItemId) throws SQLException {
        String data = null;
        String query = "SELECT data FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, webMenuItemId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    data = rs.getString(1);
                }
            }
        }
        return data;
    }

    public void updateData(int webMenuItemId, String data) throws SQLException {
        if (webMenuItemId < 1) {
            return;
        }
        String query = "UPDATE " + this.tableName + " SET " + "data=?" + " WHERE " + "id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, data);
            ps.setInt(2, webMenuItemId);
            ps.executeUpdate();
        }
    }

    protected MenuItem getFromRS(ResultSet rs) throws SQLException {
        return (MenuItem)((Object)this.ormFromResultSet(rs, MenuItem.class));
    }

    protected void updateImpl(MenuItem menuItem) throws SQLException {
        this.ormUpdateImpl((Object)menuItem);
        if (menuItem.isDefault()) {
            String query = "UPDATE " + this.tableName + " SET `default`=0 WHERE id<>? ";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, menuItem.getId());
                ps.executeUpdate();
            }
        }
    }

    public void setRoleCount(List<MenuItem> list) throws SQLException {
        if (list != null && !list.isEmpty()) {
            String query = "SELECT `menu_id`, count(*) FROM `role` GROUP BY `menu_id`";
            try (Statement statement = this.con.createStatement();
                 ResultSet rs = statement.executeQuery(query);){
                block10: while (rs.next()) {
                    int menuId = rs.getInt(1);
                    for (MenuItem menuItem : list) {
                        if (menuItem.getId() != menuId) continue;
                        menuItem.setRoleCount(rs.getInt(2));
                        continue block10;
                    }
                }
            }
        }
    }
}

