<%@ page contentType="text/html; charset=UTF-8"%>
<%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>
<form method='get' action='' name="sessions">
<input type="hidden" name="action" value="ShowLoginsBalance" />
<input type="hidden" name="module" value="${dataMap['module'] }"/>
<input type="hidden" name="mid" value="${dataMap['mid'] }"/>
<input type="hidden" name="pageIndex" value="1"/>

<table class="filter">
	<tr>
		<th>Ед. измерения </th>
		<td>
			<select name='unit'>
				<option value="1">байт</option>
				<option value="1024">Кб.</option>
				<option value="1048576">Мб.</option>
				<option value="1073741824">Гб.</option>
			</select>
		</td>
		<th>Месяц:</th>
		<td>
			<c:set var="selectNameMonth" value="month" />
			<c:set var="selectMonth" value="${dataMap['per'].month}" />
			<%@include file="../include/month.jsp" %>
		</td>
		<th>Год:</th>
		<td>
			<select name="year">
				<c:forEach var="item" items="${dataMap['yearList']}">
					<c:choose>
						<c:when test="${item==dataMap['year']}">
							<option value="${item}" selected="selected">${item}</option>
						</c:when>
						<c:otherwise>
							<option value="${item}">${item}</option>
						</c:otherwise>
					</c:choose>
				</c:forEach>
			</select>
		</td>
		<th nowrap="nowrap">Числа месяца:</th>
		<th style="text-align:center">c</th>
		<td>
			<input type="text" name="day_from" size="4" value="${dataMap['per'].dayFrom }"/>
		</td>
		<th style="text-align:center">по</th>
		<td>
			<input type="text" name="day_to" size="4" value="${dataMap['per'].dayTo }"/>
		</td>
		<td>
			<input type="submit" value="Вывести"/>
		</td>
	</tr>
</table>
	
<div class="report" >
	<table cellspacing='1' class="table800">
		<thead>
			<tr>
				<td>Логин</td>
		        <td>Количество сессий</td>
		        <td>Время</td>
		        <td>Стоимость</td>
		        	<c:forEach var="item" items="${dataMap['trafficTitleList']}">
		            	<td>${item}</td>
		            </c:forEach>
			</tr>
		</thead>
		<tbody>
			<c:forEach var="item" items="${dataMap['rowList']}">
			<tr>
				<td>${item[0]}</td>
				<td>${item[1]}</td>
				<td>${item[2]}</td>
				<td>${item[3]}</td>
				<c:forTokens var="tr" items="${item[4]}" delims="/">
					<td>${tr}</td>
				</c:forTokens>            
				
				
				
			</tr>
			</c:forEach>
		</tbody>
		<tfoot>
			<tr>
				<td>Итого:</td>
				<td>${dataMap['count_amount'] }</td>
				<td>${dataMap['time_amount'] }</td>
				<td>${dataMap['money_amount'] }</td>	
				<c:forEach var="item" items="${dataMap['trafficList']}" varStatus="status">
					<td>${item[0]}</td>
				</c:forEach>				
			</tr>
		</tfoot>
	</table>
</div>
</form>
