/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class DetailCompressRules
extends BGLogger {
    private static DetailCompressRules compressRules;
    private List<MapRule> rulesList = new ArrayList<MapRule>();

    public static void initCompressRule(int moduleId) {
        compressRules = new DetailCompressRules(moduleId);
    }

    public static final DetailCompressRules getCompressRules() {
        return compressRules;
    }

    public DetailCompressRules(int moduleId) {
        ModuleSetup setup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        for (Map.Entry me : setup.sub("detail.compress.").entrySet()) {
            String key = (String)me.getKey();
            String value = (String)me.getValue();
            String[] sid_range = key.split("\\.");
            if (sid_range.length != 2) {
                this.getLogger().error("Incorrect detail compress key: " + key);
                continue;
            }
            MapRule rule = new MapRule();
            rule.sid = Utils.parseInt((String)sid_range[0]);
            if (rule.sid <= 0) {
                this.getLogger().error("Incorrect detail compress key: " + key);
                continue;
            }
            String[] fromHour_toHour = sid_range[1].split("\\-");
            if (fromHour_toHour.length != 2) {
                this.getLogger().error("Incorrect detail compress hour range " + sid_range[1]);
                continue;
            }
            rule.fromHour = Utils.parseInt((String)fromHour_toHour[0]);
            rule.toHour = Utils.parseInt((String)fromHour_toHour[1]);
            if (rule.fromHour < 0 || rule.fromHour > rule.toHour || rule.toHour > 23) {
                this.getLogger().error("Incorrect detail compress hour range " + sid_range[1]);
                continue;
            }
            if (value.equals("SKIP")) {
                rule.skip = true;
            } else if (value.equals("START")) {
                rule.mapToSessionStart = true;
            } else {
                rule.mapToHour = Utils.parseInt((String)value);
                if (rule.mapToHour < 0 || rule.mapToHour > 23) {
                    this.getLogger().error("Incorrect detail compress to hour " + value);
                    continue;
                }
            }
            this.rulesList.add(rule);
        }
        this.getLogger().info("Session detail compress rules:");
        for (MapRule rule : this.rulesList) {
            String message = "Service " + rule.sid + " from " + rule.fromHour + " to " + rule.toHour + " => ";
            message = rule.mapToSessionStart ? message + "START" : (rule.skip ? message + "SKIP" : message + rule.mapToHour);
            this.getLogger().info(message);
        }
    }

    public final int getRecordHour(int realServiceHour, int serviceId) {
        int result = realServiceHour;
        for (MapRule rule : this.rulesList) {
            if (rule.sid != serviceId || rule.fromHour > realServiceHour || realServiceHour > rule.toHour) continue;
            if (rule.skip) {
                result = -1;
                break;
            }
            result = rule.mapToHour;
            break;
        }
        return result;
    }

    private static class MapRule {
        public int sid;
        public int fromHour;
        public int toHour;
        public int mapToHour;
        public boolean skip = false;
        public boolean mapToSessionStart = false;

        private MapRule() {
        }
    }
}

