/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean.amount;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.modules.npay.server.bean.amount.ModuleAmount;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class DialUpModuleAmount
extends ModuleAmount {
    @Override
    public long getDayAmount(Connection con, int contractId, Calendar day) {
        long result = 0L;
        String tableName = ServerUtils.getModuleMonthTableName((String)"session_detail", (Date)day.getTime(), (int)this.getModuleId());
        if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
            String query = "SELECT SUM(amount) FROM " + tableName + " WHERE cid=? AND TO_DAYS(dtime)=TO_DAYS(?) AND sid IN ( " + this.sids + ")";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setInt(1, contractId);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)day));
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        result = rs.getLong(1);
                    }
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return result;
    }

    @Override
    public long getPeriodAmount(Connection con, int contractId, Calendar from, Calendar to) {
        long result = 0L;
        String tableName = ServerUtils.getModuleMonthTableName((String)"session_detail", (Date)from.getTime(), (int)this.getModuleId());
        if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
            String query = "SELECT SUM(amount) FROM " + tableName + " WHERE cid=? AND TO_DAYS(dtime)>=TO_DAYS(?) AND TO_DAYS(dtime)<=TO_DAYS(?) AND sid IN ( " + this.sids + ")";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setInt(1, contractId);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)from));
                ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)to));
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        result = rs.getLong(1);
                    }
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return result;
    }
}

