/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.code;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZone;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneMapItem;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceZoneDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceGeographicCodeDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceZoneMapItemDao;
import ru.bitel.bgbilling.modules.voice.server.event.GeoCodeUpdateEvent;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceZoneMapUpdateEvent;
import ru.bitel.common.XMLUtils;

public class ZoneMapImportManager
extends BGLogger {
    private VoiceZoneMapItemDao zoneMapItemDao;
    private VoiceGeographicCodeDao codeDao;
    private int moduleId;
    private int userId;
    private Map<String, Integer> codeMap;
    private Connection con;

    public ZoneMapImportManager(Connection con, int moduleId, int userId) throws BGException {
        this.con = con;
        this.zoneMapItemDao = new VoiceZoneMapItemDao(con, moduleId);
        this.codeDao = new VoiceGeographicCodeDao(con, moduleId);
        this.moduleId = moduleId;
        this.userId = userId;
    }

    public String importZoneMap(int zoneMapId, int mode, String content) throws Exception {
        int operatorId = 0;
        boolean needEvent = false;
        StringBuilder result = new StringBuilder();
        this.getCodeMap(operatorId);
        try (VoiceZoneDao zoneDAO = new VoiceZoneDao(this.con, this.moduleId);){
            if (mode == 0) {
                for (String line : content.split("\n")) {
                    String code;
                    String zoneTitle;
                    int zoneId;
                    String[] lineData = line.split("\t");
                    if (lineData.length != 2 || !this.updateCode(operatorId, zoneMapId, zoneId = this.getZoneId(zoneDAO, zoneTitle = lineData[1]), code = lineData[0], zoneTitle, result)) continue;
                    needEvent = true;
                }
            } else if (mode == 1) {
                Document doc = XMLUtils.parseDocument((String)content);
                NodeList zones = doc.getDocumentElement().getElementsByTagName("zone");
                for (int i = 0; i < zones.getLength(); ++i) {
                    Element zone = (Element)zones.item(i);
                    String zoneTitle = zone.getAttribute("name");
                    int zoneId = this.getZoneId(zoneDAO, zoneTitle);
                    NodeList codes = zone.getElementsByTagName("code");
                    for (int j = 0; j < codes.getLength(); ++j) {
                        Element codeElement = (Element)codes.item(j);
                        String code = codeElement.getAttribute("id");
                        if (!this.updateCode(operatorId, zoneMapId, zoneId, code, zoneTitle, result)) continue;
                        needEvent = true;
                    }
                }
            }
        }
        if (needEvent) {
            EventProcessor.getInstance().publishAfterCommit((Event)new GeoCodeUpdateEvent(this.moduleId, this.userId));
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceZoneMapUpdateEvent(this.moduleId, this.userId, zoneMapId));
        }
        this.getLogger().info("result=>" + result);
        return result.toString();
    }

    private int getZoneId(VoiceZoneDao zoneDAO, String zoneTitle) throws Exception {
        VoiceZone vZone = zoneDAO.get(zoneTitle);
        if (vZone == null) {
            vZone = new VoiceZone();
            vZone.setTitle(zoneTitle);
            zoneDAO.update(vZone);
        }
        return vZone.getId();
    }

    private boolean updateCode(int operatorId, int zoneMapId, int zoneId, String code, String zoneTitle, StringBuilder result) throws Exception {
        Integer codeId = this.getCodeMap(operatorId).get(code);
        if (codeId == null || codeId <= 0) {
            result.append("\u043d\u0435\u0442 \u043a\u043e\u0434\u0430 => " + code + " \t " + zoneTitle + "\n");
            return false;
        }
        VoiceZoneMapItem item = this.zoneMapItemDao.get(zoneMapId, code);
        if (item == null) {
            item = new VoiceZoneMapItem();
            item.setMapId(zoneMapId);
            item.setCodeId(codeId.intValue());
        }
        item.setZoneId(zoneId);
        this.zoneMapItemDao.update(item);
        return true;
    }

    private Map<String, Integer> getCodeMap(int operatorId) throws Exception {
        if (this.codeMap == null) {
            List<VoiceGeographicCode> list = this.codeDao.list(-1, operatorId);
            this.codeMap = new HashMap<String, Integer>();
            for (VoiceGeographicCode code : list) {
                this.codeMap.put(code.getCode(), code.getId());
            }
        }
        return this.codeMap;
    }
}

