/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client;

import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGControlPanelDateAndHours;
import bitel.billing.module.common.BGToggleButton;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.voice.client.device.VoiceDevicePanel;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAuthError;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionFilter;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAuthErrorService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceRequestLogService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceSessionService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

public class VoiceMonitorPanel
extends BGUPanel {
    private boolean inited = false;
    private CardLayout tableCardLayout = new CardLayout();
    private JPanel tablePanel = new JPanel(this.tableCardLayout);
    private static final int MODE_ERROR = 1;
    private static final int MODE_LOG = 2;
    private static final int MODE_CURRENT = 3;
    private int mode = 1;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JLabel label = new JLabel("\u0418\u0442\u043e\u0433\u043e: 0");
    private BGToggleButton errorButton;
    private BGToggleButton logButton;
    Map<Integer, VoiceDevice> deviceMap = new HashMap<Integer, VoiceDevice>();
    private VoiceDevicePanel devicePanel = new VoiceDevicePanel((ClientContext)this.getContext(), 3, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("device.selected")) {
                VoiceMonitorPanel.this.show.perform();
            }
        }
    });
    private BGControlPanelDateAndHours period = new BGControlPanelDateAndHours();
    private BGControlPanelContractSelect contractSelect = new BGControlPanelContractSelect();
    private BGTextField contractField = new BGTextField();
    private BGTextField loginField = new BGTextField();
    BGTableModel<VoiceSession> modelLog = new SessionTableModel("voiceSessionLog");
    BGTableModel<VoiceSession> modelCur = new SessionTableModel("voiceSession");
    private BGTableModel<VoiceAuthError> errorModel = new ErrorTableModel("voiceError");
    Map<Integer, VoiceDestination> destMap = new HashMap<Integer, VoiceDestination>();
    AbstractBGUPanel.DefaultAction show = new AbstractBGUPanel.DefaultAction("show", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            Set deviceIds = VoiceMonitorPanel.this.devicePanel.getSelectedDeviceIds();
            switch (VoiceMonitorPanel.this.mode) {
                case 1: {
                    Date timeTo;
                    Date timeFrom;
                    if (VoiceMonitorPanel.this.period.getDate() != null) {
                        timeFrom = VoiceMonitorPanel.this.period.getDate();
                        timeTo = TimeUtils.getNextDay((Date)VoiceMonitorPanel.this.period.getDate());
                    } else {
                        timeFrom = TimeUtils.subtractHoursFromNow((int)VoiceMonitorPanel.this.period.getHourFrom());
                        timeTo = TimeUtils.subtractHoursFromNow((int)VoiceMonitorPanel.this.period.getHourTo());
                    }
                    Result result = ((VoiceAuthErrorService)((ClientContext)VoiceMonitorPanel.this.getContext()).getWebService(VoiceAuthErrorService.class)).authErrorDateList(timeFrom, timeTo, deviceIds, Utils.toIntegerSet((String)VoiceMonitorPanel.this.contractSelect.getContracts()), null, VoiceMonitorPanel.this.contractField.getText(), VoiceMonitorPanel.this.loginField.getText(), VoiceMonitorPanel.this.pagePanel.getPage());
                    VoiceMonitorPanel.this.pagePanel.setPage(result.getPage());
                    VoiceMonitorPanel.this.label.setText("\u0418\u0442\u043e\u0433\u043e: " + result.getPage().getRecordCount());
                    VoiceMonitorPanel.this.errorModel.setData(result.getList());
                    break;
                }
                case 2: {
                    Date timeTo;
                    Date timeFrom;
                    if (VoiceMonitorPanel.this.period.getDate() != null) {
                        timeFrom = VoiceMonitorPanel.this.period.getDate();
                        timeTo = TimeUtils.getNextDay((Date)VoiceMonitorPanel.this.period.getDate());
                    } else {
                        timeFrom = TimeUtils.subtractHoursFromNow((int)VoiceMonitorPanel.this.period.getHourFrom());
                        timeTo = TimeUtils.subtractHoursFromNow((int)VoiceMonitorPanel.this.period.getHourTo());
                    }
                    VoiceSessionFilter filter = this.getFilter().setDateFrom(timeFrom).setDateTo(timeTo);
                    Result result = ((VoiceSessionService)((ClientContext)VoiceMonitorPanel.this.getContext()).getWebService(VoiceSessionService.class)).voiceSessionLogList(filter, VoiceMonitorPanel.this.pagePanel.getPage());
                    VoiceMonitorPanel.this.pagePanel.setPage(result.getPage());
                    VoiceMonitorPanel.this.label.setText("\u0418\u0442\u043e\u0433\u043e: " + result.getPage().getRecordCount());
                    VoiceMonitorPanel.this.modelLog.setData(result.getList());
                    break;
                }
                case 3: {
                    Result result = ((VoiceSessionService)((ClientContext)VoiceMonitorPanel.this.getContext()).getWebService(VoiceSessionService.class)).voiceSessionList(this.getFilter(), VoiceMonitorPanel.this.pagePanel.getPage());
                    VoiceMonitorPanel.this.pagePanel.setPage(result.getPage());
                    VoiceMonitorPanel.this.label.setText("\u0418\u0442\u043e\u0433\u043e: " + result.getPage().getRecordCount());
                    VoiceMonitorPanel.this.modelCur.setData(result.getList());
                    break;
                }
            }
        }

        private VoiceSessionFilter getFilter() {
            VoiceSessionFilter filter = new VoiceSessionFilter();
            filter.setContractIds(Utils.toIntegerSet((String)VoiceMonitorPanel.this.contractSelect.getContracts()));
            filter.setDeviceIds(VoiceMonitorPanel.this.devicePanel.getSelectedDeviceIds());
            filter.setContractTitle(VoiceMonitorPanel.this.contractField.getText());
            filter.setLogin(VoiceMonitorPanel.this.loginField.getText());
            return filter;
        }
    };

    public VoiceMonitorPanel() {
        super((LayoutManager)new BorderLayout());
    }

    protected void jbInit() {
        BGSwingUtilites.wrapBorder((JPanel)((Object)this.devicePanel), (String)"\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
        this.devicePanel.setMinimumSize(new Dimension(200, 100));
        this.contractField.setAction((Action)this.show);
        this.loginField.setAction((Action)this.show);
        JPanel paramsPanel = new JPanel(new GridBagLayout());
        paramsPanel.add((Component)this.contractSelect, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        paramsPanel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440:"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 0, 3), 0, 0));
        paramsPanel.add((Component)this.contractField, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        paramsPanel.add((Component)new JLabel("\u041b\u043e\u0433\u0438\u043d:"), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        paramsPanel.add((Component)this.loginField, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        BGSwingUtilites.wrapBorder((JPanel)paramsPanel, (String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)paramsPanel, "North");
        panel.add((Component)((Object)this.devicePanel), "Center");
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)panel, (Component)this.getRightPanel(), 300L), "Center");
        this.period.addActionListener(e -> this.performAction("refresh"));
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.show.perform();
            }
        });
    }

    protected JPanel getRightPanel() {
        JPanel filterPanel = this.getFilterPanel();
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        BGUTable tableLog = new BGUTable(this.modelLog);
        BGUTable tableCur = new BGUTable(this.modelCur);
        BGUTable tableError = new BGUTable(this.errorModel);
        this.tablePanel.add((Component)new JScrollPane((Component)tableError), "error");
        this.tablePanel.add((Component)new JScrollPane((Component)tableLog), "log");
        this.tablePanel.add((Component)new JScrollPane((Component)tableCur), "current");
        BGEditor editor = new BGEditor("table");
        editor.setVisible(true);
        editor.addForm((JComponent)this.tablePanel, (Object)"table");
        rightPanel.add((Component)editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        editor = new BGEditor();
        editor.setVisible(false);
        editor.addForm((JComponent)((Object)new VoiceLogForm()));
        rightPanel.add((Component)editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleEdit(null, (JTable)tableLog, (AbstractBGUPanel)editor, (boolean)false);
        BGSwingUtilites.handleEdit(null, (JTable)tableError, (AbstractBGUPanel)editor, (boolean)false);
        BGSwingUtilites.handleEdit(null, (JTable)tableCur, (AbstractBGUPanel)this, (boolean)false);
        return rightPanel;
    }

    protected JPanel getFilterPanel() {
        this.errorButton = new BGToggleButton("\u041e\u0448\u0438\u0431\u043a\u0438");
        this.errorButton.setSelected(true);
        this.logButton = new BGToggleButton("\u041b\u043e\u0433\u0438");
        BGToggleButton currentButton = new BGToggleButton("\u0422\u0435\u043a\u0443\u0449\u0438\u0435");
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.errorButton);
        group.add((AbstractButton)this.logButton);
        group.add((AbstractButton)currentButton);
        ActionListener modeListener = e -> this.performAction("button.clicked");
        this.errorButton.addActionListener(modeListener);
        this.logButton.addActionListener(modeListener);
        currentButton.addActionListener(modeListener);
        JPanel modePanel = BGSwingUtilites.wrapBorder((JPanel)new JPanel(), (String)" \u0420\u0435\u0436\u0438\u043c ");
        modePanel.add((Component)this.errorButton);
        modePanel.add((Component)this.logButton);
        modePanel.add((Component)currentButton);
        JPanel pagePanel = new JPanel(new BorderLayout());
        pagePanel.add((Component)this.pagePanel, "Center");
        pagePanel.add((Component)this.label, "West");
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 15));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)modePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.period, (String)" \u041f\u0435\u0440\u0438\u043e\u0434 "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)pagePanel, (String)" \u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 "), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        return filterPanel;
    }

    private void openContract() {
        VoiceSession session = (VoiceSession)this.getSessionModel().getSelectedRow();
        if (session == null) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0435\u0441\u0441\u0438\u044e.");
        }
        ClientUtils.openContract((int)session.getContractId());
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (!this.inited) {
                this.devicePanel.performAction("refresh");
                this.destMap.clear();
                SearchResult data = ((VoiceService)((ClientContext)this.getContext()).getWebService(VoiceService.class)).voiceDestinationList(0, null, null);
                this.destMap = VoiceDestination.getDestinationMap((List)data.getList());
                this.inited = true;
            }
            this.show.perform();
        });
        new AbstractBGUPanel.DefaultAction("button.clicked", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceMonitorPanel.this.pagePanel.init();
                if (VoiceMonitorPanel.this.errorButton.isSelected()) {
                    VoiceMonitorPanel.this.mode = 1;
                    VoiceMonitorPanel.this.tableCardLayout.show(VoiceMonitorPanel.this.tablePanel, "error");
                    VoiceMonitorPanel.this.period.setVisible(true);
                } else if (VoiceMonitorPanel.this.logButton.isSelected()) {
                    VoiceMonitorPanel.this.mode = 2;
                    VoiceMonitorPanel.this.tableCardLayout.show(VoiceMonitorPanel.this.tablePanel, "log");
                    VoiceMonitorPanel.this.period.setVisible(true);
                } else {
                    VoiceMonitorPanel.this.mode = 3;
                    VoiceMonitorPanel.this.tableCardLayout.show(VoiceMonitorPanel.this.tablePanel, "current");
                    VoiceMonitorPanel.this.period.setVisible(false);
                }
                VoiceMonitorPanel.this.show.perform();
            }
        };
        new AbstractBGUPanel.MenuAction("voiceSessionLog.contract", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440", ClientUtils.getIcon((String)"fugue/folder-open-document-text")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceMonitorPanel.this.openContract();
            }
        };
        new AbstractBGUPanel.MenuAction("voiceSession.contract", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440", ClientUtils.getIcon((String)"fugue/folder-open-document-text")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceMonitorPanel.this.openContract();
            }
        };
        new AbstractBGUPanel.MenuAction("voiceSession.finish", "\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c (\u0437\u0430\u0432\u0438\u0441\u0448\u0443\u044e) \u0441\u0435\u0441\u0441\u0438\u044e", ClientUtils.getIcon((String)"fugue/plug--minus")){
            {
                this.putValue("LongDescription", "<html>\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0432 \u0411\u0414, \u043a\u0430\u043a \u0435\u0441\u043b\u0438 \u0431\u044b \u0432\u044b\u0448\u0435\u043b \u043b\u0438\u043c\u0438\u0442 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f<br>RADIUS- \u0438\u043b\u0438 Netflow-\u043f\u0430\u043a\u0435\u0442\u0430 (connection.close.timeout).</html>");
            }

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceSession session = (VoiceSession)VoiceMonitorPanel.this.modelCur.getSelectedRow();
                if (session != null && BGSwingUtilites.confirm((String)"\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435", null)) {
                    ((VoiceSessionService)((ClientContext)VoiceMonitorPanel.this.getContext()).getWebService(VoiceSessionService.class)).sessionFinish(session.getId());
                }
            }
        };
        new AbstractBGUPanel.MenuAction("voiceError.contract", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440", ClientUtils.getIcon((String)"fugue/folder-open-document-text")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceAuthError session = (VoiceAuthError)VoiceMonitorPanel.this.errorModel.getSelectedRow();
                if (session == null || session.getContractId() <= 0) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0448\u0438\u0431\u043a\u0443, \u0441 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0441\u0432\u044f\u0437\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
                }
                ClientUtils.openContract((int)session.getContractId());
            }
        };
    }

    private BGTableModel<VoiceSession> getSessionModel() {
        return this.mode == 2 ? this.modelLog : this.modelCur;
    }

    class SessionTableModel
    extends BGTableModel<VoiceSession> {
        public SessionTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("SessID", -1, 80, -1, "id", true);
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", -1, 150, -1, "contractTitle", true);
            this.addColumn("\u0410\u043a\u043a\u0430\u0443\u043d\u0442", -1, 240, -1, null, true);
            this.addColumn("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", -1, 150, -1, null, true);
            this.addColumn("\u0422\u0438\u043f", -1, -1, -1, null);
            this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", -1, -1, -1, null);
            this.addColumn("acctSessionId", -1, -1, -1, "acctSessionId", false, false);
            this.addColumn("\u0421 \u043d\u043e\u043c\u0435\u0440\u0430/\u043d\u0430 \u043d\u043e\u043c\u0435\u0440", -1, 150, -1, null, true);
            this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e", Column.DateTime.class, -1, 140, -1, "sessionStart", true);
            this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", Column.DateTime.class, -1, 140, -1, "sessionStop", true);
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c", Column.DateTime.class, -1, 140, -1, "lastActive", true);
            this.addColumn("\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", -1, 120, 200, null, true);
            this.addColumn("\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043e\u043a\u0440.", -1, -1, -1, "RoundedSessionTime", false, false);
            this.addColumn("C\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", -1, 90, -1, "sessionCost", true);
            this.addColumn("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", -1, -1, -1, "identifier", false, false);
        }

        public Object getValue(VoiceSession val, int column) {
            Object result = null;
            try {
                switch (column) {
                    case 1: {
                        result = val.getContractTitle() + "[" + val.getContractComment() + "]";
                        break;
                    }
                    case 2: {
                        result = val.getAccountTitle();
                        break;
                    }
                    case 3: {
                        result = "";
                        if (val.getDeviceId() > 0) {
                            VoiceDevice device = VoiceMonitorPanel.this.deviceMap.get(val.getDeviceId());
                            if (device == null) {
                                device = (VoiceDevice)((VoiceDeviceService)((ClientContext)VoiceMonitorPanel.this.getContext()).getWebService(VoiceDeviceService.class)).deviceGet(val.getDeviceId());
                                VoiceMonitorPanel.this.deviceMap.put(val.getDeviceId(), device);
                            }
                            if (device != null) {
                                result = device.getTitle();
                            }
                        }
                        break;
                    }
                    case 4: {
                        result = val.getCallType() == 1 ? ">>" : "<<";
                        break;
                    }
                    case 5: {
                        VoiceDestination dest = VoiceMonitorPanel.this.destMap.get(val.getDestinationId());
                        if (dest != null) {
                            result = dest.getTitle();
                        }
                        break;
                    }
                    case 7: {
                        result = "";
                        boolean flag = false;
                        if (val.getE164CallingStationId() != null) {
                            result = result + val.getE164CallingStationId();
                            flag = true;
                        }
                        if (val.getCalledStationId() != null) {
                            if (flag) {
                                result = result + "/";
                            }
                            result = result + val.getCalledStationId();
                        }
                        break;
                    }
                    case 11: {
                        result = Utils.formatSessionTime((int)((int)val.getSessionTime()));
                        break;
                    }
                    case 12: {
                        result = Utils.formatSessionTime((int)((int)val.getSessionTime()));
                        break;
                    }
                    default: {
                        result = super.getValue((Object)val, column);
                    }
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 " + ex.getMessage());
            }
            return result;
        }
    }

    class ErrorTableModel
    extends BGTableModel<VoiceAuthError> {
        public ErrorTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", -1, 200, -1, "contractTitle", true);
            this.addColumn("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", -1, 200, -1, "deviceTitle", true);
            this.addColumn("\u0410\u043a\u043a\u0430\u0443\u043d\u0442", -1, 200, -1, "accountTitle", true);
            this.addColumn("\u0412\u0440\u0435\u043c\u044f", Column.DateTime.class, -1, 150, -1, null, true);
            this.addColumn("\u041e\u0448\u0438\u0431\u043a\u0430", -1, 200, -1, "errorCode", true);
        }

        public Object getValue(VoiceAuthError val, int column) throws Exception {
            switch (column) {
                case 1: {
                    String result = "";
                    if (val.getDeviceId() > 0) {
                        VoiceDevice device = VoiceMonitorPanel.this.deviceMap.get(val.getDeviceId());
                        if (device == null) {
                            device = (VoiceDevice)((VoiceDeviceService)((ClientContext)VoiceMonitorPanel.this.getContext()).getWebService(VoiceDeviceService.class)).deviceGet(val.getDeviceId());
                            VoiceMonitorPanel.this.deviceMap.put(val.getDeviceId(), device);
                        }
                        if (device != null) {
                            result = device.getTitle();
                        }
                    }
                    return result;
                }
                case 3: {
                    return val.getLastErrorTime();
                }
                case 4: {
                    return "[" + val.getErrorCode() + "] " + val.getErrorText();
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    class VoiceLogForm
    extends BGUPanel {
        private JTextArea log = new JTextArea();

        VoiceLogForm() {
        }

        protected void jbInit() {
            this.setLayout(new GridBagLayout());
            this.add(new JScrollPane(this.log), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            JButton exit = new JButton();
            exit.setText("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
            this.log.setEditable(false);
            this.add(exit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            exit.addActionListener(e -> this.performActionClose());
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    VoiceLogForm.this.getLog(e);
                }

                public void setEnabled(boolean enable) {
                    super.setEnabled(true);
                }
            };
            new AbstractBGUPanel.MenuAction("voiceSession.log", "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c RADIUS \u043b\u043e\u0433", ClientUtils.getIcon((String)"fugue/receipt-text")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    VoiceLogForm.this.getLog(e);
                }
            };
            new AbstractBGUPanel.MenuAction("voiceSessionLog.log", "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c RADIUS \u043b\u043e\u0433", ClientUtils.getIcon((String)"fugue/receipt-text")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    VoiceLogForm.this.getLog(e);
                }
            };
            new AbstractBGUPanel.MenuAction("voiceError.log", "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c RADIUS \u043b\u043e\u0433", ClientUtils.getIcon((String)"fugue/receipt-text")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    VoiceLogForm.this.getLog(e);
                }
            };
        }

        private void getLog(ActionEvent e) throws Exception {
            VoiceRequestLogService wsRequestLog = (VoiceRequestLogService)((ClientContext)this.getContext()).getWebService(VoiceRequestLogService.class);
            if (VoiceMonitorPanel.this.mode == 1) {
                VoiceAuthError error = (VoiceAuthError)VoiceMonitorPanel.this.errorModel.getSelectedRow();
                if (error != null) {
                    this.log.setText(wsRequestLog.authErrorLog(error.getDeviceId(), error.getLastErrorTime(), error.getLogCoordinateRecordId()));
                }
                this.performActionOpen();
            } else {
                VoiceSession session = (VoiceSession)VoiceMonitorPanel.this.getSessionModel().getSelectedRow();
                if (session != null) {
                    this.log.setText(wsRequestLog.voiceConnectionLog(session.getDeviceId(), session.getId(), session.getSessionStart(), VoiceMonitorPanel.this.mode == 2));
                }
                this.performActionOpen();
            }
        }
    }
}

