/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceLinkPlan;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ServiceLinkPlanManager {
    private Connection con;
    private String tableName;

    public ServiceLinkPlanManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "ipn_service_link_plan_" + mid;
    }

    public List<ServiceLinkPlan> getPlanList(int type) {
        ArrayList<ServiceLinkPlan> result = new ArrayList<ServiceLinkPlan>();
        try {
            StringBuilder query = new StringBuilder(400);
            query.append("SELECT * FROM ");
            query.append(this.tableName);
            if (type >= 0) {
                query.append(" WHERE type=");
                query.append(type);
            }
            query.append(" ORDER BY title");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ServiceLinkPlan plan = this.getPlanFromRs(rs);
                result.add(plan);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, ServiceLinkPlan> getPlanMap() {
        HashMap<Integer, ServiceLinkPlan> result = new HashMap<Integer, ServiceLinkPlan>();
        try {
            String query = "SELECT * FROM " + this.tableName;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ServiceLinkPlan plan = this.getPlanFromRs(rs);
                result.put(plan.getId(), plan);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updatePlan(ServiceLinkPlan plan) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (plan.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (type, title) VALUES (?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.tableName + " SET type=?, title=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(3, plan.getId());
            }
            ps.setInt(1, plan.getType());
            ps.setString(2, plan.getTitle());
            ps.executeUpdate();
            if (plan.getId() <= 0) {
                plan.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deletePlan(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ServiceLinkPlan getPlanById(int id) {
        ServiceLinkPlan result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getPlanFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private ServiceLinkPlan getPlanFromRs(ResultSet rs) throws SQLException {
        ServiceLinkPlan plan = new ServiceLinkPlan();
        plan.setId(rs.getInt("id"));
        plan.setType(rs.getInt("type"));
        plan.setTitle(rs.getString("title"));
        return plan;
    }
}

