/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ZoneEditor
extends BGPanel {
    private BGTable table = new BGTable();
    private BGTextField title = new BGTextField();
    private BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
    private JPanel editorPanel = new JPanel();
    private int currentId = 0;

    public ZoneEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "zone");
    }

    private void jbInit() throws Exception {
        this.okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)this.okCancel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editorPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
        this.editorPanel.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ZoneEditor.this.editItem();
                }
            }
        });
    }

    private void stopEdit(boolean save) {
        if (save) {
            if (Utils.isEmptyString((String)this.title.getText().trim())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("ZoneUpdate");
            request.setContractId(this.getContractId());
            request.setAttribute("id", this.currentId);
            request.setAttribute("title", this.title.getText());
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.table.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
                this.editorPanel.setVisible(false);
            }
        } else {
            this.editorPanel.setVisible(false);
        }
    }

    public void deleteItem() {
        String id = ClientUtils.getRowId((BGTable)this.table);
        if (id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043e\u043d\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setAction("ZoneDelete");
            request.setAttribute("id", id);
            this.stopEdit(false);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.table.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
            }
        }
    }

    public void editItem() {
        this.currentId = Utils.parseInt((String)ClientUtils.getRowId((BGTable)this.table), (int)-1);
        if (this.currentId > 0) {
            this.startEdit();
        }
    }

    public void newItem() {
        this.currentId = 0;
        this.startEdit();
    }

    private void startEdit() {
        if (this.currentId > 0) {
            Request req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setContractId(this.getContractId());
            req.setAction("ZoneGet");
            req.setAttribute("id", this.currentId);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element element = XMLUtils.getElement((Document)doc, (String)"zone");
                this.title.setText(element.getAttribute("title"));
            }
        } else {
            this.title.setText("");
        }
        this.editorPanel.setVisible(true);
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setAction("Zone");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
        }
    }
}

