/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTable;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTableModel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTableModelItem;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class PatternModuleTabPanelItemFactory
implements PatternModuleTabPanel.PatternModuleTabPanelItemFactory {
    private static final String ELEMENT_NAME_BILL = "bill";
    private BillService billService = null;
    private ClientContext clientContext = null;

    public Collection<PatternModuleTabPanel.PatternModuleTabPanelItem> getPatternModuleTabPanelItems(int moduleId, String moduleTitle) {
        this.clientContext = new ClientContext(ELEMENT_NAME_BILL, moduleId, -1, -1, AddDefaultAccountTabPanel.class.getPackage());
        LinkedHashSet<PatternModuleTabPanel.PatternModuleTabPanelItem> items = new LinkedHashSet<PatternModuleTabPanel.PatternModuleTabPanelItem>();
        items.add(new AddDocumentTypeTabPanel(moduleId, moduleTitle));
        items.add(new AddDetailsTabPanel(moduleId, moduleTitle));
        items.add(new AddDefaultAccountTabPanel(moduleId, moduleTitle));
        return items;
    }

    private BillService getBillService() {
        if (this.billService == null) {
            this.billService = (BillService)this.clientContext.getPort(BillService.class);
        }
        return this.billService;
    }

    private class AddDefaultAccountTabPanel
    extends PatternModuleTabPanel.PatternModuleTabPanelItem {
        private static final String KEY_ORGANIZATION_ID = "organizationId";
        private static final String KEY_BANK_ACCOUNT_ID = "bankAccountId";
        private String title;
        private PatternTable organizationTable;
        private PatternTableModel organizationTableModel;
        private PatternTable bankAccountTable;
        private PatternTableModel bankAccountTableModel;

        private AddDefaultAccountTabPanel(int moduleId, String title) {
            super((LayoutManager)new GridBagLayout(), moduleId);
            this.title = "\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f, \u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0447\u0435\u0442";
            this.organizationTable = null;
            this.organizationTableModel = null;
            this.bankAccountTable = null;
            this.bankAccountTableModel = null;
            this.organizationTableModel = new PatternTableModel(AddDefaultAccountTabPanel.class.getName());
            this.organizationTable = new PatternTable((BGTableModel)this.organizationTableModel);
            this.organizationTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        AddDefaultAccountTabPanel.this.setBankAccountData(AddDefaultAccountTabPanel.this.organizationTable.getSelectedId());
                    }
                }
            });
            this.bankAccountTableModel = new PatternTableModel(AddDefaultAccountTabPanel.class.getName());
            this.bankAccountTable = new PatternTable((BGTableModel)this.bankAccountTableModel);
            Dimension dimension = new Dimension(200, 300);
            JScrollPane scrollPane = new JScrollPane((Component)this.organizationTable);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            int gridy = 0;
            this.add(new JLabel("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f"), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 5, 3, 0), 0, 0));
            this.add(scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(new JLabel("\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0447\u0435\u0442"), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 5, 3, 0), 0, 0));
            this.add(new JScrollPane((Component)this.bankAccountTable), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        protected void init() {
            try {
                List organizations = PatternModuleTabPanelItemFactory.this.getBillService().getOrganizationList();
                ArrayList<PatternTableModelItem> items = new ArrayList<PatternTableModelItem>();
                organizations.stream().forEach(o -> items.add(new PatternTableModelItem(new IdTitle(o.getId(), o.getTitle()))));
                items.add(0, new PatternTableModelItem(new IdTitle(0, "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e")));
                this.organizationTableModel.setData(items);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        private void setBankAccountData(int organizationId) {
            try {
                ArrayList<PatternTableModelItem> items = new ArrayList<PatternTableModelItem>();
                if (organizationId > 0) {
                    List accounts = PatternModuleTabPanelItemFactory.this.getBillService().getBankAccountList(organizationId, null);
                    for (BankAccount bankAccount : accounts) {
                        IdTitle idTitle = new IdTitle(bankAccount.getId(), bankAccount.getTitle() + (bankAccount.isInUse() ? "" : " (\u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f)"));
                        items.add(new PatternTableModelItem(idTitle));
                    }
                }
                items.add(0, new PatternTableModelItem(new IdTitle(0, "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e")));
                items.add(0, new PatternTableModelItem(new IdTitle(-1, "\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043f\u0440\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438")));
                this.bankAccountTableModel.setData(items);
                BankAccount bankAccount = PatternModuleTabPanelItemFactory.this.getBillService().getDefaultBankAccount(organizationId);
                this.bankAccountTable.setSelected(bankAccount == null ? 0 : bankAccount.getId());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        protected boolean isItemEnabled() {
            return false;
        }

        protected void setData(Element element) throws Exception {
            int organizationId = 0;
            int bankAccountId = 0;
            Element billElement = XMLUtils.selectElement((Node)element, (String)("data/modules/bill[@mid=" + this.getModuleId() + "]"));
            if (billElement != null) {
                organizationId = Utils.parseInt((String)billElement.getAttribute(KEY_ORGANIZATION_ID), (int)0);
                bankAccountId = Utils.parseInt((String)billElement.getAttribute(KEY_BANK_ACCOUNT_ID), (int)0);
            }
            this.organizationTable.setSelected(organizationId);
            this.setBankAccountData(organizationId);
            boolean selected = false;
            for (PatternTableModelItem item : this.bankAccountTableModel.getRows()) {
                selected = item.getId() == bankAccountId;
                if (!selected) continue;
                this.bankAccountTable.setSelected(item.getId());
                break;
            }
            if (!selected) {
                this.bankAccountTable.setSelected(0);
            }
        }

        protected void reset() {
            this.organizationTable.setSelected(0);
            this.bankAccountTable.setSelected(0);
        }

        protected void serialise(Element element) throws Exception {
            Element module = XMLUtils.selectElement((Node)element, (String)PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            if (module == null) {
                module = XMLUtils.createElement((Element)element, (String)PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            }
            module.setAttribute(KEY_BANK_ACCOUNT_ID, String.valueOf(this.bankAccountTable.getSelectedId()));
            module.setAttribute(KEY_ORGANIZATION_ID, String.valueOf(this.organizationTable.getSelectedId()));
        }

        public String getTitle() {
            return this.title;
        }
    }

    private class AddDocumentTypeTabPanel
    extends PatternModuleTabPanel.PatternModuleTabPanelItem {
        private BGControlPanelListSelect bills;
        private BGControlPanelListSelect invoices;
        private String title;

        private AddDocumentTypeTabPanel(int moduleId, String title) {
            super((LayoutManager)new GridBagLayout(), moduleId);
            this.bills = new BGControlPanelListSelect();
            this.invoices = new BGControlPanelListSelect();
            this.title = null;
            this.setTitle(" \u0421\u0447\u0435\u0442\u0430, \u0421\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0410\u043a\u0442\u044b, \u0423\u041f\u0414 (\u0442\u0438\u043f\u044b) ");
            this.bills.setBorder((Border)new BGTitleBorder(" \u0421\u0447\u0435\u0442\u0430 "));
            this.invoices.setBorder((Border)new BGTitleBorder(" \u0421\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0410\u043a\u0442\u044b, \u0423\u041f\u0414 "));
            this.bills.setMinimumSize(new Dimension(180, 200));
            this.bills.setPreferredSize(new Dimension(180, 200));
            this.add((Component)this.bills, new GridBagConstraints(1, 0, 1, 3, 0.4, 1.0, 14, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.invoices.setMinimumSize(new Dimension(180, 200));
            this.invoices.setPreferredSize(new Dimension(180, 200));
            this.add((Component)this.invoices, new GridBagConstraints(2, 0, 1, 3, 0.4, 1.0, 14, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        protected boolean isItemEnabled() {
            return false;
        }

        protected void init() {
            List docTypes;
            ClientContext context = new ClientContext(PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL, this.getModuleId(), 0, null);
            try {
                docTypes = ((BillService)context.getWebService(BillService.class, this.getModuleId())).docTypeList(DocumentType.BILL);
                this.bills.getListModel().clear();
                docTypes.forEach(a -> this.bills.getListModel().addElement(new BGUListItem(a.toIdTitle())));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            try {
                docTypes = ((BillService)context.getWebService(BillService.class, this.getModuleId())).docTypeList(DocumentType.INVOICE);
                this.invoices.getListModel().clear();
                docTypes.forEach(a -> this.invoices.getListModel().addElement(new BGUListItem(a.toIdTitle())));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        protected void reset() {
            this.bills.setListItemSelected(false);
            this.invoices.setListItemSelected(false);
        }

        protected void serialise(Element element) throws Exception {
            Element addDocumentType;
            String bills = this.bills.getListValues();
            String invoices = this.invoices.getListValues();
            Element module = XMLUtils.selectElement((Node)element, (String)PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            if (module == null) {
                module = XMLUtils.createElement((Element)element, (String)PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            }
            module.setAttribute("mid", String.valueOf(this.getModuleId()));
            Element addDocuments = XMLUtils.createElement((Element)module, (String)"addDocuments");
            if (Utils.notEmptyString((String)bills) || Utils.notEmptyString((String)invoices)) {
                addDocuments.setAttribute("enable", "1");
            } else {
                addDocuments.setAttribute("enable", "0");
            }
            if (Utils.notEmptyString((String)bills)) {
                addDocumentType = XMLUtils.createElement((Element)addDocuments, (String)"addDocumentType");
                addDocumentType.setAttribute("type", PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
                addDocumentType.setAttribute("docTypes", bills);
            }
            if (Utils.notEmptyString((String)invoices)) {
                addDocumentType = XMLUtils.createElement((Element)addDocuments, (String)"addDocumentType");
                addDocumentType.setAttribute("type", "invoice");
                addDocumentType.setAttribute("docTypes", invoices);
            }
        }

        protected void setData(Element element) throws Exception {
            Element addDocuments = XMLUtils.selectElement((Node)element, (String)("data/modules/bill[@mid=" + this.getModuleId() + "]/addDocuments"));
            this.bills.setListItemSelected(false);
            this.invoices.setListItemSelected(false);
            if (addDocuments != null) {
                for (Element addDocumentType : XMLUtils.selectElements((Node)addDocuments, (String)"addDocumentType")) {
                    if (PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL.equals(addDocumentType.getAttribute("type"))) {
                        this.bills.setListValues(addDocumentType.getAttribute("docTypes"));
                        continue;
                    }
                    if (!"invoice".equals(addDocumentType.getAttribute("type"))) continue;
                    this.invoices.setListValues(addDocumentType.getAttribute("docTypes"));
                }
            }
        }
    }

    private class AddDetailsTabPanel
    extends PatternModuleTabPanel.PatternModuleTabPanelItem {
        private String title;
        private List<AttributeType> attributeTypes;
        private List<IdTitle> contractParameters;
        private DetailsTableModel detailsTableModel;

        private AddDetailsTabPanel(int moduleId, String title) {
            super((LayoutManager)new GridBagLayout(), moduleId);
            this.title = "\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b";
            this.attributeTypes = null;
            this.contractParameters = null;
            this.detailsTableModel = new DetailsTableModel();
            BGUTable table = new BGUTable((TableModel)((Object)this.detailsTableModel));
            table.setSelectionMode(0);
            BGDialogToolBar toolBar = new BGDialogToolBar();
            toolBar.setDefaultButtons(e -> {
                switch (BGDialogToolBar.ButtonData.of((String)e.getActionCommand())) {
                    case NEW_ITEM: {
                        List<Integer> typeIds = this.detailsTableModel.getRows().stream().map(a -> Utils.parseInt((String)a.getAttribute("typeId"))).toList();
                        BGUList list = new BGUList();
                        list.setData(this.getAttributeTypes().stream().filter(a -> !typeIds.contains(a.getId())).map(IdTitle::toIdTitle).toList());
                        list.setSelectionMode(0);
                        JOptionPane.showMessageDialog((Component)BGClientBase.getFrame(), BGSwingUtilites.wrapScrollPane((JComponent)list, (int)500, (int)300), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442", -1);
                        IdTitle idTitle = (IdTitle)list.getSelectedValue();
                        if (idTitle == null) break;
                        try {
                            AttributeType attributeType = this.getAttributeTypes().stream().filter(a -> a.getId() == idTitle.getId()).findFirst().get();
                            Element element = XMLUtils.createElement((Document)XMLUtils.newDocument(), (String)"item");
                            element.setAttribute("typeId", String.valueOf(idTitle.getId()));
                            element.setAttribute("title", idTitle.getTitle());
                            element.setAttribute("name", attributeType.getName());
                            element.setAttribute("type", "1");
                            element.setAttribute("value", "");
                            this.detailsTableModel.addRow(element);
                            new AttributeEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430", element).open();
                        }
                        catch (Exception attributeType) {}
                        break;
                    }
                    case EDIT_ITEM: {
                        Element element = (Element)this.detailsTableModel.getSelectedRow();
                        if (element == null) break;
                        new AttributeEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430", element).open();
                        break;
                    }
                    case DELETE_ITEM: {
                        Element element = (Element)this.detailsTableModel.getSelectedRow();
                        if (element == null || !ClientUtils.confirmDelete((Object)element.getAttribute("name"))) break;
                        this.detailsTableModel.deleteRow(element);
                        break;
                    }
                }
            }, new BGDialogToolBar.ButtonData[]{BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM});
            toolBar.setFloatable(false);
            this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add(new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        }

        private List<AttributeType> getAttributeTypes() {
            if (this.attributeTypes == null) {
                try {
                    this.attributeTypes = PatternModuleTabPanelItemFactory.this.getBillService().attributeTypeList();
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
            return this.attributeTypes;
        }

        private List<IdTitle> getContractParameters() {
            if (this.contractParameters == null) {
                try {
                    this.contractParameters = PatternModuleTabPanelItemFactory.this.getBillService().contractParameters();
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
            return this.contractParameters;
        }

        protected boolean isItemEnabled() {
            return false;
        }

        protected void setData(Element element) throws Exception {
            this.detailsTableModel.deleteRows();
            Element module = XMLUtils.selectElement((Node)element, (String)("//bill[@mid=" + this.getModuleId() + "]"));
            if (module == null) {
                return;
            }
            Element rekvisitsList = XMLUtils.selectElement((Node)module, (String)"rekvisits");
            if (rekvisitsList == null) {
                return;
            }
            ArrayList<Element> list = new ArrayList<Element>();
            NodeList nodeList = rekvisitsList.getChildNodes();
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Node node = nodeList.item(index);
                if (!(node instanceof Element)) continue;
                Element el = (Element)node;
                list.add(el);
            }
            this.detailsTableModel.setData(list);
        }

        protected void reset() {
        }

        protected void serialise(Element element) throws Exception {
            Element rekvisitsList;
            Element module = XMLUtils.selectElement((Node)element, (String)PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            if (module == null) {
                module = XMLUtils.createElement((Element)element, (String)PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            }
            if ((rekvisitsList = XMLUtils.selectElement((Node)module, (String)"rekvisits")) == null) {
                rekvisitsList = XMLUtils.createElement((Element)module, (String)"rekvisits");
            } else {
                NodeList nodeList = rekvisitsList.getChildNodes();
                for (int index = 0; index < nodeList.getLength(); ++index) {
                    rekvisitsList.removeChild(nodeList.item(index));
                }
            }
            for (Element a : this.detailsTableModel.getRows()) {
                rekvisitsList.appendChild(rekvisitsList.getOwnerDocument().importNode(a, true));
            }
        }

        public String getTitle() {
            return this.title;
        }

        protected void init() {
        }

        class DetailsTableModel
        extends BGTableModel<Element> {
            public DetailsTableModel() {
                super(DetailsTableModel.class.getName());
            }

            protected void initColumns() {
                this.addColumn("\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442", 200, 300, 400, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0422\u0438\u043f", 200, 200, 200, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, -1, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            }

            public Object getValue(Element val, int column) throws Exception {
                String identifier = this.getIdentifier(column);
                if ("type".equals(identifier)) {
                    return "1".equals(val.getAttribute(identifier)) ? "\u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430" : "\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430";
                }
                if ("value".equals(identifier)) {
                    if ("1".equals(val.getAttribute("type"))) {
                        return val.getAttribute(identifier);
                    }
                    int id = Utils.parseInt((String)val.getAttribute(identifier));
                    return AddDetailsTabPanel.this.getContractParameters().stream().filter(a -> a.getId() == id).findFirst().map(a -> a.getTitle()).orElse("??? [ID#" + String.valueOf(id) + "]");
                }
                return super.getValue((Object)val, column);
            }
        }

        class AttributeEditor
        extends BGEditorDialog<Element> {
            private ButtonGroup buttonGroup;
            private JTextField rekv;
            private JTextField rekvConstValue;
            private BGUList<IdTitle> parameterList;
            private JRadioButton typeConst;
            private JRadioButton typeParameter;

            public AttributeEditor(String title, Element data) {
                super(title, (Object)data);
                this.buttonGroup = new ButtonGroup();
                this.rekv = new JTextField(50);
                this.rekvConstValue = new JTextField();
                this.parameterList = new BGUList();
                this.typeConst = new JRadioButton("\u0442\u0438\u043f \u041a\u041e\u041d\u0421\u0422\u0410\u041d\u0422\u0410");
                this.typeParameter = new JRadioButton("\u0442\u0438\u043f \u041f\u0410\u0420\u0410\u041c\u0415\u0422\u0420 \u0414\u041e\u0413\u041e\u0412\u041e\u0420\u0410");
            }

            public void doDialogPanel() {
                Color bgColor = this.rekv.getBackground();
                this.rekv.setEditable(false);
                this.rekv.setBackground(bgColor);
                this.buttonGroup.add(this.typeConst);
                this.buttonGroup.add(this.typeParameter);
                this.panel.add((Component)new JLabel("\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
                this.panel.add((Component)this.rekv, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
                this.panel.add((Component)this.typeConst, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
                this.panel.add((Component)this.rekvConstValue, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
                this.panel.add((Component)this.typeParameter, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
                this.panel.add((Component)new JScrollPane((Component)this.parameterList), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 0, 0), 0, 0));
                this.parameterList.setData(AddDetailsTabPanel.this.getContractParameters());
                this.rekv.setText(((Element)this.data).getAttribute("title"));
                this.typeConst.setSelected("1".equals(((Element)this.data).getAttribute("type")));
                this.typeParameter.setSelected("2".equals(((Element)this.data).getAttribute("type")));
                if ("1".equals(((Element)this.data).getAttribute("type"))) {
                    this.rekvConstValue.setText(((Element)this.data).getAttribute("value"));
                } else {
                    this.parameterList.setSelectedId(Utils.parseInt((String)((Element)this.data).getAttribute("value")), true);
                }
            }

            public boolean doApply() throws Exception {
                ((Element)this.data).setAttribute("type", this.typeConst.isSelected() ? "1" : "2");
                ((Element)this.data).setAttribute("value", this.typeConst.isSelected() ? this.rekvConstValue.getText() : String.valueOf(((IdTitle)this.parameterList.getSelectedValue()).getId()));
                AddDetailsTabPanel.this.detailsTableModel.fireTableDataChanged();
                return true;
            }
        }
    }
}

