/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.action;

import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.phone.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.phone.server.bean.oper.Operator;
import ru.bitel.bgbilling.modules.phone.server.bean.oper.OperatorManager;
import ru.bitel.bgbilling.modules.phone.server.bean.oper.Report;
import ru.bitel.common.Preferences;

public class ActionReportTable
extends ActionBase {
    public void doAction() throws Exception {
        int operId = this.getIntParameter("oper_id", 0);
        Date month = this.getDateParameter("month");
        if (operId <= 0 || month == null || this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Operator oper = new OperatorManager(this.mid, (Preferences)this.moduleSetup).getOperatorMap().get(operId);
        if (oper == null) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + operId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
        }
        boolean hasSnapshot = oper.hasShapshot(this.con, month);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (Report report : oper.getReportList(month, hasSnapshot)) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(report.getId()));
            row.setAttribute("title", report.getTitle());
            row.setAttribute("file_name", report.getFileName());
            int type = report.getType();
            row.setAttribute("type_id", String.valueOf(type));
            switch (type) {
                case 2: {
                    row.setAttribute("type", "CSV");
                    row.setAttribute("action", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
                    break;
                }
                case 3: {
                    row.setAttribute("type", "XML");
                    row.setAttribute("action", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
                    break;
                }
                case 1: {
                    row.setAttribute("type", "\u041f\u0415\u0427\u0410\u0422\u041d\u0410\u042f \u0424\u041e\u0420\u041c\u0410");
                    row.setAttribute("action", "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c");
                    break;
                }
                case 4: {
                    row.setAttribute("type", "DBF");
                    row.setAttribute("action", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
                }
            }
        }
    }
}

