/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleType;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class RuleTypeManager {
    private Connection con;
    private String tableName;
    private String tableGateRuleName;

    public RuleTypeManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "ipn_rule_type_" + mid;
        this.tableGateRuleName = "ipn_gate_rule_" + mid;
    }

    public List<RuleType> getTypeList() {
        ArrayList<RuleType> result = new ArrayList<RuleType>();
        try {
            String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getTypeFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<RuleType> getTypeList(int gateTypeId) {
        ArrayList<RuleType> result = new ArrayList<RuleType>();
        try {
            String query = "SELECT type.* FROM " + this.tableName + " AS type LEFT JOIN " + this.tableGateRuleName + " AS link ON link.rtid = type.id  WHERE  link.gtid = ? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, gateTypeId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getTypeFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<RuleType> updateGateRules(int gateTypeId, List<RuleType> rules) {
        ArrayList<RuleType> result = new ArrayList<RuleType>();
        try {
            String query = "DELETE FROM " + this.tableGateRuleName + " WHERE gtid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, gateTypeId);
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO " + this.tableGateRuleName + " (gtid, rtid) VALUES (?, ?) ";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, gateTypeId);
            for (RuleType rule : rules) {
                ps.setInt(2, rule.getId());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, RuleType> getTypeMap(int gateTypeId) {
        HashMap<Integer, RuleType> result = new HashMap<Integer, RuleType>();
        try {
            String query = "SELECT type.* FROM " + this.tableName + " AS type LEFT JOIN " + this.tableGateRuleName + " AS link ON link.rtid = type.id  WHERE  link.gtid = ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, gateTypeId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RuleType type = this.getTypeFromRs(rs);
                result.put(type.getId(), type);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, RuleType> getTypeMap() {
        HashMap<Integer, RuleType> result = new HashMap<Integer, RuleType>();
        try {
            String query = "SELECT * FROM " + this.tableName;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RuleType type = this.getTypeFromRs(rs);
                result.put(type.getId(), type);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public RuleType getType(int id) {
        RuleType result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getTypeFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateType(RuleType type) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (type.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (title, comment, data) VALUES (?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.tableName + " SET  title=?, comment=?, data=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(4, type.getId());
            }
            ps.setString(1, type.getTitle());
            ps.setString(2, type.getComment());
            ps.setString(3, type.getData());
            ps.executeUpdate();
            if (type.getId() <= 0) {
                type.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean deleteType(int id) {
        try {
            String query = "SELECT * FROM " + this.tableGateRuleName + " WHERE rtid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return false;
            }
            rs.close();
            ps.close();
            query = "DELETE FROM " + this.tableName + " WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private RuleType getTypeFromRs(ResultSet rs) throws SQLException {
        RuleType result = new RuleType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setComment(rs.getString("comment"));
        result.setData(rs.getString("data"));
        return result;
    }
}

