/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IPField;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ServiceLinkEditor
extends BGPanel {
    private String data;
    private boolean wasInit = false;
    private BGComboBox<ComboBoxItem> direct_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> source_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> iface_CB = new BGComboBox();
    private IPField ip1_TF = new IPField();
    private IPField ip2_TF = new IPField();
    private IntTextField port1_TF = new IntTextField();
    private IntTextField port2_TF = new IntTextField();
    private BGComboBox<ComboBoxItem> service_CB = new BGComboBox();
    private BGControlPanelPeriodNoB period_P = new BGControlPanelPeriodNoB();
    private IntTextField rulePos_TF = new IntTextField();
    private JTextArea comment_TA = new JTextArea();
    private BGTextField diffServ = new BGTextField(7);
    private int id = -1;

    public ServiceLinkEditor() {
        try {
            this.jbInit();
            this.diffServ.setHorizontalAlignment(0);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.ip1_TF.setIP("0.0.0.0");
        this.port1_TF.setMinimumSize(new Dimension(50, 24));
        this.port1_TF.setPreferredSize(new Dimension(59, 24));
        this.port2_TF.setMinimumSize(new Dimension(50, 24));
        this.port2_TF.setPreferredSize(new Dimension(59, 24));
        this.rulePos_TF.setMinimumSize(new Dimension(100, 24));
        this.rulePos_TF.setPreferredSize(new Dimension(59, 24));
        this.rulePos_TF.setRadix(10);
        this.source_CB.addActionListener(e -> this.showIfaces());
        BGButtonPanelOkCancel bGControlPanel_051 = new BGButtonPanelOkCancel();
        bGControlPanel_051.addActionListener(e -> this.stopEdit(e));
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.setBorder((Border)new BGTitleBorder(" \u041f\u0430\u043a\u0435\u0442 "));
        jPanel1.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel1.add((Component)new JLabel("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a:"), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel1.add((Component)this.direct_CB, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        jPanel1.add((Component)this.source_CB, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        jPanel1.add((Component)new JLabel("IP \u0430\u0434\u0440\u0435\u0441\u0430:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        jPanel1.add((Component)this.ip1_TF, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        jPanel1.add((Component)new JLabel(" - "), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add((Component)this.ip2_TF, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel1.add((Component)new JLabel("\u041f\u043e\u0440\u0442\u044b:"), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        jPanel1.add((Component)this.port1_TF, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        jPanel1.add((Component)new JLabel(" - "), new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add((Component)this.port2_TF, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        jPanel1.add((Component)new JLabel("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel1.add((Component)this.iface_CB, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        jPanel1.add((Component)new JLabel("ToS/DiffServ:"), new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        jPanel1.add((Component)this.diffServ, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder((Border)new BGTitleBorder(" \u0423\u0441\u043b\u0443\u0433\u0430 "));
        jPanel2.add((Component)this.service_CB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel2.add((Component)this.period_P, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder((Border)new BGTitleBorder(" \u041d\u043e\u043c\u0435\u0440 \u043f\u0440\u0430\u0432\u0438\u043b\u0430 "));
        jPanel3.add((Component)this.rulePos_TF, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder((Border)new BGTitleBorder(" \u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435 "));
        jPanel4.add((Component)new JScrollPane(this.comment_TA), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(jPanel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel4, new GridBagConstraints(1, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)bGControlPanel_051, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    public void setData(String data) {
        this.init();
        this.rulePos_TF.setValue(0L);
        this.period_P.setDateCalendar1((Calendar)new GregorianCalendar());
        this.period_P.setDateString2("");
        if (this.source_CB.getItemCount() > 0) {
            this.source_CB.setSelectedIndex(0);
        }
        this.direct_CB.setSelectedIndex(0);
        this.ip1_TF.setIPValue(0L);
        this.ip2_TF.setIPValue(0L);
        this.port1_TF.setText("0");
        this.port2_TF.setText("65535");
        if (this.service_CB.getItemCount() > 0) {
            this.service_CB.setSelectedIndex(0);
        }
        this.comment_TA.setText("");
        this.id = -1;
        if (data != null) {
            Map pairs = Utils.stringToPairsHash((String)data);
            this.id = Utils.parseInt((String)((String)pairs.get("id")), (int)-1);
            this.rulePos_TF.setText(Utils.maskNull((String)((String)pairs.get("pos"))));
            this.period_P.setDateString1(Utils.maskNull((String)((String)pairs.get("date1"))));
            this.period_P.setDateString2(Utils.maskNull((String)((String)pairs.get("date2"))));
            ClientUtils.setComboBoxSelection(this.source_CB, (Object)Utils.maskNull((String)((String)pairs.get("source"))));
            ClientUtils.setComboBoxSelection(this.direct_CB, (Object)Utils.maskNull((String)((String)pairs.get("direct"))));
            this.ip1_TF.setIPValue(Utils.parseLong((String)Utils.maskNull((String)((String)pairs.get("addr1"))), (long)0L));
            this.ip2_TF.setIPValue(Utils.parseLong((String)Utils.maskNull((String)((String)pairs.get("addr2"))), (long)0L));
            this.port1_TF.setText(Utils.maskNull((String)((String)pairs.get("port1"))));
            this.port2_TF.setText(Utils.maskNull((String)((String)pairs.get("port2"))));
            this.diffServ.setText(Utils.maskNull((String)((String)pairs.get("diffServ"))));
            ClientUtils.setComboBoxSelection(this.service_CB, (Object)Utils.maskNull((String)((String)pairs.get("sid"))));
            this.showIfaces();
            ClientUtils.setComboBoxSelection(this.iface_CB, (Object)Utils.maskNull((String)((String)pairs.get("iface"))));
            this.comment_TA.setText(Utils.maskNull((String)((String)pairs.get("comment"))));
        }
    }

    public String getData() {
        return this.data;
    }

    private void init() {
        if (!this.wasInit) {
            this.wasInit = true;
            Request req = new Request();
            req.setModule("contract");
            req.setModuleId(this.getModuleId());
            req.setAction("ModuleServices");
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.service_CB.setModel((ComboBoxModel)ClientUtils.buildComboBox((Node)XMLUtils.getNode((Document)doc, (String)"services"), (String)""));
            }
            req = new Request();
            req.setModule("load");
            req.setAction("SourceList");
            req.setModuleId(this.getModuleId());
            doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.source_CB.setModel((ComboBoxModel)ClientUtils.buildComboBox((Node)XMLUtils.getNode((Document)doc, (String)"list"), (String)""));
            }
            this.source_CB.insertItemAt((Object)new ComboBoxItem((Object)"0", "\u043b\u044e\u0431\u043e\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a"), 0);
            this.direct_CB.addItem((Object)new ComboBoxItem((Object)"0", "\u0432\u0441\u0435"));
            this.direct_CB.addItem((Object)new ComboBoxItem((Object)"1", "\u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435"));
            this.direct_CB.addItem((Object)new ComboBoxItem((Object)"2", "\u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0435"));
            this.rulePos_TF.setMinValue(1L);
            this.rulePos_TF.setMaxValue(10000L);
        }
    }

    private void stopEdit(ActionEvent e) {
        if (e.getActionCommand().equals("ok")) {
            if (Utils.isBlankString((String)this.rulePos_TF.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043f\u0440\u0430\u0432\u0438\u043b\u0430!");
                return;
            }
            if (Utils.isBlankString((String)this.port1_TF.getText()) || Utils.isBlankString((String)this.port2_TF.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043f\u043e\u0440\u0442\u043e\u0432!");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("CheckServiceLink");
            request.setAttribute("date1", this.period_P.getDateString1());
            request.setAttribute("date2", this.period_P.getDateString2());
            request.setAttribute("id", this.id);
            request.setModuleId(this.getModuleId());
            try {
                Document doc = this.getDocument(request);
                Element checkEl = XMLUtils.selectElement((Node)doc, (String)"//check");
                String check = checkEl.getAttribute("check");
                if (!Utils.isEmptyString((String)check)) {
                    ClientUtils.showErrorMessageDialog((String)check);
                    return;
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            ComboBoxItem source = (ComboBoxItem)this.source_CB.getSelectedItem();
            ComboBoxItem direct = (ComboBoxItem)this.direct_CB.getSelectedItem();
            ComboBoxItem sid = (ComboBoxItem)this.service_CB.getSelectedItem();
            String iface = ClientUtils.getIdFromComboBox(this.iface_CB);
            data.put("id", String.valueOf(this.id));
            data.put("pos", this.rulePos_TF.getText());
            data.put("date1", this.period_P.getDateString1());
            data.put("date2", this.period_P.getDateString2());
            data.put("source", (String)source.getObject());
            data.put("direct", (String)direct.getObject());
            data.put("sid", (String)sid.getObject());
            data.put("iface", iface);
            data.put("addr1", String.valueOf(this.ip1_TF.getIPValue()));
            data.put("addr2", String.valueOf(this.ip2_TF.getIPValue()));
            data.put("port1", String.valueOf(this.port1_TF.getText()));
            data.put("port2", String.valueOf(this.port2_TF.getText()));
            data.put("comment", this.comment_TA.getText());
            data.put("service_title", sid.toString());
            data.put("period", this.period_P.getDateString1() + "-" + this.period_P.getDateString2());
            data.put("diffServ", this.diffServ.getText());
            this.data = Utils.pairHashToString(data);
            this.setVisible(false);
        } else if (e.getActionCommand().equals("cancel")) {
            this.data = null;
            this.setVisible(false);
        }
    }

    private void showIfaces() {
        this.iface_CB.removeAllItems();
        String sourceId = ClientUtils.getIdFromComboBox(this.source_CB);
        if (!sourceId.endsWith("0")) {
            Request req = new Request();
            req.setModule("ipn");
            req.setAction("SourceIfaceList");
            req.setModuleId(this.getModuleId());
            req.setAttribute("source_id", sourceId);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                ClientUtils.buildComboBox(this.iface_CB, (Node)XMLUtils.getElement((Document)doc, (String)"list"), (String)"");
            }
        }
        this.iface_CB.insertItemAt((Object)new ComboBoxItem((Object)"-1", "\u043b\u044e\u0431\u043e\u0439"), 0);
        this.iface_CB.setSelectedIndex(0);
    }
}

