/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.table.tree.JTreeTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.GateFilterPanel;
import ru.bitel.bgbilling.modules.ipn.client.GateTreeTableModel;
import ru.bitel.bgbilling.modules.ipn.client.GateTreeTableNode;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class GateSelectPanel
extends BGPanel {
    GateTreeTableModel<GateTreeTableNode> model = new GateTreeTableModel();
    protected JTreeTable tree = new JTreeTable(this.model);
    protected String actionName;
    private String ruleId;
    private String gateId;
    private String gateTypeId;
    private Vector<ActionListener> listeners;
    private GateFilterPanel gateFilter = null;

    public GateSelectPanel(String actionName) {
        try {
            this.actionName = actionName;
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        ((GateTreeTableNode)this.model.getRoot()).setHost("\u0428\u043b\u044e\u0437\u044b");
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.gateFilter = new GateFilterPanel(this);
        this.gateFilter.setVisible(false);
        this.gateFilter.setBorder((Border)new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        JToggleButton filterButton = new JToggleButton("\u0424\u0438\u043b\u044c\u0442\u0440");
        filterButton.setSelected(false);
        filterButton.addActionListener(e -> this.gateFilter.setVisible(filterButton.isSelected()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u043b\u044e\u0437:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.tree), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        JPanel additionalPanel = this.getAdditionalPanel();
        if (additionalPanel != null) {
            panel.add((Component)additionalPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        }
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> {
            String command = e.getActionCommand();
            if (command.equals("ok")) {
                this.okPressed();
            } else {
                this.cancelPressed();
            }
        });
        this.add((Component)((Object)this.gateFilter), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(filterButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(panel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GateSelectPanel.this.okPressed();
                }
            }
        });
    }

    protected JPanel getAdditionalPanel() {
        return null;
    }

    public void setData() throws Exception {
        this.gateFilter.setData();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction(this.actionName);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        this.gateFilter.addFilterParams(request);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.model.load(XMLUtils.selectElement((Node)doc, (String)"//table/data"), null, true);
        }
    }

    protected void okPressed() {
        GateTreeTableNode gateNode = (GateTreeTableNode)this.model.getSelectedNode();
        if (gateNode.isUsed()) {
            ClientUtils.showErrorMessageDialog((String)"\u042d\u0442\u043e\u0442 \u0448\u043b\u044e\u0437 \u0443\u0436\u0435 \u0431\u044b\u043b \u0432\u044b\u0431\u0440\u0430\u043d!");
            return;
        }
        this.gateId = String.valueOf(gateNode.id);
        this.gateTypeId = String.valueOf(gateNode.getTypeId());
        this.ruleId = "0";
        this.fireActionEvent("ok");
    }

    private void cancelPressed() {
        this.fireActionEvent("cancel");
    }

    public void addActionListener(ActionListener al) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(al)) {
            this.listeners.add(al);
        }
    }

    private void fireActionEvent(String command) {
        ActionEvent ae = new ActionEvent((Object)this, 0, command);
        for (ActionListener a : this.listeners) {
            a.actionPerformed(ae);
        }
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setGateId(String gateId) {
        this.gateId = gateId;
    }

    public String getGateId() {
        return this.gateId;
    }

    public void setGateTypeId(String gateTypeId) {
        this.gateTypeId = gateTypeId;
    }

    public String getGateTypeId() {
        return this.gateTypeId;
    }

    public void init(String module, int mid) {
        super.init(module, mid);
        this.gateFilter.init(module, mid);
    }
}

