/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.subscription.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.oss.systems.inventory.subscription.common.bean.Subscription;

public class SubscriptionDao
extends AbstractIdDao<Subscription> {
    public SubscriptionDao(Connection con, int moduleId, int userId) {
        super(con, moduleId, "inv_subscription");
    }

    private Subscription getFromRS(ResultSet rs, boolean titleLoad) throws SQLException {
        Subscription result = new Subscription();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("contractId"));
        result.setServId(rs.getInt("servId"));
        result.setTypeId(rs.getInt("typeId"));
        result.setTimeFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("timeFrom")));
        result.setTimeTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("timeTo")));
        result.setSubscribeMode(rs.getInt("subscriptionModeId"));
        result.setSubscribeTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("subscriptionTime")));
        result.setUnsubscribeTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("unsubscriptionTime")));
        result.setUserId(rs.getInt("userId"));
        if (titleLoad) {
            result.setTypeTitle(rs.getString("type.title"));
        }
        return result;
    }

    protected Subscription getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, false);
    }

    public void update(Subscription subscription, boolean checkDeactivated) throws SQLException {
        this.updateImpl(subscription, checkDeactivated);
    }

    protected void updateImpl(Subscription subscription) throws SQLException {
        this.updateImpl(subscription, true);
    }

    protected void updateImpl(Subscription subscription, boolean checkDeactivated) throws SQLException {
        block22: {
            if (subscription.getId() <= 0) {
                String query = "INSERT INTO " + this.tableName + " (contractId, servId, typeId, subscribeMode, timeFrom, timeTo, subscriptionTime, unsubscriptionTime, userId) VALUES (?,?,?,?,?,?,?,?,?)";
                try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                    int index = 1;
                    ps.setInt(index++, subscription.getContractId());
                    ps.setInt(index++, subscription.getServId());
                    ps.setInt(index++, subscription.getSubscribeMode());
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)subscription.getTimeFrom()));
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)subscription.getTimeTo()));
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)subscription.getSubscribeTime()));
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)subscription.getUnsubscribeTime()));
                    ps.setInt(index++, subscription.getUserId());
                    this.executeUpdate((Id)subscription, index, ps);
                }
            }
            if (subscription.getTimeTo() != null) {
                Object query = "";
                query = checkDeactivated ? "UPDATE " + this.tableName + " SET timeTo=?, unsubscriptionTime=? WHERE id=? AND timeTo IS NULL" : "UPDATE " + this.tableName + " SET timeTo=?, unsubscriptionTime=? WHERE id=?";
                try (PreparedStatement ps = this.con.prepareStatement((String)query);){
                    ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)subscription.getTimeTo()));
                    ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)subscription.getTimeTo()));
                    ps.setInt(3, subscription.getId());
                    if (ps.executeUpdate() == 0) {
                        throw new BGRuntimeException("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u0443\u0436\u0435 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.");
                    }
                    break block22;
                }
            }
            String query = "UPDATE " + this.tableName + " SET timeTo=?, unsubscriptionTime=? WHERE id=? AND (timeTo IS NOT NULL AND unsubscriptionTime IS NOT NULL)";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)subscription.getTimeTo()));
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)subscription.getUnsubscribeTime()));
                ps.setInt(3, subscription.getId());
                if (ps.executeUpdate() == 0) {
                    throw new BGRuntimeException("\u042d\u0442\u0443 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443 \u043d\u0435\u043b\u044c\u0437\u044f \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c!");
                }
            }
        }
    }

    public List<Subscription> list(int contractId, Date time) throws SQLException {
        return this.list(contractId, time, false, true);
    }

    public List<Subscription> list(int contractId, Date date, boolean history, boolean needNonActive) throws SQLException {
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT subscription.*, subscription_type.title FROM ").append(this.tableName).append(" AS subscription");
        sb.append(" LEFT JOIN inv_subscription_type as subscription_type ON subscription.typeId=subscription_type.id ");
        sb.append(" WHERE subscription.contractId=?");
        if (date != null) {
            if (history) {
                sb.append("\n AND (subscription.timeTo IS NOT NULL AND ?>subscription.timeTo)");
            } else {
                sb.append("\n AND (subscription.timeTo IS NULL OR ?<=subscription.timeTo)");
            }
        }
        if (!needNonActive) {
            sb.append("\n AND (subscription.timeTo IS NULL OR subscription.timeFrom<subscription.timeTo)");
        }
        sb.append("\n ORDER BY subscription.timeFrom");
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            ps.setInt(1, contractId);
            if (date != null) {
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)date));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs, true));
                }
            }
        }
        return result;
    }
}

