/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.table.TableModel;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGMaskTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.BGUComboBoxRefresh;
import ru.bitel.common.client.action.BGUAction;
import ru.bitel.common.client.action.DelegateAction;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.IdTitle;

public class BGSwingUtilites {
    public static final String ACTION_EDITOR = "Action.Editor";
    private static Set<Object> editActions = new HashSet<String>(Arrays.asList("new", "edit", "delete"));
    private static Set<Object> defaultActions = new HashSet<String>(Arrays.asList("ok", "refresh", "open", "close"));

    public static List<List<Action>> buildPopupMenu(JComponent component, Container parent) {
        return BGSwingUtilites.buildPopupMenu(component, parent, component.getName(), true);
    }

    public static List<List<Action>> buildPopupMenu(JComponent component, Container parent, String prefix) {
        return BGSwingUtilites.buildPopupMenu(component, parent, prefix, true);
    }

    public static List<List<Action>> buildPopupMenu(final JComponent component, Container parent, String prefix, boolean inChildren) {
        ArrayList<List<Action>> actions = new ArrayList<List<Action>>();
        BGSwingUtilites.buildMenu(parent, actions, prefix, "Action.MenuAction", inChildren);
        if (actions.size() > 0) {
            TableModel tm;
            Set existActions;
            JPopupMenu popupMenu = component.getComponentPopupMenu();
            if (popupMenu == null) {
                existActions = Collections.emptySet();
                popupMenu = new JPopupMenu();
                component.setComponentPopupMenu(popupMenu);
            } else {
                existActions = new HashSet();
                int size = popupMenu.getComponentCount();
                for (int i = 0; i < size; ++i) {
                    Action action;
                    Component comp = popupMenu.getComponent(i);
                    if (comp instanceof JMenu) {
                        JMenu sub = (JMenu)comp;
                        int ssize = sub.getItemCount();
                        for (int si = 0; si < ssize; ++si) {
                            Action action2;
                            comp = sub.getItem(si);
                            if (!(comp instanceof JMenuItem) || (action2 = ((JMenuItem)comp).getAction()) == null) continue;
                            existActions.add(action2);
                        }
                        continue;
                    }
                    if (!(comp instanceof JMenuItem) || (action = ((JMenuItem)comp).getAction()) == null) continue;
                    existActions.add(action);
                }
            }
            BGTableModel model = component instanceof JTable ? ((tm = ((JTable)component).getModel()) instanceof BGTableModel ? (BGTableModel)tm : null) : null;
            int count = 0;
            int isize = actions.size();
            for (int i = 0; i < isize; ++i) {
                int count2 = 0;
                List aa = (List)actions.get(i);
                int jsize = aa.size();
                for (int j = 0; j < jsize; ++j) {
                    Action a = (Action)aa.get(j);
                    if (existActions.contains(a)) continue;
                    if (count2 == 0) {
                        if (i != 0 && count > 0) {
                            popupMenu.addSeparator();
                        }
                        count = 0;
                    }
                    ++count;
                    ++count2;
                    if (model != null) {
                        a = new DelegateAction(a){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                TableModel tm = ((JTable)component).getModel();
                                if (tm instanceof BGTableModel) {
                                    BGTableModel model = (BGTableModel)tm;
                                    e.setSource(model.getSelectedRow());
                                }
                                super.actionPerformed(e);
                            }
                        };
                    }
                    a.putValue("Action.ParentComponent", parent);
                    JMenuItem item = new JMenuItem(a);
                    String tooltip = (String)a.getValue("LongDescription");
                    if (tooltip != null && !"".equals(tooltip)) {
                        item.setToolTipText(tooltip);
                    }
                    popupMenu.add(item);
                }
            }
        }
        return actions;
    }

    public static int buildPopupMenu(JPopupMenu popupMenu, JComponent parent, String prefix) {
        ArrayList<List<Action>> actions = new ArrayList<List<Action>>();
        BGSwingUtilites.buildMenu(parent, actions, prefix, "Action.MenuAction", true);
        if (actions.size() > 0) {
            if (popupMenu.getComponentCount() > 0) {
                popupMenu.add(new JSeparator(0));
            }
            int count = 0;
            int isize = actions.size();
            for (int i = 0; i < isize; ++i) {
                if (i != 0 && count > 0) {
                    popupMenu.addSeparator();
                }
                count = 0;
                List aa = (List)actions.get(i);
                int jsize = aa.size();
                for (int j = 0; j < jsize; ++j) {
                    Action a = (Action)aa.get(j);
                    ++count;
                    a.putValue("Action.ParentComponent", parent);
                    JMenuItem item = new JMenuItem(a);
                    String tooltip = (String)a.getValue("LongDescription");
                    if (tooltip != null && !"".equals(tooltip)) {
                        item.setToolTipText(tooltip);
                    }
                    popupMenu.add(item);
                }
            }
        }
        return actions.size();
    }

    private static void buildMenu(Container comp, List<List<Action>> actions, String prefix, String actionType, boolean inChildren) {
        if (Utils.notBlankString((String)prefix) && !((String)prefix).endsWith(".")) {
            prefix = (String)prefix + ".";
        }
        if (inChildren && comp instanceof JFrame) {
            comp = ((JFrame)comp).getContentPane();
        }
        if (inChildren) {
            int size = comp.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component c = comp.getComponent(i);
                if (!(c instanceof Container)) continue;
                BGSwingUtilites.buildMenu((Container)c, actions, (String)prefix, actionType, inChildren);
            }
        }
        if (comp instanceof JPanel) {
            JPanel c = (JPanel)comp;
            ActionMap map = c.getActionMap();
            if (map.keys() != null) {
                ArrayList<Action> a = null;
                for (Object key : c.getActionMap().keys()) {
                    Action action;
                    if (!key.toString().startsWith((String)prefix) || !Boolean.TRUE.equals((action = c.getActionMap().get(key)).getValue(actionType))) continue;
                    if (a == null) {
                        a = new ArrayList<Action>();
                    }
                    a.add(action);
                }
                if (a != null) {
                    actions.add(a);
                }
            }
        } else if (comp == null) {
            return;
        }
        if (!inChildren) {
            BGSwingUtilites.buildMenu(comp.getParent(), actions, (String)prefix, actionType, inChildren);
        }
    }

    public static JScrollPane wrapScrollPane(JComponent comp, int width, int height) {
        JScrollPane scrollPane = new JScrollPane(comp);
        Dimension dimension = new Dimension(width, height);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        return scrollPane;
    }

    public static JComponent setDimension(JComponent comp, int width, int height) {
        Dimension dimension = new Dimension(width, height);
        comp.setMinimumSize(dimension);
        comp.setPreferredSize(dimension);
        return comp;
    }

    public static JComponent wrapPanel(JComponent comp) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)comp, "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return panel;
    }

    public static JComponent wrapBorder(JComponent comp, String title, boolean needPanel) {
        if (needPanel) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)comp, "Center");
            panel.setBorder(BorderFactory.createCompoundBorder(new BGTitleBorder(title), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            return panel;
        }
        comp.setBorder(BorderFactory.createCompoundBorder(new BGTitleBorder(title), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        return comp;
    }

    public static JComponent wrapBorder(JComponent comp, String title) {
        return BGSwingUtilites.wrapBorder(comp, title, !(comp instanceof JPanel));
    }

    public static JPanel wrapBorder(JPanel comp, String title) {
        return (JPanel)BGSwingUtilites.wrapBorder(comp, title, false);
    }

    public static JComponent wrapEmptyBorder(JComponent comp, boolean needPanel) {
        JComponent component = comp;
        if (needPanel) {
            component = new JPanel(new BorderLayout());
            component.add((Component)comp, "Center");
        }
        component.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return component;
    }

    public static JComponent wrapEmptyBorder(JComponent comp) {
        return BGSwingUtilites.wrapEmptyBorder(comp, !(comp instanceof JPanel));
    }

    public static JComponent wrapRoundedBorder(JComponent component) {
        return BGSwingUtilites.wrapRoundedBorder(component, 10);
    }

    public static JComponent wrapRoundedBorder(JComponent component, int radius) {
        component.setBorder(new RoundedBorder(radius));
        return component;
    }

    public static void handleMouseClicked(Component component, final Consumer<MouseEvent> consumer) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                consumer.accept(e);
            }
        });
    }

    public static void handleRMouseClicked(Component component, final Consumer<MouseEvent> consumer) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    consumer.accept(e);
                } else {
                    super.mouseClicked(e);
                }
            }
        });
    }

    public static void handleLDMouseClicked(Component component, final Consumer<MouseEvent> consumer) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    consumer.accept(e);
                } else {
                    super.mouseClicked(e);
                }
            }
        });
    }

    public static void handleEdit(JTable table, AbstractBGUPanel<?, ?> target) {
        BGSwingUtilites.handleEdit(null, table, target);
    }

    public static void handleEdit(String name, JTable table, AbstractBGUPanel<?, ?> target) {
        BGSwingUtilites.handleEdit(name, table, target, true);
    }

    public static void handleEdit(String name, final JTable table, final AbstractBGUPanel<?, ?> target, final boolean disableOnEdit) {
        Object prefix = Utils.isBlankString(name) ? "" : name + ".";
        table.addMouseListener(new MouseAdapter((String)prefix){
            final /* synthetic */ String val$prefix;
            {
                this.val$prefix = string;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && table.isEnabled()) {
                    target.performAction(this.val$prefix + "edit");
                }
            }
        });
        table.addKeyListener(new KeyAdapter((String)prefix){
            final /* synthetic */ String val$prefix;
            {
                this.val$prefix = string;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getModifiersEx() & 0x80) > 0 && table.isEnabled()) {
                    TableModel tm = table.getModel();
                    JTable source = tm instanceof BGTableModel ? ((BGTableModel)tm).getSelectedRow() : table;
                    if (e.getKeyCode() == 10 && target.performAction(source, this.val$prefix + "edit", "edit")) {
                        e.consume();
                    } else if (e.getKeyCode() == 155 && target.performAction(source, this.val$prefix + "new", "new")) {
                        e.consume();
                    } else if (e.getKeyCode() == 127 && target.performAction(source, this.val$prefix + "delete", "delete")) {
                        e.consume();
                    }
                }
            }
        });
        target.addPropertyChangeListener(new PropertyChangeListener(){
            private JPopupMenu menu;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("edit".equals(evt.getPropertyName()) && disableOnEdit) {
                    if (((Boolean)evt.getOldValue()).booleanValue()) {
                        if (this.menu != null) {
                            table.setComponentPopupMenu(this.menu);
                        }
                    } else if (table.getComponentPopupMenu() != null) {
                        this.menu = table.getComponentPopupMenu();
                        table.setComponentPopupMenu(null);
                    }
                    table.setEnabled((Boolean)evt.getOldValue());
                }
            }
        });
        if (Utils.isBlankString(name)) {
            BGSwingUtilites.buildPopupMenu(table, target);
        } else {
            BGSwingUtilites.buildPopupMenu(table, target, table.getName(), true);
        }
    }

    public static void handleEdit(JTable table, final JPanel target, final String actionKey) {
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Action action;
                if (e.getClickCount() == 2 && (action = target.getActionMap().get(actionKey)) != null) {
                    action.actionPerformed(new ActionEvent(target, 1001, actionKey));
                }
            }
        });
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Action action;
                if (e.getKeyCode() == 10 && (e.getModifiersEx() & 0x80) > 0 && (action = target.getActionMap().get(actionKey)) != null) {
                    action.actionPerformed(new ActionEvent(target, 1001, actionKey));
                    e.consume();
                }
            }
        });
    }

    public static void handleEdit(JTable table, final BGUPanel target, final String action) {
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    target.performAction(action);
                }
            }
        });
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && (e.getModifiersEx() & 0x80) > 0 && target.performAction(action)) {
                    e.consume();
                }
            }
        });
    }

    public static void handleRefresh(AbstractBGUPanel<?, ?> target, Component ... comps) {
        PropertyChangeListener l = evt -> {
            if ("date1|date2|toFirst|toLast|toPrev|toNext|toPage|toSize".contains(evt.getPropertyName())) {
                target.performAction("refresh", "async");
            }
        };
        ActionListener al = e -> target.performAction("refresh", "async");
        for (Component c : comps) {
            if (c instanceof JButton) {
                ((JButton)c).addActionListener(al);
                continue;
            }
            if (c instanceof JComboBox) {
                JComboBox cb = (JComboBox)c;
                cb.addActionListener(al);
                continue;
            }
            if (c instanceof JTextField) {
                ((JTextField)c).addActionListener(al);
                continue;
            }
            c.addPropertyChangeListener(l);
        }
    }

    public static void handleEditorUpdate(BGEditor editor, Object target, String action) {
        ActionListener l = EventHandler.create(ActionListener.class, target, action);
        editor.addActionListener("ok", l);
        editor.addActionListener("delete", l);
    }

    public static void handleEditorUpdate(BGEditor editor, AbstractBGUPanel<?, ?> parent, String action) {
        ActionListener l = e -> {
            if (!editor.isEdit()) {
                parent.performAction(action);
            }
        };
        editor.addActionListener("ok", l);
        editor.addActionListener("delete", l);
    }

    public static void handleEditorUpdate(BGEditor editor, String action) {
        ActionListener l = e -> {
            if (!editor.isEdit()) {
                editor.performAction(action);
            }
        };
        editor.addActionListener("ok", l);
        editor.addActionListener("delete", l);
    }

    public static boolean confirmDelete(String what) {
        return BGSwingUtilites.confirmDelete(what, null);
    }

    public static boolean confirmDelete(String what, Object toDelete) {
        String name = null;
        if (toDelete != null) {
            name = toDelete instanceof IdTitle ? ((IdTitle)toDelete).getTitle() : toDelete.toString();
        }
        what = what != null ? (name != null ? (String)what + " \"" + name + "\"?" : (String)what + "?") : (name != null ? "\"" + name + "\"?" : "\u043e\u0431\u044a\u0435\u043a\u0442?");
        return JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c " + (String)what, "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0;
    }

    public static boolean confirm(String what, Object b) {
        String name = null;
        if (b instanceof IdTitle) {
            name = ((IdTitle)b).getTitle();
        } else if (b != null) {
            name = b.toString();
        }
        return JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), what + (String)(name != null ? " \"" + name + "\"" : "") + "?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0;
    }

    public static boolean confirmDelete(Object toDelete) {
        return BGSwingUtilites.confirmDelete(null, toDelete);
    }

    public static void error(String what) {
        ClientUtils.showErrorMessageDialog(what);
    }

    public static void handlePropertyChanged(Component c, String propertyName, BGUPanel target, String action, Object newValue) {
        c.addPropertyChangeListener(propertyName, e -> {
            if (newValue == null || newValue.equals(e.getNewValue())) {
                target.performAction(action);
            }
        });
    }

    public static void buildToolBar(BGDialogToolBar toolBar, JComponent comp) {
        BGSwingUtilites.buildToolBar(toolBar, comp, "");
    }

    public static void buildToolBar(BGDialogToolBar toolBar, JComponent comp, String prefix) {
        boolean wasEditActions = false;
        for (Action a : BGSwingUtilites.findActions(comp, prefix)) {
            String command = (String)a.getValue("ActionCommandKey");
            if (!prefix.isBlank() && command.startsWith(prefix)) {
                command = command.substring(prefix.length() + 1);
            }
            if (wasEditActions && !editActions.contains(command)) {
                wasEditActions = false;
                toolBar.addSeparator();
            }
            JButton button = toolBar.addButton(a);
            if (!editActions.contains(command)) continue;
            button.setFocusable(false);
            wasEditActions = true;
        }
    }

    public static void buildToolBar(BGDialogToolBar toolBar, JComponent comp, String ... keys) {
        ActionMap actionMap = comp.getActionMap();
        for (String key : keys) {
            Action a = actionMap.get(key);
            if (a != null) {
                toolBar.addButton(a);
                continue;
            }
            int size = comp.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component c = comp.getComponent(i);
                if (!(c instanceof JComponent)) continue;
                BGSwingUtilites.buildToolBar(toolBar, (JComponent)c, keys);
            }
        }
    }

    public static List<Action> findActions(JComponent comp) {
        return BGSwingUtilites.findActions(comp, "");
    }

    public static List<Action> findActions(JComponent comp, String prefix) {
        LinkedHashMap<Object, Action> result = new LinkedHashMap<Object, Action>();
        BGSwingUtilites.findActions(comp, result, prefix);
        return new ArrayList<Action>(result.values());
    }

    private static void findActions(JComponent comp, Map<Object, Action> result, String prefix) {
        ActionMap actionMap = comp.getActionMap();
        if (actionMap != null && actionMap.keys() != null) {
            for (Object key : actionMap.keys()) {
                String k = String.valueOf(key);
                if (!prefix.isEmpty() && !k.startsWith(prefix)) continue;
                k = k.substring(prefix.length());
                if (defaultActions.contains(key) || key.toString().startsWith("common.") || result.containsKey(key)) continue;
                result.put(key, actionMap.get(key));
            }
        }
        int size = comp.getComponentCount();
        for (int i = 0; i < size; ++i) {
            Component c = comp.getComponent(i);
            if (!(c instanceof JComponent)) continue;
            BGSwingUtilites.findActions((JComponent)c, result, prefix);
        }
    }

    public static void bindMenuKeyStrokes(ParameterMap setup, JComponent comp, final JMenuBar menuBar, final JTabbedPane tabbedPane) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.setDefaultFocusTraversalKeys(2, Collections.singleton(KeyStroke.getKeyStroke(38, 512)));
        kfm.setDefaultFocusTraversalKeys(3, Collections.singleton(KeyStroke.getKeyStroke(40, 512)));
        InputMap inputMap = comp.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(49, 128), "menu0");
        inputMap.put(KeyStroke.getKeyStroke(50, 128), "menu1");
        inputMap.put(KeyStroke.getKeyStroke(51, 128), "menu2");
        inputMap.put(KeyStroke.getKeyStroke(52, 128), "menu3");
        inputMap.put(KeyStroke.getKeyStroke(53, 128), "menu4");
        inputMap.put(KeyStroke.getKeyStroke(54, 128), "menu5");
        inputMap.put(KeyStroke.getKeyStroke(55, 128), "menu6");
        inputMap.put(KeyStroke.getKeyStroke(56, 128), "menu7");
        ActionMap actionMap = comp.getActionMap();
        class MenuAction
        extends BGUAction {
            public MenuAction(int menu) {
                super((String)null, (String)null);
                this.putValue("menu", menu);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer num = (Integer)this.getValue("menu");
                if (menuBar.getMenuCount() > num) {
                    menuBar.getMenu(num).doClick();
                }
            }
        }
        actionMap.put("menu0", new MenuAction(0));
        actionMap.put("menu1", new MenuAction(1));
        actionMap.put("menu2", new MenuAction(2));
        actionMap.put("menu3", new MenuAction(3));
        actionMap.put("menu4", new MenuAction(4));
        actionMap.put("menu5", new MenuAction(5));
        actionMap.put("menu6", new MenuAction(6));
        actionMap.put("menu7", new MenuAction(7));
        actionMap.put("menu8", new MenuAction(8));
        tabbedPane.getActionMap().setParent(actionMap);
        menuBar.getActionMap().setParent(actionMap);
        actionMap.put("tab.close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (tabbedPane.getTabCount() > 0 && tabbedPane.getSelectedIndex() >= 0) {
                    tabbedPane.removeTabAt(tabbedPane.getSelectedIndex());
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(115, 128), "tab.close");
        class NextAction
        extends AbstractAction {
            final /* synthetic */ JTabbedPane val$tabbedPane;

            NextAction(JTabbedPane jTabbedPane) {
                this.val$tabbedPane = jTabbedPane;
            }

            protected JTabbedPane getTabbedPane() {
                return this.val$tabbedPane;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JTabbedPane tabbedPane = this.getTabbedPane();
                if (tabbedPane == null) {
                    return;
                }
                int tabCount = tabbedPane.getTabCount();
                int selected = tabbedPane.getSelectedIndex();
                if (tabCount > 0 && selected >= 0) {
                    if (selected == tabCount - 1) {
                        tabbedPane.setSelectedIndex(0);
                    } else {
                        tabbedPane.setSelectedIndex(selected + 1);
                    }
                }
            }
        }
        actionMap.put("tab.switch.next", new NextAction(tabbedPane));
        class PrevAction
        extends AbstractAction {
            final /* synthetic */ JTabbedPane val$tabbedPane;

            PrevAction(JTabbedPane jTabbedPane) {
                this.val$tabbedPane = jTabbedPane;
            }

            protected JTabbedPane getTabbedPane() {
                return this.val$tabbedPane;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JTabbedPane tabbedPane = this.getTabbedPane();
                if (tabbedPane == null) {
                    return;
                }
                int tabCount = tabbedPane.getTabCount();
                int selected = tabbedPane.getSelectedIndex();
                if (tabCount > 0 && selected >= 0) {
                    if (selected == 0) {
                        tabbedPane.setSelectedIndex(tabCount - 1);
                    } else {
                        tabbedPane.setSelectedIndex(selected - 1);
                    }
                }
            }
        }
        actionMap.put("tab.switch.prev", new PrevAction(tabbedPane));
        final LinkedList queue = new LinkedList();
        tabbedPane.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                queue.remove(e.getChild());
                if (queue.size() > 0) {
                    tabbedPane.setSelectedComponent((Component)queue.getLast());
                }
            }
        });
        tabbedPane.getModel().addChangeListener(e -> {
            for (Component cc : queue) {
                if (tabbedPane.indexOfComponent(cc) != -1) continue;
                return;
            }
            Component c = tabbedPane.getSelectedComponent();
            if (c != null) {
                queue.remove(c);
                queue.add(c);
            }
        });
        actionMap.put("tab.current.switch.next", new NextAction(){
            {
                super(jTabbedPane);
            }

            @Override
            protected JTabbedPane getTabbedPane() {
                Component c;
                for (c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); c != null && !(c instanceof JTabbedPane); c = c.getParent()) {
                }
                return (JTabbedPane)c;
            }
        });
        actionMap.put("tab.current.switch.prev", new PrevAction(){
            {
                super(jTabbedPane);
            }

            @Override
            protected JTabbedPane getTabbedPane() {
                Component c;
                for (c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); c != null && !(c instanceof JTabbedPane); c = c.getParent()) {
                }
                return (JTabbedPane)c;
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(93, 512), "tab.current.switch.next");
        inputMap.put(KeyStroke.getKeyStroke(91, 512), "tab.current.switch.prev");
    }

    public static void setEnabled(Component component, boolean enabled) {
        if (component instanceof JTextComponent || component instanceof JComboBox || component instanceof JLabel || component instanceof AbstractButton || component instanceof BGMaskTextField) {
            component.setEnabled(enabled);
        } else if (component instanceof JScrollPane) {
            JScrollPane scroll = (JScrollPane)component;
            BGSwingUtilites.setEnabled(scroll.getViewport().getView(), enabled);
        } else if (component instanceof JPanel) {
            JPanel panel = (JPanel)component;
            int size = panel.getComponentCount();
            for (int i = 0; i < size; ++i) {
                BGSwingUtilites.setEnabled(panel.getComponent(i), enabled);
            }
        }
    }

    public static void clearFields(JComponent ... comps) {
        for (JComponent comp : comps) {
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText("");
                continue;
            }
            if (!(comp instanceof JComboBox)) continue;
            JComboBox combo = (JComboBox)comp;
            if (combo.isEditable()) {
                Component editor = combo.getEditor().getEditorComponent();
                if (!(editor instanceof JTextComponent)) continue;
                ((JTextComponent)editor).setText("");
                continue;
            }
            if (combo.getItemCount() <= 0) continue;
            combo.setSelectedIndex(0);
        }
    }

    public static JLabel createHelpLabel(final String infoText, int border) {
        int borderSize = border < 0 ? 1 : border;
        JLabel helpLabel = new JLabel("?");
        helpLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, borderSize));
        helpLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ClientUtils.showMessageDialog(infoText, "INFO");
            }
        });
        return helpLabel;
    }

    public static void highlighText(JTextComponent textComp, String text) {
        BGSwingUtilites.highlighText(textComp, text, Color.YELLOW, false);
    }

    public static void highlighText(JTextComponent textComp, String text, boolean addHighligh) {
        BGSwingUtilites.highlighText(textComp, text, Color.YELLOW, addHighligh);
    }

    public static void highlighText(JTextComponent textComp, String pattern, Color color, boolean addHighligh) {
        try {
            Document document;
            String text;
            int pos;
            if (Utils.isBlankString(pattern)) {
                return;
            }
            Highlighter highlighter = textComp.getHighlighter();
            if (!addHighligh) {
                highlighter.removeAllHighlights();
            }
            if ((pos = (text = (document = textComp.getDocument()).getText(0, document.getLength())).toUpperCase().indexOf(pattern.toUpperCase())) > 0) {
                textComp.setCaretPosition(pos);
                pos = 0;
            }
            while ((pos = text.toUpperCase().indexOf(pattern.toUpperCase(), pos)) >= 0) {
                highlighter.addHighlight(pos, pos + pattern.length(), new HighlighterPainter(color == null ? Color.YELLOW : color));
                pos += pattern.length();
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public static void comboBoxSelectIdTitle(BGUComboBox<GuiTitlable> comboBox, Consumer<ItemEvent> consumer) {
        comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                consumer.accept(e);
            }
        });
    }

    public static void comboBoxSelectKeyValue1(BGUComboBox<GuiTitlable> comboBox, Consumer<ItemEvent> consumer) {
        comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                consumer.accept(e);
            }
        });
    }

    public static void comboBoxSelectKeyValue(BGUComboBoxRefresh<KeyValue> comboBox, Consumer<ItemEvent> consumer) {
        comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                consumer.accept(e);
            }
        });
    }

    public static void clipboardCopy(String text) {
        StringSelection data = new StringSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(data, data);
    }

    public static class RoundedBorder
    extends AbstractBorder {
        private final int radius;

        public RoundedBorder(int radius) {
            this.radius = radius;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.drawRoundRect(x, y, width - 1, height - 1, this.radius, this.radius);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(this.radius, this.radius, this.radius, this.radius);
        }
    }

    private static class HighlighterPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public HighlighterPainter(Color c) {
            super(c);
        }
    }
}

