/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.modules.inet.common.bean.InetOption;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.function.Lazy;

public class InetOptionRuntime {
    public final int id;
    public final String title;
    public final int parentId;
    public final ParameterMap config;
    public final ParameterMap inheritedConfig;
    public final Set<Integer> siblingIds;
    public final Set<Integer> replaceIds;
    public final Set<Integer> descendantIds;
    final Set<Integer> descendantIds0;
    volatile InetOptionRuntime parent;
    private final Lazy<Map<String, String>> realmPoolMap;

    public InetOptionRuntime(int parentId, InetOption option, ParameterMap config, ParameterMap inheritedConfig, Set<Integer> siblingIds, Set<Integer> replaceIds) {
        this.id = option.getId();
        this.title = option.getTitle();
        this.parentId = parentId;
        this.config = config;
        this.inheritedConfig = inheritedConfig;
        this.siblingIds = Collections.unmodifiableSet(siblingIds);
        this.replaceIds = replaceIds;
        this.descendantIds0 = new HashSet<Integer>();
        this.descendantIds = Collections.unmodifiableSet(this.descendantIds0);
        this.realmPoolMap = Lazy.of(() -> {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map.Entry paramsEntry : inheritedConfig.subKeyed("radius.realm.").entrySet()) {
                String realm = (String)paramsEntry.getKey();
                String pool = ((ParameterMap)paramsEntry.getValue()).get("ipPool", null);
                if (Utils.isBlankString((String)pool) || Utils.isBlankString((String)realm)) continue;
                result.put(realm, pool);
            }
            return result;
        });
    }

    public InetOptionRuntime getParent() {
        return this.parent;
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public Map<String, String> getRealmPoolMap() {
        return (Map)this.realmPoolMap.get();
    }
}

