/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.SessionTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.FrequencyCounter;
import ru.bitel.common.worker.Recyclable;
import ru.bitel.common.worker.ThreadContext;

public class SessionTarifficationWorker
extends AccountingWorkerTask {
    private final SessionTarifficationManager tarifficationManager;
    private long minDeltaAmount;
    private boolean checkAccountingPeriodError;
    private final Iterable<? extends InetConnectionRuntime> sessions;
    private Iterator<? extends InetConnectionRuntime> iterator;
    private final FrequencyCounter tarifficatedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private static final ThreadLocal<Boolean> workerThread = new ThreadLocal();

    public SessionTarifficationWorker(Accounting accounting, ScheduledExecutorService scheduledExecutorService, String name, ParameterMap params, ParameterMap dafaultParams, Iterable<? extends InetConnectionRuntime> sessions) {
        super(scheduledExecutorService, name, params, dafaultParams);
        long minDeltaAmount = params.getLong("minDeltaAmount", dafaultParams.getLong("minDeltaAmount", 0L));
        this.getLogger().info("Add tariffication worker: minDeltaAmount={}, delay={}, batchSize={}", new Object[]{minDeltaAmount, this.getDelay(), this.batchSize});
        this.minDeltaAmount = minDeltaAmount != 0L ? minDeltaAmount : Long.MIN_VALUE;
        this.tarifficationManager = new SessionTarifficationManager(accounting);
        this.sessions = sessions;
        this.checkAccountingPeriodError = params.getBoolean("checkAccountingPeriodError", dafaultParams.getBoolean("checkAccountingPeriodError", false));
    }

    public static boolean isWorkerThread() {
        return workerThread.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl() {
        InetTariffWorkerContext workerContext = new InetTariffWorkerContext(this.tarifficationManager.accounting.setup, this.tarifficationManager.accounting.moduleId);
        ThreadContext parentContext = ThreadContext.push((ThreadContext)workerContext);
        workerThread.set(Boolean.TRUE);
        try {
            this.runImpl(workerContext);
            workerContext.commit();
            if (parentContext != null && parentContext instanceof ServerContext) {
                ((ServerContext)parentContext).commit();
            }
        }
        catch (Exception ex) {
            this.logError("error run session tariffication worker", ex);
        }
        finally {
            workerThread.remove();
            ThreadContext.pop((ThreadContext)workerContext, (ThreadContext)parentContext);
            if (parentContext != null && parentContext instanceof Recyclable) {
                ((Recyclable)parentContext).recycle();
            }
        }
    }

    private void runImpl(InetTariffWorkerContext workerContext) {
        this.getLogger().trace("Run tariffication...");
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.sessions.iterator();
        }
        long start = System.currentTimeMillis();
        Long hour = InetUtils.getHour(start);
        ConnectionSet connectionSet = workerContext.getConnectionSet();
        int count = 0;
        int batchSize = this.batchSize;
        while (count < batchSize && this.iterator.hasNext()) {
            InetConnectionRuntime connectionRuntime = this.iterator.next();
            if (this.getLogger().isTraceEnabled()) {
                MDC.put((String)"contractId", (String)String.valueOf(connectionRuntime.contractId));
                MDC.put((String)"inetServId", (String)String.valueOf(connectionRuntime.inetServId));
                MDC.put((String)"sessionId", (String)String.valueOf(connectionRuntime.sessionId));
                Optional.ofNullable(connectionRuntime.connection).ifPresent(a -> MDC.put((String)"connectionId", (String)String.valueOf(a.getId())));
            }
            if (this.process0(workerContext, connectionSet, this.tarifficationManager, connectionRuntime, hour, start, this.minDeltaAmount, false, 100L, this.checkAccountingPeriodError).booleanValue()) {
                ++count;
            }
            if (!this.getLogger().isTraceEnabled()) continue;
            MDC.clear();
        }
        long stop = System.currentTimeMillis();
        long duration = stop - start;
        this.tarifficatedPerMinute.add(stop, (long)count);
        this.processTimePerMinute.add(stop, duration);
        this.processTimePerTenMinutes.add(stop, duration);
        this.invokePerMinute.add(stop, 1L);
        this.invokePerTenMinutes.add(stop, 1L);
        if (count > 0 && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Tarifficated " + count + " sessions for " + duration + " ms.");
        }
    }

    @MBeanAttribute
    public long getTarifficatedPerMinute() {
        return this.tarifficatedPerMinute.get(System.currentTimeMillis());
    }
}

