/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.task;

import java.io.Serializable;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGNotImplementedException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.CashCheckUtils;
import ru.bitel.bgbilling.plugins.cashcheck.server.CheckMaker;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.Check;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PrinterManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class AdvancePayments
extends TaskBase {
    private LocalDate month = null;
    private List<Integer> contractsIds = null;

    public String getDescription() {
        return this.defaultDescription + "\u041f\u043b\u0430\u0433\u0438\u043d CashCheck. \u0417\u0430\u0434\u0430\u0447\u0430 \u0437\u0430\u0447\u0451\u0442\u0430 \u0430\u0432\u0430\u043d\u0441\u043e\u0432.";
    }

    public void setManual(LocalDate month, List<Integer> contractsIds) {
        this.month = month;
        this.contractsIds = Utils.notEmptyCollection(contractsIds) ? contractsIds : null;
    }

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             Connection conSlave = this.setup.getDBSlaveConnectionFromPool();){
            if (this.is_makeCheckZA(con)) {
                CashCheckUtils.sendAlarm("ZA.error", 0, "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u0441\u0442\u0430\u0440\u0430\u044f \u0441\u0445\u0435\u043c\u0430!", "\u0414\u0438\u043d.\u043a\u043e\u0434 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d \u043d\u0430 makeCheckZA, \u043d\u0430\u0434\u043e \u0441\u0440\u043e\u0447\u043d\u043e \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 makeCheckAdvancePayments, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c (\u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e)", null);
                this.process_old(con, conSlave);
            } else {
                this.process(con, conSlave);
            }
        }
        catch (Exception e) {
            this.getLogger().error("error AdvancePayments task", (Throwable)e);
            this.error = e;
        }
    }

    protected void process(final Connection con, Connection conSlave) throws BGException {
        if (this.month == null) {
            this.month = LocalDate.now().minusMonths(1L);
        }
        this.getLogger().info("cashcheck: ZA: month " + TimeUtils.format((LocalDate)this.month, (String)"MM.yyyy") + ", " + (Serializable)(this.contractsIds != null ? Integer.valueOf(this.contractsIds.size()) : "all") + " contracts");
        PrinterManager.resetCache();
        long t0 = System.currentTimeMillis();
        final AtomicInteger checkCount = new AtomicInteger(0);
        CheckMaker dynCheckBuilder = CashCheckUtils.getCheckMaker(this.setup, con, conSlave, null, null);
        CheckMaker.CheckCallback checkCallback = new CheckMaker.CheckCallback(){

            @Override
            public void print(Check check, Printer printer, int contractId) {
                try {
                    CashCheckUtils.printCheckVirtual(check, printer, con, -1, "\u0417\u0410", contractId);
                    checkCount.incrementAndGet();
                }
                catch (BGException e) {
                    AdvancePayments.this.getLogger().error("cashcheck: ZA: ERROR (printer #" + printer.getId() + "): " + e.getMessage());
                    CashCheckUtils.sendAlarm("ZA.error", printer.getId(), "\u043e\u0448\u0438\u0431\u043a\u0430 \u0447\u0435\u043a\u0430 \u0437\u0430\u0447\u0451\u0442\u0430 \u0430\u0432\u0430\u043d\u0441\u0430 (\u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u043f\u0435\u0447\u0430\u0442\u0438)", "", e);
                }
            }
        };
        try {
            dynCheckBuilder.makeCheckAdvancePayments(this.month, this.contractsIds, checkCallback);
        }
        catch (BGNotImplementedException e) {
            this.getLogger().error("cashcheck: ZA: not implemented: " + e.getMessage());
        }
        catch (BGException e) {
            this.getLogger().error("cashcheck: ZA: ERROR run dynamic code: " + e.getMessage(), (Throwable)e);
            CashCheckUtils.sendAlarm("ZA.error", 0, "\u043e\u0448\u0438\u0431\u043a\u0430 \u0447\u0435\u043a\u0430 \u0437\u0430\u0447\u0451\u0442\u0430 \u0430\u0432\u0430\u043d\u0441\u0430 (\u0434\u0438\u043d.\u043a\u043e\u0434)", "", e);
        }
        this.getLogger().info("cashcheck: ZA: " + checkCount + " check complete! " + (System.currentTimeMillis() - t0) + " ms");
    }

    protected void process_old(Connection con, Connection conSlave) throws BGException {
        if (this.month == null) {
            this.month = LocalDate.now().minusMonths(1L);
        }
        this.getLogger().info("cashcheck: ZA: month " + TimeUtils.format((LocalDate)this.month, (String)"MM.yyyy") + ", " + (Serializable)(this.contractsIds != null ? Integer.valueOf(this.contractsIds.size()) : "all") + " contracts");
        PrinterManager.resetCache();
        long t0 = System.currentTimeMillis();
        int checkCount = 0;
        CheckMaker dynCheckBuilder = CashCheckUtils.getCheckMaker(this.setup, con, conSlave, null, null);
        for (Contract contract : CashCheckUtils.getContractsWithBalance(con, this.month)) {
            if (this.contractsIds != null && !this.contractsIds.contains(contract.getId())) continue;
            Printer printer = Printer.empty();
            try {
                Check check = new Check(Check.Type.PAYMENT);
                if (!dynCheckBuilder.makeCheckZA(contract, check, printer, this.month)) continue;
                CashCheckUtils.printCheckVirtual(check, printer, con, -1, "\u0417\u0410", contract.getId());
                ++checkCount;
            }
            catch (BGNotImplementedException e) {
                this.getLogger().error("cashcheck: ZA: BREAK, not implemented: " + e.getMessage());
                break;
            }
            catch (BGException e) {
                this.getLogger().error("cashcheck: ZA: ERROR (printer #" + printer.getId() + "): " + e.getMessage());
                CashCheckUtils.sendAlarm("ZA.error", 0, "\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430 \u0437\u0430\u0447\u0451\u0442\u0430 \u0430\u0432\u0430\u043d\u0441\u0430", "", e);
            }
        }
        this.getLogger().info("cashcheck: ZA: " + checkCount + " check complete! " + (System.currentTimeMillis() - t0) + " ms");
    }

    private boolean is_makeCheckZA(Connection con) {
        try {
            CheckMaker dynCheckBuilder = CashCheckUtils.getCheckMaker(this.setup, con, con, null, null);
            dynCheckBuilder.makeCheckZA(null, new Check(Check.Type.PAYMENT), Printer.empty(), this.month);
            return true;
        }
        catch (BGNotImplementedException e) {
            return false;
        }
        catch (Exception ignore) {
            return true;
        }
    }
}

