/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.BillPositionType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class PositionPanel
extends BGUPanel {
    protected BGUTable table = null;
    protected PositionTableModel model = null;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.getTable()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected BGUTable getTable() {
        if (this.table == null) {
            this.table = new BGUTable((TableModel)((Object)this.getTableModel()));
            this.table.setSelectionMode(0);
            BGSwingUtilites.handleEdit((JTable)this.table, (BGUPanel)this, (String)"edit");
        }
        return this.table;
    }

    protected PositionTableModel getTableModel() {
        if (this.model == null) {
            this.model = new PositionTableModel(PositionTableModel.class.getName());
        }
        return this.model;
    }

    protected BillPositionType getBillPositionType() {
        return null;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(((BillService)((ClientContext)this.getContext()).getWebService(BillService.class)).positionSearch(this.getBillPositionType(), null).stream().map(s -> new PositionData((String)s)).toList())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            PositionData positionData = new PositionData("{\"awlz\": \"0\",\"insum\": \"1\"}");
            this.getPositionDialog("\u041d\u043e\u0432\u0430\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u044f", positionData).setVisible(true);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            PositionData positionData = (PositionData)this.getTableModel().getSelectedRow();
            if (positionData != null) {
                this.getPositionDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u043e\u0437\u0438\u0446\u0438\u0438", positionData).setVisible(true);
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            String key;
            PositionData positionData = (PositionData)this.getTableModel().getSelectedRow();
            if (positionData != null && ClientUtils.confirmDelete((Object)(key = positionData.getJson().optString("key")))) {
                ((BillService)((ClientContext)this.getContext()).getWebService(BillService.class)).positionDataDelete(this.getBillPositionType(), key);
                this.performAction("refresh");
            }
        });
    }

    protected JDialog getPositionDialog(String dialogTitle, PositionData positionData) {
        BGTextField key = new BGTextField(50);
        BGTextField title = new BGTextField(50);
        BGTextField name = new BGTextField(50);
        BGTextField summ = new BGTextField(50);
        BGTextField quantity = new BGTextField(50);
        BGTextField qtynums = new BGTextField(50);
        BGTextField unit = new BGTextField(50);
        BGTextField unitCode = new BGTextField(50);
        BGTextField extractor = new BGTextField(50);
        BGTextField extractorMacros = new BGTextField(50);
        JCheckBox insum = new JCheckBox("\u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u043f\u043e\u0437\u0438\u0446\u0438\u044e \u0432 \u0441\u0443\u043c\u043c\u0443 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
        JCheckBox awlz = new JCheckBox("\u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043f\u0440\u0438 \u0441\u0443\u043c\u043c\u0435 0");
        JCheckBox superContract = new JCheckBox("\u0441\u0443\u043f\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        JCheckBox dependContract = new JCheckBox("\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0445 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        JCheckBox independContract = new JCheckBox("\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0445 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        JPanel includePanel = new JPanel(new GridBagLayout());
        includePanel.add((Component)superContract, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        includePanel.add((Component)dependContract, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        includePanel.add((Component)independContract, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        Component[][] components = new Component[][]{{new JLabel("\u041a\u043b\u044e\u0447:"), key}, {new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), title}, {new JLabel("\u0422\u0435\u043a\u0441\u0442 \u043f\u043e\u0437\u0438\u0446\u0438\u0438:"), name}, {new JLabel("\u0421\u0443\u043c\u043c\u0430:"), summ}, {new JLabel("\u041e\u0431\u044a\u0435\u043c \u0443\u0441\u043b\u0443\u0433\u0438:"), quantity}, {new JLabel("\u041e\u043a\u0440\u0443\u0433. \u043e\u0431\u044a\u0435\u043c\u0430 \u0443\u0441\u043b\u0443\u0433\u0438:"), qtynums}, {new JLabel("\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f:"), unit}, {new JLabel("\u041a\u043e\u0434 \u0435\u0434\u0438\u043d\u0438\u0446\u044b \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f:"), unitCode}, {new JLabel("Extractor:"), extractor}, {new JLabel("ExtractorClassName([param1[,param2[,...]]]):"), extractorMacros}, {new JLabel("\u041d\u0435 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0442\u044c \u0434\u043b\u044f:"), includePanel}, {new JLabel(""), insum}, {new JLabel(""), awlz}};
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        ClientUtils.addComponentToPanel((JPanel)panel, (int)gridy, (Component[][])components, (boolean)true);
        JSONObject json = positionData.getJson();
        key.setText(json.optString("key"));
        title.setText(json.optString("title"));
        name.setText(json.optString("name"));
        summ.setText(json.optString("summ"));
        quantity.setText(json.optString("quantity"));
        qtynums.setText(json.optString("qtynums"));
        unit.setText(json.optString("unit"));
        unitCode.setText(json.optString("unitCode"));
        extractor.setText(json.optString("extractor"));
        extractorMacros.setText(json.optString("dynclass"));
        insum.setSelected("1".equals(json.optString("insum")));
        awlz.setSelected("1".equals(json.optString("awlz")));
        int notApply = Utils.parseInt((String)json.optString("notApply"));
        superContract.setSelected((notApply & 1) > 0);
        dependContract.setSelected((notApply & 2) > 0);
        independContract.setSelected((notApply & 4) > 0);
        BGOptionPane optionPane = new BGOptionPane((Object)panel, dialogTitle);
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            boolean error = Utils.isBlankString((String)key.getText());
            boolean bl = error = error || Utils.isBlankString((String)title.getText());
            if (error) {
                ClientUtils.showErrorMessageDialog((String)"\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u043f\u043e\u043b\u044f \"\u041a\u043b\u044e\u0447\" \u0438 \"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\"");
                return;
            }
            try {
                json.put("key", (Object)key.getText());
                json.put("title", (Object)title.getText());
                json.put("name", (Object)name.getText());
                json.put("summ", (Object)summ.getText());
                json.put("quantity", (Object)quantity.getText());
                json.put("qtynums", (Object)qtynums.getText());
                json.put("unit", (Object)unit.getText());
                json.put("unitCode", (Object)unitCode.getText());
                json.put("extractor", (Object)extractor.getText());
                json.put("dynclass", (Object)extractorMacros.getText());
                json.put("insum", (Object)(insum.isSelected() ? "1" : "0"));
                json.put("awlz", (Object)(awlz.isSelected() ? "1" : "0"));
                json.put("notApply", (Object)String.valueOf(0 | (superContract.isSelected() ? 1 : 0) | (dependContract.isSelected() ? 2 : 0) | (independContract.isSelected() ? 4 : 0)));
                ((BillService)((ClientContext)this.getContext()).getWebService(BillService.class)).positionDataUpdate(this.getBillPositionType(), json.toString());
                this.performAction("refresh");
                dialog.setVisible(false);
                dialog.dispose();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        return dialog;
    }

    class PositionTableModel
    extends BGTableModel<PositionData> {
        public PositionTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041a\u043b\u044e\u0447", 100, 100, 100, "key", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 300, 500, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0435\u043a\u0441\u0442 \u043f\u043e\u0437\u0438\u0446\u0438\u0438", 100, 100, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 100, 100, -1, "summ", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(PositionData positionData, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("id".equals(identifier)) {
                return positionData.getJson().optInt("id");
            }
            if ("key".equals(identifier) || "title".equals(identifier) || "name".equals(identifier) || "summ".equals(identifier)) {
                return positionData.getJson().optString(identifier);
            }
            return super.getValueAt((Object)positionData, column);
        }
    }

    public class PositionData {
        private String data;
        private JSONObject json;

        public PositionData(String data) {
            this.data = data;
        }

        private JSONObject getJson() {
            if (this.json == null) {
                this.json = new JSONObject(this.data);
            }
            return this.json;
        }
    }
}

