/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.simplepay.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.bean.BGAbstractTransaction;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.simplepay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.simplepay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.simplepay.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.bean.TransactionUtils;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@WebServlet(name="SimplePayExecutor", urlPatterns={"/simplepay/*"})
public class ModuleExecutor
extends CommonExecutor {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            String transactionId = request.getParameter("sp_order_id");
            String result = request.getParameter("sp_result");
            String outSum = request.getParameter("sp_amount");
            String signatureValue = request.getParameter("sp_sig");
            String responseString = null;
            String secretKey = moduleSetup.get("simplepay.result.secret.key", moduleSetup.get("simplepay.secret.key", ""));
            if (transactionId != null && outSum != null && signatureValue != null) {
                StringBuilder parameters = new StringBuilder();
                ArrayList<String> sortedKeys = new ArrayList<String>();
                Enumeration enumeration = request.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    String name = (String)enumeration.nextElement();
                    if (!"sp_sig".equals(name)) {
                        sortedKeys.add(name);
                    }
                    parameters.append(name).append("=").append(request.getParameter(name)).append("\n");
                }
                Collections.sort(sortedKeys);
                StringBuilder signData = new StringBuilder(String.valueOf(moduleId)).append(";");
                for (String key : sortedKeys) {
                    signData.append(request.getParameter(key)).append(";");
                }
                signData.append(secretKey);
                String checkSignData = Utils.getDigest((String)signData.toString(), (String)"UTF-8").toLowerCase();
                if (signatureValue.equals(checkSignData)) {
                    String errorMessage;
                    TransactionManager transactionManager = new TransactionManager(con, moduleId);
                    Transaction transaction = (Transaction)transactionManager.get(Utils.parseInt((String)transactionId));
                    if (transaction == null) {
                        errorMessage = "Not found transaction for ID = " + transactionId;
                        this.getLogger().error(errorMessage);
                        responseString = this.sendResponse(moduleId, "error", null, errorMessage, secretKey);
                    }
                    if (responseString == null && transaction.getPaymentId() > 0) {
                        errorMessage = "Transaction for ID = " + transactionId + " has paymentId > 0";
                        this.getLogger().error(errorMessage);
                        responseString = this.sendResponse(moduleId, "ok", null, null, secretKey);
                    }
                    if (responseString == null) {
                        transaction.setSum(new BigDecimal(outSum));
                        transaction.setTransactionId(transactionId);
                        transaction.setTransactionDate(new Date());
                        transaction.setParameters(parameters.toString());
                        if (result != null && "1".equals(result)) {
                            transaction.setStatus(TransactionStatus.OK.getCode());
                            TransactionUtils.addPaymentWithCommissionInContract((Connection)con, (BGAbstractTransaction)transaction, (int)moduleId, (int)moduleSetup.getInt("simplepay.payment.type.id", 0), (String)moduleSetup.get("simplepay.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u0441\u0435\u0440\u0432\u0438\u0441 SimplePay [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())), (int)moduleSetup.getInt("simplepay.commission.type", 0), (int)moduleSetup.getInt("simplepay.commission.charge.type.id", 0), (BigDecimal)moduleSetup.getBigDecimal("simplepay.commission.percent", BigDecimal.ZERO), (String)moduleSetup.get("simplepay.commission.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 SimplePay ( \u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f ) [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())));
                        } else {
                            transaction.setStatus(TransactionStatus.ERROR.getCode());
                            transaction.setPaymentId(-1);
                        }
                        transactionManager.update(transaction);
                        responseString = this.sendResponse(moduleId, "ok", null, null, secretKey);
                    }
                } else {
                    String errorMessage = "Error check sign (in request check = '" + signatureValue + "' no equals calculate = '" + checkSignData + "' )";
                    this.getLogger().error(errorMessage);
                    responseString = this.sendResponse(moduleId, "error", null, errorMessage, secretKey);
                }
            } else {
                String errorMessage = "Error request param (sp_order_id=" + transactionId + "; sp_amount=" + outSum + "; sp_sig=" + signatureValue + ")";
                this.getLogger().error(errorMessage);
                responseString = this.sendResponse(moduleId, "error", null, errorMessage, secretKey);
            }
            response.setContentType("text/xml; charset=utf-8");
            try (PrintWriter out = response.getWriter();){
                out.print(responseString);
                out.flush();
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private String sendResponse(int moduleId, String status, String description, String errorDescription, String secretKey) throws Exception {
        String salt = Utils.getDigest((String)String.valueOf(System.currentTimeMillis()), (String)"UTF-8");
        Document doc = XMLUtils.newDocument();
        Element rootNode = doc.createElement("response");
        doc.appendChild(rootNode);
        XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)rootNode, (String)"sp_status"), (String)status);
        if (description != null) {
            XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)rootNode, (String)"sp_description"), (String)description);
        }
        if (errorDescription != null) {
            XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)rootNode, (String)"sp_error_description"), (String)errorDescription);
        }
        XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)rootNode, (String)"sp_salt"), (String)salt);
        StringBuffer signData = new StringBuffer(String.valueOf(moduleId)).append(";");
        if (description != null) {
            signData.append(description).append(";");
        }
        if (errorDescription != null) {
            signData.append(errorDescription).append(";");
        }
        signData.append(salt).append(";");
        signData.append(status).append(";");
        signData.append(secretKey);
        XMLUtils.createTextNode((Node)XMLUtils.createElement((Element)rootNode, (String)"sp_sig"), (String)Utils.getDigest((String)signData.toString(), (String)"UTF-8").toLowerCase());
        return XMLUtils.serializeToString((Node)doc.getDocumentElement(), (boolean)true);
    }
}

