/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn.detail;

import bitel.billing.server.netflow.ipn.detail.RowSelector;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.common.bean.IpNet;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowSelector;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTask;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class DialUpRowSelector
implements RowSelector {
    private DetailCreateTask task;
    private long sessionStart;
    private long sessionEnd;
    private long sessionIp;
    private List<IpNet> routeNetList;

    public DialUpRowSelector(DetailCreateTask task, ParameterMap params) {
        this.task = task;
        this.sessionStart = task.getSessionStart().getTimeInMillis();
        this.sessionEnd = task.getSessionEnd().getTimeInMillis() + (long)(1000 * params.getInt("delay.stop", 5));
        this.sessionIp = task.getDialupSessionIp();
        if (task.getDialupNetList() != null && task.getDialupNetList().size() > 0) {
            this.routeNetList = task.getDialupNetList();
        }
    }

    public FlowSelector.Result test(long hour, Data flow) {
        long timestamp = flow.getMilliseconds();
        if (this.sessionStart <= timestamp && timestamp <= this.sessionEnd) {
            long srcAddress = flow.getSrcAddress();
            long dstAddress = flow.getDstAddress();
            if (srcAddress == this.sessionIp) {
                return RESULT_OK_OUT;
            }
            if (dstAddress == this.sessionIp) {
                return RESULT_OK_IN;
            }
            if (this.routeNetList != null) {
                for (IpNet net : this.routeNetList) {
                    if ((net.mask & srcAddress) == net.net) {
                        return RESULT_OK_OUT;
                    }
                    if ((net.mask & dstAddress) != net.net) continue;
                    return RESULT_OK_IN;
                }
            } else {
                return RESULT_ERROR_TIMESTAMPOUT;
            }
        }
        return RESULT_ERROR;
    }

    @Override
    public List<Calendar> getLogHours() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        Calendar hour = (Calendar)this.task.getSessionStart().clone();
        Calendar sessionEnd = this.task.getSessionEnd();
        while (TimeUtils.hourDelta((Calendar)hour, (Calendar)sessionEnd) >= 0) {
            result.add(hour);
            hour = (Calendar)hour.clone();
            hour.add(11, 1);
        }
        return result;
    }

    @Override
    public String getFileName() {
        StringBuilder fileName = new StringBuilder();
        fileName.append("detail");
        fileName.append("_");
        fileName.append(TimeUtils.format((Calendar)this.task.getSessionStart(), (String)"dd.MM.yyyy_HH:mm:ss"));
        fileName.append("_");
        fileName.append(TimeUtils.format((Calendar)this.task.getSessionEnd(), (String)"dd.MM.yyyy_HH:mm:ss"));
        return fileName.toString();
    }
}

