/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.action.web;

import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.modules.phone.common.bean.PhoneItemListMode;
import ru.bitel.bgbilling.modules.phone.common.bean.PhoneItemListNumber;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemManager;
import ru.bitel.bgbilling.modules.phone.server.service.BlacklistServiceImpl;
import ru.bitel.common.Utils;

public class ActionPhoneLists
extends AbstractAction {
    @Resource
    private BlacklistServiceImpl ws;

    public ActionPhoneLists() {
        super("phone");
    }

    public void execute() throws BGException {
        List<ClientItem> itemList = new ClientItemManager(this.con, this.moduleId).getItemList(this.contractId, 1, false);
        this.setResultParam("phone_items", itemList);
        int itemId = this.req.getInt("selectedItem", -1);
        if (itemId <= 0) {
            return;
        }
        ArrayList<PhoneItemListMode.ModeWrapper> wrappers = new ArrayList<PhoneItemListMode.ModeWrapper>();
        for (PhoneItemListMode.Mode m : PhoneItemListMode.Mode.values()) {
            wrappers.add(new PhoneItemListMode.ModeWrapper(m));
        }
        this.setResultParam("modes", wrappers);
        PhoneItemListMode mode = this.ws.getMode(itemId);
        this.setResultParam("currentMode", new PhoneItemListMode.ModeWrapper(mode.getMode()));
        List<PhoneItemListNumber> numbers = this.ws.getNumbersForItem(itemId);
        this.setResultParam("numbers", numbers);
        this.setResultParam("selectedItem", itemId);
    }

    public void updateMode() throws BGException {
        int itemId = this.req.getInt("selectedItem", -1);
        if (itemId <= 0) {
            throw new BGIllegalArgumentException();
        }
        int newMode = this.req.getInt("mode", 0);
        PhoneItemListMode mode = this.ws.getMode(itemId);
        if (mode.getMode().ordinal() != newMode) {
            mode.setMode(PhoneItemListMode.Mode.getByOrdinal((int)newMode));
            this.ws.updateMode(mode);
        }
        this.execute();
    }

    public void updateNumbers() throws BGException {
        String input = this.req.get("numbers", "");
        String[] split = input.split(",");
        int itemId = this.req.getInt("selectedItem", -1);
        if (itemId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ArrayList<PhoneItemListNumber> numbers = new ArrayList<PhoneItemListNumber>();
        for (String s : split) {
            if (Utils.isBlankString((String)s)) continue;
            PhoneItemListNumber n = new PhoneItemListNumber();
            n.setPhoneItemId(itemId);
            n.setNumber(s);
            numbers.add(n);
        }
        this.ws.updateNumbers(itemId, numbers);
        this.execute();
    }
}

