/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.card.server.bean.CardAction;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class CardActionManager {
    private Connection con;
    private int mid;
    private String tableName;

    public CardActionManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.tableName = "card_action_" + mid;
    }

    public void updateAction(CardAction action) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (action.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " SET type=?, dtime=?, dealer_id=?, count=?, summ=?, cost=?";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.tableName + " SET type=?, dtime=?, dealer_id=?, count=?, summ=?, cost=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(7, action.getId());
            }
            ps.setInt(1, action.getType());
            ps.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)action.getTime()));
            ps.setInt(3, action.getDealerId());
            ps.setInt(4, action.getCardCount());
            ps.setFloat(5, action.getCardSumma());
            ps.setFloat(6, action.getCost());
            ps.executeUpdate();
            if (action.getId() <= 0) {
                action.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CardAction getActionById(int id) {
        CardAction result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getActionFromRs(rs, false);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public List<CardAction> getActionList(int dealerId, Date fromDate, Date toDate, int type) {
        return this.getActionList(dealerId, new Period(fromDate, toDate), type);
    }

    public List<CardAction> getActionList(int dealerId, Period period, int type) {
        ArrayList<CardAction> result = new ArrayList<CardAction>();
        try {
            int index = 1;
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT action.*, dealer.title FROM ");
            query.append(this.tableName);
            query.append(" AS action ");
            query.append(" LEFT JOIN card_dealer_");
            query.append(this.mid);
            query.append(" AS dealer ON action.dealer_id=dealer.id");
            query.append(" WHERE 1>0");
            if (dealerId > 0) {
                query.append(" AND action.dealer_id=?");
            }
            if (type > 0) {
                query.append(" AND action.type=?");
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND action.dtime>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND action.dtime<?");
                }
            }
            query.append(" ORDER BY dtime");
            ps = this.con.prepareStatement(query.toString());
            if (dealerId > 0) {
                ps.setInt(index++, dealerId);
            }
            if (type > 0) {
                ps.setInt(index++, type);
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                }
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getActionFromRs(rs, true));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteAction(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CardAction getActionFromRs(ResultSet rs, boolean loadDealerTitle) throws Exception {
        CardAction result = new CardAction();
        result.setId(rs.getInt("id"));
        result.setDealerId(rs.getInt("dealer_id"));
        if (loadDealerTitle) {
            result.setDealerTitle(rs.getString("title"));
        }
        result.setType(rs.getInt("type"));
        result.setTime(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp("dtime")));
        result.setCardCount(rs.getInt("count"));
        result.setCardSumma(rs.getFloat("summ"));
        result.setCost(rs.getFloat("cost"));
        return result;
    }
}

