/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.resource;

import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.servlet.ServletContext;
import jakarta.xml.ws.WebServiceContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ContainerContext;
import ru.bitel.bgbilling.kernel.container.resource.JDBCResourceAdapter;
import ru.bitel.bgbilling.kernel.container.resource.ResourceAdapter;
import ru.bitel.bgbilling.kernel.container.resource.ServiceResourceAdapter;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;

public class ResourceManager
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger();
    private static Map<Class<?>, ResourceAdapter<? super Object>> resourceAdapterMap = new ConcurrentHashMap();
    public static final JDBCResourceAdapter JDBC_RESOURCE_ADAPTER;
    public static final ServiceResourceAdapter SERVICE_RESOURCE_ADAPTER;
    private List<Entry> entries = new ArrayList<Entry>(8);
    private Map<String, Object> keyMap = null;
    private Map<Class<?>, Object> typeMap = null;

    public void inject(ContainerContext ctx, Object t, int moduleId) throws Exception {
        for (Class<?> clazz = t.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field f : clazz.getDeclaredFields()) {
                Resource r = f.getAnnotation(Resource.class);
                if (r == null) continue;
                this.inject(ctx, t, clazz, moduleId, r, f);
            }
        }
    }

    private void inject(ContainerContext ctx, Object t, Class<?> clazz, int moduleId, Resource resource, Field f) throws Exception {
        Class fieldClass = f.getType();
        if (fieldClass.equals(WebServiceContext.class) || fieldClass.equals(ServletContext.class)) {
            if (!f.isAccessible() && (f.getModifiers() & 1) == 0) {
                f.setAccessible(true);
            }
            if (f.get(t) != null) {
                return;
            }
        }
        Class resourceClass = resource.type() != Object.class ? resource.type() : fieldClass;
        ResourceAdapter<Object> ra = resourceAdapterMap.get(resourceClass);
        Object o = null;
        if (ra != null) {
            o = ra.borrow(ctx, moduleId, resource, clazz, resourceClass, fieldClass, t);
        } else if (resource != null) {
            String name = resource.name();
            if (!"".equals(name)) {
                if ("ws".equals(name)) {
                    ra = SERVICE_RESOURCE_ADAPTER;
                    o = ra.borrow(ctx, moduleId, resource, clazz, resourceClass, fieldClass, t);
                } else {
                    if (this.keyMap != null) {
                        o = this.keyMap.get(name);
                    }
                    if (o == null && this.typeMap != null) {
                        o = this.typeMap.get(resourceClass);
                    }
                    if (o == null) {
                        try {
                            o = ctx.getNamingContext().lookup(name);
                        }
                        catch (NamingException e) {
                            o = ctx.getEnvironment().lookup(name);
                        }
                    }
                }
            } else if (fieldClass.getAnnotation(WebService.class) != null) {
                ra = SERVICE_RESOURCE_ADAPTER;
                o = ra.borrow(ctx, moduleId, resource, clazz, resourceClass, fieldClass, t);
            } else {
                if (this.typeMap != null) {
                    o = this.typeMap.get(resourceClass);
                }
                if (o == null) {
                    try {
                        o = ctx.getNamingContext().lookup(resourceClass.getSimpleName());
                    }
                    catch (NamingException e) {
                        o = ctx.getEnvironment().lookup(resourceClass.getSimpleName());
                    }
                }
            }
            if (o instanceof ResourceAdapter) {
                ra = (ResourceAdapter)o;
                o = ra.borrow(ctx, moduleId, resource, clazz, resourceClass, fieldClass, t);
            }
        }
        logger.debug("Inject to " + f + " " + o);
        if (o != null) {
            if (!f.isAccessible() && (f.getModifiers() & 1) == 0) {
                f.setAccessible(true);
            }
            if (ra != null) {
                this.entries.add(new Entry(t, f, o, (ResourceAdapter<? super Object>)ra));
            }
            f.set(t, o);
        }
    }

    public void commit() {
        int size = this.entries.size();
        for (int i = 0; i < size; ++i) {
            Entry e = this.entries.get(i);
            e.resourceAdapter.commit(e.resource);
        }
    }

    @Override
    public void close() {
        int size = this.entries.size();
        for (int i = 0; i < size; ++i) {
            Entry e = this.entries.get(i);
            e.resourceAdapter.recycle(e.resource);
        }
        this.entries.clear();
    }

    public void register(ResourceAdapter<?> ra, Object resource) {
        this.entries.add(new Entry(null, null, resource, ra));
    }

    public void register(Class<?> clazz, String key, Object resource) {
        if (clazz != null) {
            if (this.typeMap == null) {
                this.typeMap = new HashMap(8);
            }
            this.typeMap.put(clazz, resource);
        }
        if (key != null) {
            if (this.keyMap == null) {
                this.keyMap = new HashMap<String, Object>(8);
            }
            this.keyMap.put(key, resource);
        }
    }

    static {
        Context env = null;
        try {
            env = DefaultServerSetup.getEnvironment();
        }
        catch (NamingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        JDBC_RESOURCE_ADAPTER = new JDBCResourceAdapter(env);
        SERVICE_RESOURCE_ADAPTER = new ServiceResourceAdapter();
    }

    final class Entry {
        final Object bean;
        final Field field;
        final Object resource;
        final ResourceAdapter<? super Object> resourceAdapter;

        public Entry(Object bean, Field field, Object resource, ResourceAdapter<? super Object> resourceAdapter) {
            this.bean = bean;
            this.field = field;
            this.resource = resource;
            this.resourceAdapter = resourceAdapter;
        }
    }
}

