/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff.voice;

import bitel.billing.module.common.BGSelectFilePanel;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.tariff.voice.ServiceConfigGeographicCode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ImportEditor
extends JPanel {
    private ServiceConfigGeographicCode panel;
    private JRadioButton fileSource = new JRadioButton("\u0438\u0437 \u0444\u0430\u0439\u043b\u0430");
    private JRadioButton clipSource = new JRadioButton("\u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430");
    private JCheckBox addNew = new JCheckBox("\u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u043e\u0432\u044b\u0435");
    private JCheckBox updateExist = new JCheckBox("\u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435");
    private JTextArea clipArea = new JTextArea();
    private IntTextField prefix = new IntTextField();
    private BGSelectFilePanel fileSelect = new BGSelectFilePanel();

    public ImportEditor(ServiceConfigGeographicCode panel) {
        this.panel = panel;
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        ButtonGroup sourceGroup = new ButtonGroup();
        sourceGroup.add(this.fileSource);
        sourceGroup.add(this.clipSource);
        this.fileSource.setSelected(true);
        this.clipArea.setEnabled(false);
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.add((Component)new JLabel("\u0412\u0437\u044f\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.fileSource, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.clipSource, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("\u041e\u043f\u0446\u0438\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0430: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.addNew, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.updateExist, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("\u0424\u0430\u0439\u043b:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.fileSelect, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u0435\u0444\u0438\u043a\u0441:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
        this.add((Component)this.prefix, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(3, 5, 0, 3), 0, 0));
        JScrollPane clipScroll = new JScrollPane(this.clipArea);
        clipScroll.setMinimumSize(new Dimension(100, 300));
        clipScroll.setPreferredSize(new Dimension(100, 300));
        this.add((Component)new JLabel("\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0431\u0443\u0444\u0435\u0440\u0430:"), new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)clipScroll, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 5, 5), 0, 0));
    }

    public void startEdit() {
        try {
            this.clipArea.setText((String)this.getToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(true);
    }

    private void stopEdit(boolean doImport) {
        if (doImport) {
            String data = null;
            boolean addNew = this.addNew.isSelected();
            boolean updateExist = this.updateExist.isSelected();
            if (this.fileSource.isSelected()) {
                File file = this.fileSelect.getSelectedFile();
                if (file == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
                    return;
                }
                try {
                    data = new String(Utils.readByBlock(new FileInputStream(file)), "UTF-8");
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
                    return;
                }
            } else {
                data = this.clipArea.getText();
            }
            if (this.panel.loadFromFile(data, this.prefix.getText(), addNew, updateExist)) {
                this.panel.setData();
                this.setVisible(false);
            }
        }
        this.setVisible(false);
    }
}

